/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.fusionchart.render;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.Dates;
import org.zkoss.zkmax.zul.ChartProperties;
import org.zkoss.zkmax.zul.fusionchart.GanttTableRenderer;
import org.zkoss.zkmax.zul.fusionchart.config.CategoriesPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.ChartPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.GanttChartCategoriesPropertiesList;
import org.zkoss.zkmax.zul.fusionchart.config.GanttChartConfig;
import org.zkoss.zkmax.zul.fusionchart.config.GanttChartHeaderPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.GanttChartSeriesPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.GanttTableConfig;
import org.zkoss.zkmax.zul.fusionchart.config.MilestonePropertiesList;
import org.zkoss.zkmax.zul.fusionchart.config.ProcessPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.PropertiesProxy;
import org.zkoss.zkmax.zul.fusionchart.config.TrendLinePropertiesList;
import org.zkoss.zkmax.zul.fusionchart.impl.Utils;
import org.zkoss.zkmax.zul.fusionchart.render.ChartColor;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.GanttModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.XYModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderUtils {
    public static final void renderPieSet(StringBuffer sb, int index, Comparable<?> category, Number value, CategoriesPropertiesMap config, String uuid) {
        sb.append("<set name='").append(category).append("'").append(Utils.renderFusionchartAttr("value", value));
        if (uuid != null) {
            RenderUtils.addClientEventInvok(sb, uuid, 0, index);
        }
        if (config != null) {
            Utils.renderChartProperties(sb, PropertiesProxy.getProperties(config, index, category));
        }
        sb.append(" color='").append(ChartColor.getColor(index)).append("'/>");
    }

    public static final void renderCategory(StringBuffer sb, Collection<?> c, ChartPropertiesMap config) {
        sb.append("<categories");
        if (config != null) {
            Utils.renderChartProperties(sb, config);
        }
        sb.append(">");
        int index = 0;
        for (Comparable category : c) {
            sb.append("<category name='").append(Utils.escapeXML(category.toString())).append("'");
            if (config != null) {
                Utils.renderChartProperties(sb, PropertiesProxy.getProperties(config, index, category));
            }
            sb.append("/>");
            ++index;
        }
        sb.append("</categories>");
    }

    private static final void renderSeriesBegin(StringBuffer sb, int index, Comparable<?> series, ChartPropertiesMap config) {
        sb.append("<dataset seriesName='").append(Utils.escapeXML(series.toString())).append("'");
        if (config != null) {
            Utils.renderChartProperties(sb, PropertiesProxy.getProperties(config, index, series));
        }
        sb.append(" color='").append(ChartColor.getColor(index)).append("'>");
    }

    public static final void renderSeries(StringBuffer sb, CategoryModel model, ChartPropertiesMap config, String uuid) {
        Collection cates = model.getCategories();
        int sIndex = 0;
        for (Comparable series : model.getSeries()) {
            RenderUtils.renderSeriesBegin(sb, sIndex, series, config);
            int cIndex = 0;
            for (Comparable category : cates) {
                RenderUtils.renderDataset(sb, sIndex, cIndex, series, category, model.getValue(series, category), config, uuid);
                ++cIndex;
            }
            sb.append("</dataset>");
            ++sIndex;
        }
    }

    private static void renderDataset(StringBuffer sb, int seriesIndex, int categoryIndex, Comparable<?> series, Comparable<?> category, Number value, ChartPropertiesMap config, String uuid) {
        sb.append("<set").append(Utils.renderFusionchartAttr("value", value));
        if (uuid != null) {
            RenderUtils.addClientEventInvok(sb, uuid, seriesIndex, categoryIndex);
        }
        if (config != null) {
            Utils.renderChartProperties(sb, PropertiesProxy.getDatasetProperties(seriesIndex, categoryIndex, series, category, config));
        }
        sb.append("/>");
    }

    public static final void renderXYSeries(StringBuffer sb, XYModel model, Set<?> xSet, Map<?, ?> seriesMap, ChartPropertiesMap config, String uuid) {
        int sIndex = 0;
        for (Comparable series : model.getSeries()) {
            Map indexMap = (Map)seriesMap.get(series);
            RenderUtils.renderSeriesBegin(sb, sIndex, series, config);
            int cIndex = 0;
            for (Number x : xSet) {
                Object o = indexMap.get(x);
                if (o == null) {
                    sb.append("<set/>");
                    continue;
                }
                cIndex = (Integer)o;
                RenderUtils.renderDataset(sb, sIndex, cIndex, series, (Comparable)((Object)x), model.getY(series, cIndex), config, uuid);
            }
            sb.append("</dataset>");
            ++sIndex;
        }
    }

    public static void renderCategories(StringBuffer sb, GanttChartCategoriesPropertiesList config) {
        int j = config.size();
        for (int i = 0; i < j; ++i) {
            GanttChartCategoriesPropertiesList.GanttChartCategoriesProperties props = config.getCategoriesProperties(i);
            sb.append("<categories");
            Utils.renderChartProperties(sb, props).append(">");
            Collection<List> keys = PropertiesProxy.getCategoryKeys(props);
            for (List key : keys) {
                ChartProperties cProps = props.getCategoryProperties((String)key.get(0), (Date)key.get(1), (Date)key.get(2));
                sb.append("<category");
                Utils.renderChartProperties(sb, cProps).append("/>");
            }
            sb.append("</categories>");
        }
    }

    public static final void renderMonthHeaders(StringBuffer sb, TimeZone tz, Date startDate, Date endDate, GanttChartHeaderPropertiesMap config) {
        String mFmt = GanttChartHeaderPropertiesMap.DEFAULT_MONTH_FORMAT;
        int period = 2;
        if (config != null) {
            mFmt = config.getDateFormater();
            period = config.getPeriod();
        }
        SimpleDateFormat df = new SimpleDateFormat(mFmt);
        sb.append("<categories");
        if (config != null) {
            Utils.renderChartProperties(sb, config);
        }
        sb.append(">");
        if (period != 5) {
            startDate = Dates.beginOfMonth((Date)startDate, (TimeZone)tz);
            endDate = Dates.endOfMonth((Date)endDate, (TimeZone)tz);
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTime(startDate);
        int i = 0;
        do {
            sb.append("<category name='").append(Utils.escapeXML(df.format(startDate))).append("'").append(Utils.renderFusionchartDate("start", startDate));
            cal.add(period, 1);
            cal.add(5, -1);
            sb.append(Utils.renderFusionchartDate("end", cal.getTime()));
            if (config != null) {
                Utils.renderChartProperties(sb, PropertiesProxy.getProperties(config, i, GanttChartHeaderPropertiesMap.getKey(startDate, cal.getTime())));
            }
            sb.append("/>");
            cal.add(5, 1);
            startDate = cal.getTime();
            ++i;
        } while (startDate.before(endDate));
        sb.append("</categories>");
    }

    public static final void renderProcess(StringBuffer sb, Set<?> processSet, Map<?, ?> processIDMap, ProcessPropertiesMap config) {
        sb.append("<processes");
        if (config != null) {
            Utils.renderChartProperties(sb, config);
        }
        sb.append(">");
        int index = 0;
        for (String taskName : processSet) {
            sb.append("<process name='").append(Utils.escapeXML(taskName)).append("' id='").append(processIDMap.get(taskName)).append("'");
            if (config != null) {
                Utils.renderChartProperties(sb, PropertiesProxy.getProperties(config, index, taskName));
            }
            sb.append("/>");
            ++index;
        }
        sb.append("</processes>");
    }

    public static final void renderTasksBegin(StringBuffer sb, GanttChartConfig config) {
        sb.append("<tasks");
        if (config != null) {
            Utils.renderChartProperties(sb, PropertiesProxy.getTasksProperties(config));
        }
        sb.append(">");
    }

    public static final void renderTasks(StringBuffer sb, GanttModel model, Map<?, ?> processIDMap, GanttChartConfig config, String uuid) {
        Comparable[] allseries = model.getAllSeries();
        int seriesSize = allseries.length;
        int height = 0;
        int padding = 0;
        if (seriesSize > 0) {
            height = 40 / seriesSize;
            padding = 10 / (seriesSize + 1);
        }
        GanttChartSeriesPropertiesMap sConfig = null;
        if (config != null) {
            sConfig = PropertiesProxy.getSeriesConfig(config);
        }
        RenderUtils.renderTasksBegin(sb, config);
        int j = allseries.length;
        for (int i = 0; i < j; ++i) {
            Comparable series = allseries[i];
            GanttModel.GanttTask[] tasks = model.getTasks(series);
            int l = tasks.length;
            for (int k = 0; k < l; ++k) {
                GanttModel.GanttTask task = tasks[k];
                String taskName = task.getDescription();
                Integer processId = (Integer)processIDMap.get(taskName);
                sb.append("<task name='").append(Utils.escapeXML(series.toString())).append("' id='").append(processId).append("_").append(k).append("' processId='").append(processId).append("'").append(Utils.renderFusionchartDate("start", task.getStart())).append(Utils.renderFusionchartDate("end", task.getEnd()));
                if (uuid != null) {
                    RenderUtils.addClientEventInvok(sb, uuid, i, k);
                }
                if (sConfig != null) {
                    Utils.renderChartProperties(sb, PropertiesProxy.getTaskProperties(i, k, series, taskName, sConfig));
                    Utils.renderChartProperties(sb, PropertiesProxy.getProperties(sConfig, i, series));
                }
                sb.append(" height='").append(height).append("' topPadding='").append(padding + (padding + height) * i).append("' color='").append(ChartColor.getColor(i)).append("'/>");
            }
        }
        sb.append("</tasks>");
    }

    public static final void renderGenttTable(StringBuffer sb, ListModel<Object> model, GanttTableRenderer<Object> renderer, GanttTableConfig config) {
        if (renderer == null) {
            renderer = RenderUtils.getDefalutRenderer();
        }
        GanttTableConfig.GanttTableColumnPropertiesMap cConfig = null;
        if (config != null) {
            cConfig = PropertiesProxy.getColumnConfig(config);
        }
        List<List<ChartProperties>> columnList = RenderUtils.createColumnList(model, renderer);
        Utils.renderChartProperties(sb.append("<dataTable"), config.getChartProperties()).append(">");
        int cIndex = 0;
        for (List<ChartProperties> labels : columnList) {
            sb.append("<dataColumn");
            GanttTableConfig.GanttTableColumnProperties cprops = null;
            if (cConfig != null) {
                cprops = cConfig.getColumnProperties(cIndex);
                Utils.renderChartProperties(sb, cprops);
            }
            sb.append(">");
            int tIndex = 0;
            Iterator<ChartProperties> it2 = labels.iterator();
            while (it2.hasNext()) {
                sb.append("<text");
                if (cprops != null) {
                    Utils.renderChartProperties(sb, cprops.getTextProperties(tIndex));
                }
                Utils.renderChartProperties(sb, it2.next()).append("/>");
                ++tIndex;
            }
            sb.append("</dataColumn>");
            ++cIndex;
        }
        sb.append("</dataTable>");
    }

    private static GanttTableRenderer<Object> getDefalutRenderer() {
        return new DefalutRenderer();
    }

    private static List<List<ChartProperties>> createColumnList(ListModel<Object> model, GanttTableRenderer<Object> renderer) {
        ArrayList<List<ChartProperties>> columnList = new ArrayList<List<ChartProperties>>(4);
        int j = model.getSize();
        for (int i = 0; i < j; ++i) {
            GanttTableConfig.GanttRowPropertiesList row = new GanttTableConfig.GanttRowPropertiesList();
            try {
                renderer.render(row, model.getElementAt(i));
            }
            catch (Exception e) {
                row.createLabel(Exceptions.getMessage((Throwable)e));
            }
            int l = row.size();
            for (int k = 0; k < l; ++k) {
                ArrayList<ChartProperties> labels = null;
                try {
                    labels = (ArrayList<ChartProperties>)columnList.get(k);
                }
                catch (IndexOutOfBoundsException e) {
                    labels = new ArrayList<ChartProperties>(13);
                    columnList.add(labels);
                }
                labels.add(row.getCellProperties(k));
            }
        }
        return columnList;
    }

    public static final StringBuffer addClientEventInvok(StringBuffer sb, String uuid, int sIndex, int cIndex) {
        return sb.append(" link=\"JavaScript:zk.Widget.$('").append(uuid).append("').clickChart('").append(sIndex).append("','").append(cIndex).append("');\"");
    }

    public static final void renderTrendLine(StringBuffer sb, TrendLinePropertiesList config) {
        if (config == null) {
            return;
        }
        int size = config.size();
        if (size == 0) {
            return;
        }
        Utils.renderChartProperties(sb.append("<trendlines"), config).append(">");
        for (int i = 0; i < size; ++i) {
            Utils.renderChartProperties(sb.append("<line"), config.getTrendLine(i)).append("/>");
        }
        sb.append("</trendlines>");
    }

    public static final void renderMilestone(StringBuffer sb, Map<?, ?> taskIDMap, MilestonePropertiesList config) {
        if (config == null) {
            return;
        }
        int size = config.size();
        if (size == 0) {
            return;
        }
        sb.append("<milestones");
        Utils.renderChartProperties(sb, config).append(">");
        for (int i = 0; i < size; ++i) {
            ChartProperties milestone = config.getMilestone(i);
            sb.append("<milestone taskId='").append(taskIDMap.get(PropertiesProxy.getTask(i, config))).append("'");
            Utils.renderChartProperties(sb, milestone).append("/>");
        }
        sb.append("</milestones>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefalutRenderer
    implements GanttTableRenderer<Object> {
        private static final long serialVersionUID = 20110717110710L;

        @Override
        public void render(GanttTableConfig.GanttRowPropertiesList row, Object data) throws Exception {
            row.createLabel(String.valueOf(data));
        }
    }
}

