/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.fusionchart.impl;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zkmax.zul.Fusionchart;
import org.zkoss.zkmax.zul.fusionchart.FusionchartEngine;
import org.zkoss.zkmax.zul.fusionchart.config.AbstractChartConfig;
import org.zkoss.zkmax.zul.fusionchart.config.CategoriesPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.CategoryChartConfig;
import org.zkoss.zkmax.zul.fusionchart.config.ChartPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.GanttChartConfig;
import org.zkoss.zkmax.zul.fusionchart.config.GanttChartHeaderPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.GanttTableConfig;
import org.zkoss.zkmax.zul.fusionchart.config.PieChartConfig;
import org.zkoss.zkmax.zul.fusionchart.config.ProcessPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.PropertiesProxy;
import org.zkoss.zkmax.zul.fusionchart.config.SeriesPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.XYChartConfig;
import org.zkoss.zkmax.zul.fusionchart.impl.Utils;
import org.zkoss.zkmax.zul.fusionchart.render.RenderUtils;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.GanttModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.PieModel;
import org.zkoss.zul.XYModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFusionchartEngine
implements FusionchartEngine<Object>,
Serializable {
    private static final long serialVersionUID = 20110319195510L;
    private transient boolean _threeD;
    private transient String _type;
    private transient ChartImpl _chartImpl;

    @Override
    public String createChartXML(Object data) {
        Fusionchart chart = (Fusionchart)((Object)data);
        return this.getChartImpl(chart).createChartXML(chart);
    }

    private ChartImpl getChartImpl(Fusionchart chart) {
        this._type = chart.getType();
        this._threeD = chart.isThreeD();
        String errMsg = "";
        String orient = chart.getOrient();
        if ("pie".equals(this._type)) {
            this._chartImpl = new Pie();
        } else if ("bar".equals(this._type) || "stacked_bar".equals(this._type) || "combination".equals(this._type)) {
            if (this._threeD && "horizontal".equals(orient)) {
                errMsg = orient + " " + this._type;
            }
            this._chartImpl = new Bar();
        } else if ("line".equals(this._type)) {
            if (this._threeD) {
                errMsg = this._type;
            }
            this._chartImpl = new Line();
        } else if ("area".equals(this._type)) {
            if (this._threeD) {
                errMsg = this._type;
            }
            this._chartImpl = new AreaImpl();
        } else if ("stacked_area".equals(this._type)) {
            if (this._threeD) {
                errMsg = this._type;
            }
            this._chartImpl = new StackedArea();
        } else if ("gantt".equals(this._type)) {
            if (this._threeD) {
                errMsg = this._type;
            }
            this._chartImpl = new Gantt();
        } else {
            throw new UiException("Unsupported chart type yet: " + this._type);
        }
        if (!Strings.isBlank((String)errMsg)) {
            throw new UiException("Unsupported chart type yet: " + errMsg + " in threeD.");
        }
        return this._chartImpl;
    }

    private StringBuffer convertPieModelToPieDataset(StringBuffer sb, String uuid, PieModel model, PieChartConfig config) {
        CategoriesPropertiesMap cateConfig = config == null ? null : PropertiesProxy.getCategoryConfig(config);
        int index = 0;
        for (Comparable category : model.getCategories()) {
            RenderUtils.renderPieSet(sb, index, category, model.getValue(category), cateConfig, uuid);
            ++index;
        }
        return sb;
    }

    private StringBuffer convertCategoryModelToPieDataset(StringBuffer sb, String uuid, CategoryModel model, PieChartConfig config) {
        CategoriesPropertiesMap cateConfig = config == null ? null : PropertiesProxy.getCategoryConfig(config);
        Collection cates = model.getCategories();
        Comparable defaultSeries = null;
        int max = 0;
        for (List key : model.getKeys()) {
            Comparable series = (Comparable)key.get(0);
            if (defaultSeries == null) {
                defaultSeries = series;
                max = cates.size();
            }
            if (!Objects.equals((Object)defaultSeries, (Object)series)) continue;
            Comparable category = (Comparable)key.get(1);
            int cIndex = ((List)cates).indexOf(category);
            if (uuid != null) {
                RenderUtils.addClientEventInvok(sb, uuid, 0, cIndex);
            }
            RenderUtils.renderPieSet(sb, cIndex, category, model.getValue(series, category), cateConfig, uuid);
            if (--max != 0) continue;
            break;
        }
        return sb;
    }

    private StringBuffer convertCategoryModelToCategoryDataset(StringBuffer sb, String uuid, CategoryModel model, CategoryChartConfig config) {
        CategoriesPropertiesMap cateConfig = null;
        SeriesPropertiesMap serConfig = null;
        if (config != null) {
            cateConfig = PropertiesProxy.getCategoryConfig(config);
            serConfig = PropertiesProxy.getSeriesPropertiesMap(config);
        }
        RenderUtils.renderCategory(sb, model.getCategories(), cateConfig);
        RenderUtils.renderSeries(sb, model, serConfig, uuid);
        if (config != null) {
            RenderUtils.renderTrendLine(sb, PropertiesProxy.getTrendLineConfig(config));
        }
        return sb;
    }

    private StringBuffer convertXYModelToXYDataset(StringBuffer sb, String uuid, XYModel model, CategoryChartConfig config) {
        SeriesPropertiesMap seriesPropertiesMap = null;
        ChartPropertiesMap cateConfig = null;
        if (config != null) {
            seriesPropertiesMap = PropertiesProxy.getSeriesPropertiesMap(config);
            cateConfig = config instanceof XYChartConfig ? PropertiesProxy.getXAxisPropertiesMap((XYChartConfig)config) : PropertiesProxy.getCategoryConfig(config);
        }
        HashMap seriesMap = new HashMap();
        AbstractSet xSet = null;
        xSet = model.isAutoSort() ? new TreeSet() : new LinkedHashSet(13);
        Collection serieses = model.getSeries();
        for (Comparable series : serieses) {
            int size = model.getDataCount(series);
            TreeMap<Number, Integer> indexMap = new TreeMap<Number, Integer>();
            for (int j = 0; j < size; ++j) {
                Number x = model.getX(series, j);
                xSet.add(x);
                indexMap.put(x, new Integer(j));
            }
            seriesMap.put(series, indexMap);
        }
        RenderUtils.renderCategory(sb, xSet, cateConfig);
        RenderUtils.renderXYSeries(sb, model, xSet, seriesMap, seriesPropertiesMap, uuid);
        if (config != null) {
            RenderUtils.renderTrendLine(sb, PropertiesProxy.getTrendLineConfig(config));
        }
        return sb;
    }

    private StringBuffer convertGanttModelToGanttDataset(StringBuffer sb, String uuid, GanttModel model, GanttChartConfig config, TimeZone tz) {
        Comparable[] allseries = model.getAllSeries();
        LinkedHashSet<String> processSet = new LinkedHashSet<String>(13);
        HashMap<String, Integer> processIDMap = new HashMap<String, Integer>(13);
        HashMap<GanttModel.GanttTask, String> taskIDMap = new HashMap<GanttModel.GanttTask, String>(30);
        long startLong = Long.MAX_VALUE;
        long endLong = Long.MIN_VALUE;
        int j = allseries.length;
        int processId = 0;
        for (int i = 0; i < j; ++i) {
            Comparable series = allseries[i];
            GanttModel.GanttTask[] tasks = model.getTasks(series);
            int l = tasks.length;
            for (int k = 0; k < l; ++k) {
                GanttModel.GanttTask task = tasks[k];
                String taskName = task.getDescription();
                startLong = Math.min(startLong, task.getStart().getTime());
                endLong = Math.max(endLong, task.getEnd().getTime());
                if (!processSet.contains(taskName)) {
                    processIDMap.put(taskName, new Integer(processId++));
                    processSet.add(taskName);
                }
                String taskID = processIDMap.get(taskName) + "_" + k;
                taskIDMap.put(task, taskID);
            }
        }
        GanttChartHeaderPropertiesMap hConfig = null;
        ProcessPropertiesMap pConfig = null;
        if (config != null) {
            hConfig = PropertiesProxy.getHeaderConfig(config);
            pConfig = PropertiesProxy.getProcessConfig(config);
            RenderUtils.renderCategories(sb, PropertiesProxy.getCategoriesConfig(config));
        }
        RenderUtils.renderMonthHeaders(sb, tz, new Date(startLong), new Date(endLong), hConfig);
        RenderUtils.renderProcess(sb, processSet, processIDMap, pConfig);
        RenderUtils.renderTasks(sb, model, processIDMap, config, uuid);
        if (config != null) {
            RenderUtils.renderTrendLine(sb, PropertiesProxy.getTrendLineConfig(config));
            RenderUtils.renderMilestone(sb, taskIDMap, PropertiesProxy.getMilestoneConfig(config));
        }
        return sb;
    }

    private class Gantt
    extends ChartImpl {
        private Gantt() {
        }

        protected StringBuffer renderDataset(StringBuffer sb, String uuid, ChartModel model, AbstractChartConfig config, TimeZone tz) {
            GanttChartConfig gConfig;
            GanttChartConfig ganttChartConfig = gConfig = config instanceof GanttChartConfig ? (GanttChartConfig)config : null;
            if (model instanceof GanttModel) {
                return SimpleFusionchartEngine.this.convertGanttModelToGanttDataset(sb, uuid, (GanttModel)model, gConfig, tz);
            }
            throw new UiException("The model of gantt chart must be a org.zkoss.zul.GanttModel");
        }

        public void renderMoreData(StringBuffer sb, Fusionchart chart) {
            ListModel tModel = chart.getTableModel();
            if (tModel != null) {
                AbstractChartConfig config = chart.getChartConfig();
                GanttTableConfig tConfig = null;
                if (config instanceof GanttChartConfig) {
                    tConfig = PropertiesProxy.getTableConfig((GanttChartConfig)config);
                }
                RenderUtils.renderGenttTable(sb, tModel, chart.getTableRenderer(), tConfig);
            }
        }

        protected String getChartTag() {
            return "chart";
        }

        protected StringBuffer renderProperties(StringBuffer sb, Fusionchart chart) {
            return super.renderProperties(sb, chart).append(" dateFormat='MM/dd/yyyy'");
        }
    }

    private class StackedArea
    extends AxisLableChart {
        private StackedArea() {
        }

        protected StringBuffer renderDataset(StringBuffer sb, String uuid, ChartModel model, AbstractChartConfig config, TimeZone tz) {
            CategoryChartConfig cConfig;
            CategoryChartConfig categoryChartConfig = cConfig = config instanceof CategoryChartConfig ? (CategoryChartConfig)config : null;
            if (model instanceof CategoryModel) {
                return SimpleFusionchartEngine.this.convertCategoryModelToCategoryDataset(sb, uuid, (CategoryModel)model, cConfig);
            }
            if (model instanceof XYModel) {
                return SimpleFusionchartEngine.this.convertXYModelToXYDataset(sb, uuid, (XYModel)model, cConfig);
            }
            throw new UiException("The model of stacked_area chart must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class Line
    extends AxisLableChart {
        private Line() {
        }

        protected StringBuffer renderDataset(StringBuffer sb, String uuid, ChartModel model, AbstractChartConfig config, TimeZone tz) {
            CategoryChartConfig cConfig;
            CategoryChartConfig categoryChartConfig = cConfig = config instanceof CategoryChartConfig ? (CategoryChartConfig)config : null;
            if (model instanceof CategoryModel) {
                return SimpleFusionchartEngine.this.convertCategoryModelToCategoryDataset(sb, uuid, (CategoryModel)model, cConfig);
            }
            if (model instanceof XYModel) {
                return SimpleFusionchartEngine.this.convertXYModelToXYDataset(sb, uuid, (XYModel)model, cConfig);
            }
            throw new UiException("The model of line chart must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class AreaImpl
    extends AxisLableChart {
        private AreaImpl() {
        }

        protected StringBuffer renderDataset(StringBuffer sb, String uuid, ChartModel model, AbstractChartConfig config, TimeZone tz) {
            CategoryChartConfig cConfig;
            CategoryChartConfig categoryChartConfig = cConfig = config instanceof CategoryChartConfig ? (CategoryChartConfig)config : null;
            if (model instanceof CategoryModel) {
                return SimpleFusionchartEngine.this.convertCategoryModelToCategoryDataset(sb, uuid, (CategoryModel)model, cConfig);
            }
            if (model instanceof XYModel) {
                return SimpleFusionchartEngine.this.convertXYModelToXYDataset(sb, uuid, (XYModel)model, cConfig);
            }
            throw new UiException("The model of area chart must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class Bar
    extends AxisLableChart {
        private Bar() {
        }

        protected StringBuffer renderDataset(StringBuffer sb, String uuid, ChartModel model, AbstractChartConfig config, TimeZone tz) {
            CategoryChartConfig cConfig;
            CategoryChartConfig categoryChartConfig = cConfig = config instanceof CategoryChartConfig ? (CategoryChartConfig)config : null;
            if (model instanceof CategoryModel) {
                return SimpleFusionchartEngine.this.convertCategoryModelToCategoryDataset(sb, uuid, (CategoryModel)model, cConfig);
            }
            if (model instanceof XYModel) {
                return SimpleFusionchartEngine.this.convertXYModelToXYDataset(sb, uuid, (XYModel)model, cConfig);
            }
            throw new UiException("The model of bar chart must be a org.zkoss.zul.CategoryModel or a org.zkoss.zul.XYModel");
        }
    }

    private class Pie
    extends ChartImpl {
        private Pie() {
        }

        protected StringBuffer renderDataset(StringBuffer sb, String uuid, ChartModel model, AbstractChartConfig config, TimeZone tz) {
            PieChartConfig pConfig;
            PieChartConfig pieChartConfig = pConfig = config instanceof PieChartConfig ? (PieChartConfig)config : null;
            if (model instanceof CategoryModel) {
                return SimpleFusionchartEngine.this.convertCategoryModelToPieDataset(sb, uuid, (CategoryModel)model, pConfig);
            }
            if (model instanceof PieModel) {
                return SimpleFusionchartEngine.this.convertPieModelToPieDataset(sb, uuid, (PieModel)model, pConfig);
            }
            throw new UiException("The model of pie chart must be a org.zkoss.zul.PieModel or a org.zkoss.zul.CategoryModel");
        }

        protected StringBuffer renderProperties(StringBuffer sb, Fusionchart chart) {
            return super.renderProperties(sb, chart).append(" shownames='1'");
        }
    }

    private abstract class AxisLableChart
    extends ChartImpl {
        private AxisLableChart() {
        }

        protected StringBuffer renderProperties(StringBuffer sb, Fusionchart chart) {
            return super.renderProperties(sb, chart).append(Utils.renderFusionchartAttr("xaxisname", chart.getXAxis())).append(Utils.renderFusionchartAttr("yaxisname", chart.getYAxis()));
        }
    }

    private abstract class ChartImpl {
        private ChartImpl() {
        }

        protected String createChartXML(Fusionchart chart) {
            String tag = this.getChartTag();
            StringBuffer sb = new StringBuffer();
            this.renderProperties(sb.append("<").append(tag), chart).append(">");
            String uuid = null;
            if (Events.isListened((Component)chart, (String)"onClick", (boolean)false)) {
                uuid = chart.getUuid();
            }
            this.renderDataset(sb, uuid, chart.getModel(), chart.getChartConfig(), chart.getTimeZone());
            this.renderMoreData(sb, chart);
            sb.append("</").append(tag).append(">");
            return sb.toString();
        }

        protected abstract StringBuffer renderDataset(StringBuffer var1, String var2, ChartModel var3, AbstractChartConfig var4, TimeZone var5);

        protected String getChartTag() {
            return "graph";
        }

        protected StringBuffer renderProperties(StringBuffer sb, Fusionchart chart) {
            AbstractChartConfig config = chart.getChartConfig();
            if (config != null) {
                Utils.renderChartProperties(sb, config.getChartProperties());
            }
            sb.append(Utils.renderFusionchartAttr("caption", chart.getTitle())).append(Utils.renderFusionchartAttr("subCaption", chart.getSubTitle())).append(Utils.renderFusionchartBoolean("showLegend", chart.isShowLegend()));
            sb.append(" showValues='0'");
            return sb;
        }

        public void renderMoreData(StringBuffer sb, Fusionchart chart) {
        }
    }
}

