/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.fusionchart.config;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.zkmax.zul.ChartProperties;
import org.zkoss.zkmax.zul.fusionchart.config.ChartPropertiesList;
import org.zkoss.zkmax.zul.fusionchart.config.DefaultChartProperties;
import org.zkoss.zkmax.zul.fusionchart.impl.Utils;
import org.zkoss.zul.GanttModel;

public class MilestonePropertiesList
extends ChartPropertiesList {
    private static final long serialVersionUID = 20110703234710L;
    private Map<ChartProperties, GanttModel.GanttTask> taskPropMap = new HashMap<ChartProperties, GanttModel.GanttTask>(20);

    public ChartProperties createMilestone(Date date, GanttModel.GanttTask task, String color) {
        DefaultChartProperties milestone = new DefaultChartProperties();
        this.addProperty("date", Utils.toFusionchartDate(date));
        milestone.addProperty("color", Utils.toFusionchartColor(color));
        this.taskPropMap.put(milestone, task);
        return super.createProperties(milestone);
    }

    public ChartProperties getMilestone(int index) {
        return super.getProperties(index);
    }

    GanttModel.GanttTask getTask(int index) {
        return this.taskPropMap.get(this.getMilestone(index));
    }

    public void removeMilestone(ChartProperties milestone) {
        this.taskPropMap.remove(milestone);
        super.removeProperties(milestone);
    }

    public void removeMilestone(int index) {
        this.removeMilestone(this.getMilestone(index));
    }

    public void clearAllMilestone() {
        this.taskPropMap.clear();
        super.clearAllProperties();
    }
}

