/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.fusionchart.config;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zkmax.zul.ChartProperties;
import org.zkoss.zkmax.zul.fusionchart.config.ChartPropertiesMap;
import org.zkoss.zkmax.zul.fusionchart.config.DefaultChartProperties;
import org.zkoss.zkmax.zul.fusionchart.impl.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttChartHeaderPropertiesMap
extends ChartPropertiesMap {
    private static final long serialVersionUID = 20110620222710L;
    private static final Map<Integer, String> DEFAULT_FORMAT = new HashMap<Integer, String>();
    public static final String DEFAULT_MONTH_FORMAT;
    public static final int DEFAULT_PERIOD = 2;
    private String dateFormater = DEFAULT_FORMAT.get(new Integer(2));
    private boolean _showDateHeader = true;
    private int _period = 2;

    public String getDateFormater() {
        return this.dateFormater;
    }

    public void setDateFormater(String dateFormater) {
        if (!Objects.equals((Object)this.dateFormater, (Object)dateFormater)) {
            this.dateFormater = dateFormater;
            this.fireEvent(0, null);
        }
    }

    public void setShowDateHeader(boolean showDateHeader) {
        if (this._showDateHeader != showDateHeader) {
            this._showDateHeader = showDateHeader;
            this.fireEvent(0, null);
        }
    }

    public boolean isShowDateHeader() {
        return this._showDateHeader;
    }

    public int getPeriod() {
        return this._period;
    }

    public void setPeriod(int period) {
        if (period != this._period) {
            this._period = period;
            this.dateFormater = DEFAULT_FORMAT.get(new Integer(period));
            this.fireEvent(0, null);
        }
    }

    public ChartProperties createHeaderProperties(Date start, Date end) {
        return super.createProperties(GanttChartHeaderPropertiesMap.getKey(start, end), new DefaultChartProperties());
    }

    public ChartProperties createHeaderProperties(int index) {
        return super.createProperties(new Integer(index), new DefaultChartProperties());
    }

    public ChartProperties getHeaderProperties(Date start, Date end) {
        return super.getProperties(GanttChartHeaderPropertiesMap.getKey(start, end));
    }

    public ChartProperties getHeaderProperties(int index) {
        return this.getProperties(new Integer(index));
    }

    public void removeHeaderProperties(Date start, Date end) {
        super.removeProperties(GanttChartHeaderPropertiesMap.getKey(start, end));
    }

    public void removeHeaderProperties(int index) {
        super.removeProperties(new Integer(index));
    }

    public void clearAllHeaderProperties() {
        super.clearAllProperties();
    }

    public static final List<Comparable<?>> getKey(Date start, Date end) {
        return Arrays.asList(Utils.toFusionchartDate(start), Utils.toFusionchartDate(end));
    }

    static {
        DEFAULT_FORMAT.put(new Integer(5), "MMM-dd-yyyy");
        DEFAULT_FORMAT.put(new Integer(2), "MMM-yyyy");
        DEFAULT_FORMAT.put(new Integer(1), "yyyy");
        DEFAULT_MONTH_FORMAT = DEFAULT_FORMAT.get(new Integer(2));
    }
}

