/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.fusionchart.config;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Objects;
import org.zkoss.zkmax.zul.ChartProperties;
import org.zkoss.zkmax.zul.fusionchart.config.ChartInfoNotifier;
import org.zkoss.zul.event.ChartDataEvent;
import org.zkoss.zul.event.ChartDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChartProperties
implements Serializable,
ChartInfoNotifier,
ChartProperties {
    private static final long serialVersionUID = 20110310190455L;
    private List<ChartDataListener> _listeners = new LinkedList<ChartDataListener>();
    private ChartDataListener _listener;
    private Map<String, String> configMap = new HashMap<String, String>(3);

    protected void fireEvent(int type, Comparable<Object> series, Object data) {
        Iterator<ChartDataListener> it = this._listeners.iterator();
        while (it.hasNext()) {
            it.next().onChange(null);
        }
    }

    protected void fireEvent(int type, Object data) {
        this.fireEvent(type, null, data);
    }

    @Override
    public void addChartDataListener(ChartDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
    }

    @Override
    public void removeChartDataListener(ChartDataListener l) {
        this._listeners.remove(l);
    }

    @Override
    public void addPropertyListener(ChartInfoNotifier property) {
        if (this._listener == null) {
            this._listener = new MyChartDataListener();
        }
        property.addChartDataListener(this._listener);
    }

    @Override
    public void removePropertyListener(ChartInfoNotifier property) {
        property.removeChartDataListener(this._listener);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList<ChartDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }

    @Override
    public ChartProperties addProperty(String key, String value) {
        if (!Objects.equals((Object)this.getProperty(key), (Object)value)) {
            this.configMap.put(key, value);
            this.fireEvent(0, null);
        }
        return this;
    }

    @Override
    public ChartProperties removeProperty(String key) {
        String o = this.configMap.remove(key);
        if (o != null) {
            this.fireEvent(0, null);
        }
        return this;
    }

    @Override
    public String getProperty(String key) {
        return this.configMap.get(key);
    }

    @Override
    public Map<String, String> getAllProperties() {
        return Collections.unmodifiableMap(this.configMap);
    }

    @Override
    public void clear() {
        if (!this.configMap.isEmpty()) {
            this.configMap.clear();
            this.fireEvent(0, null);
        }
    }

    @Override
    public void addAllProperties(Map<String, String> config) {
        if (!config.isEmpty()) {
            this.configMap.putAll(config);
            this.fireEvent(0, null);
        }
    }

    private class MyChartDataListener
    implements ChartDataListener,
    Serializable {
        private static final long serialVersionUID = 20110311122122L;

        private MyChartDataListener() {
        }

        public void onChange(ChartDataEvent event) {
            DefaultChartProperties.this.fireEvent(0, null);
        }
    }
}

