/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.fusionchart.FusionchartEngine;
import org.zkoss.zkmax.zul.fusionchart.GanttTableRenderer;
import org.zkoss.zkmax.zul.fusionchart.config.AbstractChartConfig;
import org.zkoss.zkmax.zul.fusionchart.impl.SimpleFusionchartEngine;
import org.zkoss.zkmax.zul.fusionchart.impl.Utils;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.GanttModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.PieModel;
import org.zkoss.zul.SimpleCategoryModel;
import org.zkoss.zul.SimplePieModel;
import org.zkoss.zul.SimpleXYModel;
import org.zkoss.zul.XYModel;
import org.zkoss.zul.event.ChartDataEvent;
import org.zkoss.zul.event.ChartDataListener;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fusionchart
extends HtmlBasedComponent {
    private static final long serialVersionUID = 20110107232220L;
    private static final Map<String, Class> DEFAULT_MODEL = new HashMap<String, Class>();
    public static final String ORIENT_VERTICAL = "vertical";
    public static final String ORIENT_HORIZONTAL = "horizontal";
    private boolean _smartDrawChart;
    private transient EventListener<?> _smartDrawChartListener;
    private transient ChartDataListener _dataListener;
    private transient ChartDataListener _propertyListener;
    private transient ListDataListener _tableListener;
    private String _type = "pie";
    private boolean _threeD;
    private String _title;
    private String _subTitle;
    private int _intWidth = 400;
    private int _intHeight = 200;
    private String _xAxis;
    private String _yAxis;
    private boolean _showLegend = true;
    private boolean _showTooltiptext = true;
    private String _orient = "vertical";
    private TimeZone _tzone = TimeZones.getCurrent();
    private String _dateFormat;
    private transient ChartModel _model;
    private transient ListModel<?> _tableModel;
    private transient AbstractChartConfig _chartConfig;
    private transient GanttTableRenderer<?> _tableRenderer;
    private FusionchartEngine<Fusionchart> _engine;
    private String _dataXML;
    private String _dataXMLPath;

    public Fusionchart() {
        this.init();
        this.setWidth("500");
        this.setHeight("250");
        Runtime.init((Object)((Object)this));
    }

    private ChartModel createDefaultModel() {
        Class klass = DEFAULT_MODEL.get(this.getType());
        if (klass != null) {
            try {
                return (ChartModel)Classes.newInstance((Class)klass, null, null);
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        throw new UiException("unknown chart type: " + this.getType());
    }

    private void init() {
        if (this._smartDrawChartListener == null) {
            this._smartDrawChartListener = new SmartDrawListener();
            this.addEventListener("onSmartDrawChart", this._smartDrawChartListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSmartDraw() {
        if (Strings.isBlank((String)this.getType())) {
            throw new UiException("chart must specify type (pie, bar, line, ...)");
        }
        if (this._model == null) {
            this._model = this.createDefaultModel();
        }
        if (Strings.isBlank((String)this.getWidth())) {
            throw new UiException("chart must specify width");
        }
        if (Strings.isBlank((String)this.getHeight())) {
            throw new UiException("chart must specify height");
        }
        try {
            this._dataXML = this.getEngine().createChartXML(this);
            this.smartUpdate("dataXML", this._dataXML);
        }
        finally {
            this._smartDrawChart = false;
        }
    }

    public void setType(String type) {
        if (!Objects.equals((Object)this._type, (Object)type)) {
            this._type = type;
            this.smartUpdate("type", type);
        }
    }

    public String getType() {
        return this._type;
    }

    public void setThreeD(boolean threeD) {
        if (this._threeD != threeD) {
            this._threeD = threeD;
            this.smartUpdate("threeD", threeD);
        }
    }

    public boolean isThreeD() {
        return this._threeD;
    }

    public void setTitle(String title) {
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            this.smartDrawChart();
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setSubTitle(String subTitle) {
        if (!Objects.equals((Object)this._subTitle, (Object)subTitle)) {
            this._subTitle = subTitle;
            this.smartDrawChart();
        }
    }

    public String getSubTitle() {
        return this._subTitle;
    }

    public void setWidth(String w) {
        if (!Objects.equals((Object)w, (Object)this.getWidth())) {
            this._intWidth = Utils.stringToInt(w);
            super.setWidth(w);
            this.smartUpdate("intWidth", this._intWidth);
        }
    }

    public int getIntWidth() {
        return this._intWidth;
    }

    public void setHeight(String h) {
        if (!Objects.equals((Object)h, (Object)this.getHeight())) {
            this._intHeight = Utils.stringToInt(h);
            super.setHeight(h);
            this.smartUpdate("intHeight", this._intHeight);
        }
    }

    public int getIntHeight() {
        return this._intHeight;
    }

    public void setXAxis(String label) {
        if (!Objects.equals((Object)this._xAxis, (Object)label)) {
            this._xAxis = label;
            this.smartDrawChart();
        }
    }

    public String getXAxis() {
        return this._xAxis;
    }

    public void setYAxis(String label) {
        if (!Objects.equals((Object)this._yAxis, (Object)label)) {
            this._yAxis = label;
            this.smartDrawChart();
        }
    }

    public String getYAxis() {
        return this._yAxis;
    }

    public void setShowLegend(boolean showLegend) {
        if (this._showLegend != showLegend) {
            this._showLegend = showLegend;
            this.smartDrawChart();
        }
    }

    public boolean isShowLegend() {
        return this._showLegend;
    }

    public void setShowTooltiptext(boolean showTooltiptext) {
        if (this._showTooltiptext != showTooltiptext) {
            this._showTooltiptext = showTooltiptext;
            this.smartDrawChart();
        }
    }

    public boolean isShowTooltiptext() {
        return this._showTooltiptext;
    }

    public void setOrient(String orient) {
        if (!Objects.equals((Object)orient, (Object)this._orient)) {
            this._orient = orient;
            this.smartUpdate("orient", orient);
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public TimeZone getTimeZone() {
        return this._tzone;
    }

    public void setTimeZone(TimeZone tzone) {
        if (!Objects.equals((Object)tzone, (Object)this._tzone)) {
            this._tzone = tzone;
            this.smartDrawChart();
        }
    }

    public String getDateFormat() {
        return this._dateFormat;
    }

    public void setDateFormat(String format) {
        if (!Objects.equals((Object)format, (Object)this._dateFormat)) {
            this._dateFormat = format;
            this.smartDrawChart();
        }
    }

    public void setDataXMLPath(String url) {
        if (!Objects.equals((Object)this._dataXMLPath, (Object)url)) {
            this._dataXMLPath = url;
            this.smartUpdate("dataXMLPath", new EncodedURL(this._dataXMLPath));
        }
    }

    public String getDataXMLPath() {
        return this._dataXMLPath;
    }

    public AbstractChartConfig getChartConfig() {
        return this._chartConfig;
    }

    public void setChartConfig(AbstractChartConfig chartConfig) {
        if (chartConfig != null) {
            if (this._chartConfig != chartConfig) {
                if (this._chartConfig != null) {
                    this._chartConfig.removeChartDataListener(this._propertyListener);
                }
                this._chartConfig = chartConfig;
                this.initPropertyListener();
            }
        } else if (this._chartConfig != null) {
            this._chartConfig.removeChartDataListener(this._propertyListener);
            this._chartConfig = null;
        }
        this.smartDrawChart();
    }

    public <T> GanttTableRenderer<T> getTableRenderer() {
        return this._tableRenderer;
    }

    public void setTableRenderer(GanttTableRenderer<?> renderer) {
        if (renderer != this._tableRenderer) {
            this._tableRenderer = renderer;
            this.smartDrawChart();
        }
    }

    public ChartModel getModel() {
        return this._model;
    }

    public void setModel(ChartModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeChartDataListener(this._dataListener);
                }
                this._model = model;
                this.initDataListener();
            }
        } else if (this._model != null) {
            this._model.removeChartDataListener(this._dataListener);
            this._model = null;
        }
        this.smartDrawChart();
    }

    public void setModel(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setModel((ChartModel)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public <T> ListModel<T> getTableModel() {
        return this._tableModel;
    }

    public void setTableModel(ListModel<?> model) {
        if (model != null) {
            if (this._tableModel != model) {
                if (this._tableModel != null) {
                    this._tableModel.removeListDataListener(this._tableListener);
                }
                this._tableModel = model;
                this.initTableDataListener();
            }
        } else if (this._tableModel != null) {
            this._tableModel.removeListDataListener(this._tableListener);
            this._tableModel = null;
        }
        this.smartDrawChart();
    }

    public FusionchartEngine<Fusionchart> getEngine() throws UiException {
        if (this._engine == null) {
            this._engine = this.newChartEngine();
        }
        return this._engine;
    }

    protected FusionchartEngine<Fusionchart> newChartEngine() throws UiException {
        Object v;
        String PROP = "org.zkoss.fusionchart.engine.class";
        String klass = Library.getProperty((String)"org.zkoss.fusionchart.engine.class");
        if (klass == null) {
            v = new SimpleFusionchartEngine();
        } else {
            try {
                v = Classes.newInstanceByThread((String)klass);
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
        if (!(v instanceof FusionchartEngine)) {
            throw new UiException(FusionchartEngine.class + " must be implemented by " + v);
        }
        return (FusionchartEngine)v;
    }

    public void setEngine(FusionchartEngine<Fusionchart> engine) {
        if (this._engine != engine) {
            this._engine = engine;
        }
        this.smartDrawChart();
    }

    public void setEngine(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setEngine((FusionchartEngine)Classes.newInstanceByThread((String)clsnm));
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new MyChartDataListener();
            this._model.addChartDataListener(this._dataListener);
        }
    }

    private void initTableDataListener() {
        if (this._tableListener == null) {
            this._tableListener = new MyChartTableDataListener();
        }
        this._tableModel.addListDataListener(this._tableListener);
    }

    private void initPropertyListener() {
        if (this._propertyListener == null) {
            this._propertyListener = new MyChartDataListener();
            this._chartConfig.addChartDataListener(this._propertyListener);
        }
    }

    protected void smartDrawChart() {
        if (!this._smartDrawChart) {
            this._smartDrawChart = true;
            Events.postEvent((String)"onSmartDrawChart", (Component)this, null);
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-fusionchart";
    }

    public Object clone() {
        Fusionchart clone = (Fusionchart)((Object)super.clone());
        clone._smartDrawChartListener = null;
        clone._smartDrawChart = false;
        clone.init();
        clone.doSmartDraw();
        if (clone._model != null) {
            ChartModel model;
            if (clone._model instanceof ComponentCloneListener && (model = (ChartModel)((ComponentCloneListener)clone._model).willClone((Component)clone)) != null) {
                clone._model = model;
            }
            clone._dataListener = null;
            clone.initDataListener();
        }
        if (clone._chartConfig != null) {
            clone._propertyListener = null;
            clone.initPropertyListener();
        }
        if (clone._tableModel != null) {
            clone._tableListener = null;
            clone.initTableDataListener();
        }
        if (clone._tableRenderer != null) {
            clone._propertyListener = null;
            clone.initTableDataListener();
        }
        return clone;
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onClick")) {
            Map data = request.getData();
            ChartModel model = this.getModel();
            int cateIndex = AuRequests.getInt((Map)data, (String)"category", (int)0, (boolean)true);
            if (model instanceof CategoryModel) {
                int seriIndex = AuRequests.getInt((Map)data, (String)"series", (int)0, (boolean)true);
                CategoryModel cateModel = (CategoryModel)model;
                Comparable series = cateModel.getSeries(seriIndex);
                Comparable category = cateModel.getCategory(cateIndex);
                data.put("series", series);
                data.put("category", category);
                data.put("value", ((CategoryModel)model).getValue(series, category));
            } else if (model instanceof PieModel) {
                PieModel pieModel = (PieModel)model;
                Comparable category = pieModel.getCategory(cateIndex);
                data.put("category", category);
                data.put("value", pieModel.getValue(category));
            } else if (model instanceof XYModel) {
                XYModel xyModel = (XYModel)model;
                int seriIndex = AuRequests.getInt((Map)data, (String)"series", (int)0, (boolean)true);
                Comparable series = xyModel.getSeries(seriIndex);
                data.put("series", series);
                data.put("x", xyModel.getX(series, cateIndex));
                data.put("y", xyModel.getY(series, cateIndex));
            } else if (model instanceof GanttModel) {
                GanttModel ganttModel = (GanttModel)model;
                int seriIndex = AuRequests.getInt((Map)data, (String)"series", (int)0, (boolean)true);
                Comparable series = ganttModel.getAllSeries()[seriIndex];
                data.put("series", series);
                data.put("task", ganttModel.getTasks(series)[cateIndex]);
            }
            Events.postEvent((Event)new Event(cmd, (Component)this, (Object)data));
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        Runtime.init((Object)((Object)this));
        this.render(renderer, "type", this._type);
        this.render(renderer, "threeD", this._threeD);
        this.render(renderer, "orient", this._orient);
        if (this._intWidth != 400) {
            renderer.render("intWidth", this._intWidth);
        }
        if (this._intHeight != 200) {
            renderer.render("intHeight", this._intHeight);
        }
        this.render(renderer, "dataXML", this._dataXML);
        this.render(renderer, "dataXMLPath", this.getEncodedURL(this._dataXMLPath));
    }

    public void invalidate() {
        super.invalidate();
        Runtime.init((Object)((Object)this));
    }

    private String getEncodedURL(String path) {
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(path) : "";
    }

    public boolean isChildable() {
        return false;
    }

    static {
        DEFAULT_MODEL.put("pie", SimplePieModel.class);
        DEFAULT_MODEL.put("bar", SimpleCategoryModel.class);
        DEFAULT_MODEL.put("stacked_bar", SimpleCategoryModel.class);
        DEFAULT_MODEL.put("combination", SimpleCategoryModel.class);
        DEFAULT_MODEL.put("line", SimpleXYModel.class);
        DEFAULT_MODEL.put("area", SimpleXYModel.class);
        DEFAULT_MODEL.put("stacked_area", SimpleXYModel.class);
        DEFAULT_MODEL.put("gantt", GanttModel.class);
    }

    private class EncodedURL
    implements DeferredValue {
        private String path;

        public EncodedURL(String path) {
            this.path = path;
        }

        public Object getValue() {
            return Fusionchart.this.getEncodedURL(this.path);
        }
    }

    private class MyChartTableDataListener
    implements ListDataListener,
    Serializable {
        private static final long serialVersionUID = 20110612013922L;

        private MyChartTableDataListener() {
        }

        public void onChange(ListDataEvent event) {
            Fusionchart.this.smartDrawChart();
        }
    }

    private class MyChartDataListener
    implements ChartDataListener,
    Serializable {
        private static final long serialVersionUID = 20091008183622L;

        private MyChartDataListener() {
        }

        public void onChange(ChartDataEvent event) {
            Fusionchart.this.smartDrawChart();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SmartDrawListener
    implements SerializableEventListener<Event> {
        private static final long serialVersionUID = 20110612003710L;

        private SmartDrawListener() {
        }

        public void onEvent(Event event) throws Exception {
            Fusionchart.this.doSmartDraw();
        }
    }
}

