/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.MatrixComparatorProvider;
import org.zkoss.zkmax.zul.MatrixModel;
import org.zkoss.zkmax.zul.MatrixRenderer;
import org.zkoss.zkmax.zul.event.CellClickEvent;
import org.zkoss.zkmax.zul.event.ScrollEventExt;
import org.zkoss.zkmax.zul.event.SortEventExt;
import org.zkoss.zul.Html;
import org.zkoss.zul.Label;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.Sortable;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Biglistbox
extends XulElement {
    private transient MatrixModel<?, ?, ?, ?> _model;
    private transient ListDataListener _dataListener;
    private transient MatrixRenderer<?> _matrixRenderer;
    private transient boolean _childable;
    private transient String[][] _tmpRowData;
    private transient String[][] _tmpColData;
    private transient String[][] _tmpRowDataFx;
    private transient String[][] _tmpColDataFx;
    private MatrixComparatorProvider<?> _sortAsc;
    private MatrixComparatorProvider<?> _sortDsc;
    private int _jsel = -1;
    private int _rows = 30;
    private int _cols = 30;
    private String _rowHeight = "30px";
    private String _colWidth = "60px";
    private int _currentX = 0;
    private int _currentY = 0;
    private int _deltaX = 0;
    private int _deltaY = 0;
    private int _deltaX1 = 0;
    private int _deltaY1 = 0;
    private int _preloadsz = -1;
    private String _scOddRow = null;
    private int _sortingColumnIndex = -1;
    private boolean _multiple = false;
    private int _frozenCols = 0;
    private boolean _fixFrozenCols = false;
    private boolean _autoCols = true;
    private boolean _autoRows = true;
    private static final int COLUMN = 1;
    private static final int ROW = 2;
    private static final int FROZEN_COLUMN = 16;
    private static final int FROZEN_ROW = 32;
    private static final int ALL = 51;
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.onInitLaterPosted";
    private static final MatrixRenderer<Object> _defMTRend;

    public void setAutoCols(boolean autoCols) {
        if (this._autoCols != autoCols) {
            this._autoCols = autoCols;
            this.invalidate();
        }
    }

    public boolean isAutoCols() {
        return this._autoCols;
    }

    public void setAutoRows(boolean autoRows) {
        if (this._autoRows != autoRows) {
            this._autoRows = autoRows;
            this.invalidate();
        }
    }

    public boolean isAutoRows() {
        return this._autoRows;
    }

    public void setFrozenCols(int fcols) {
        if (fcols < 0) {
            throw new UnsupportedOperationException("No negative value: " + fcols);
        }
        if (this._model != null && this._model.getColumnSize() < fcols) {
            throw new UiException("FrozenCols cannot be greater than model's getColumnSize()");
        }
        if (this._frozenCols != fcols) {
            if (fcols < this._frozenCols) {
                int diff = this._frozenCols - fcols;
                if (this._currentX - diff == fcols) {
                    this._currentX -= diff;
                }
            } else {
                int diff = fcols - this._frozenCols;
                if (fcols == this._currentX + diff) {
                    this._currentX += diff;
                }
            }
            this._frozenCols = fcols;
            this.invalidate();
        }
    }

    public int getFrozenCols() {
        return this._frozenCols;
    }

    public void setFixFrozenCols(boolean fixFrozenCols) {
        if (this._fixFrozenCols != fixFrozenCols) {
            this._fixFrozenCols = fixFrozenCols;
            this.smartUpdate("fixFrozenCols", this._fixFrozenCols);
        }
    }

    public boolean isFixFrozenCols() {
        return this._fixFrozenCols;
    }

    public MatrixComparatorProvider<?> getSortAscending() {
        return this._sortAsc;
    }

    public void setSortAscending(MatrixComparatorProvider<?> sorter) {
        if (!Objects.equals(this._sortAsc, sorter)) {
            this._sortAsc = sorter;
        }
    }

    public void setSortAscending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm)) {
            this.setSortAscending(this.toComparator(clsnm));
        }
    }

    public MatrixComparatorProvider<?> getSortDescending() {
        return this._sortDsc;
    }

    public void setSortDescending(MatrixComparatorProvider<?> sorter) {
        if (!Objects.equals(this._sortDsc, sorter)) {
            this._sortDsc = sorter;
        }
    }

    public void setSortDescending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!Strings.isBlank((String)clsnm)) {
            this.setSortDescending(this.toComparator(clsnm));
        }
    }

    private MatrixComparatorProvider<?> toComparator(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls;
        if (clsnm == null || clsnm.length() == 0) {
            return null;
        }
        Page page = this.getPage();
        Class clazz = cls = page != null ? page.resolveClass(clsnm) : Classes.forNameByThread((String)clsnm);
        if (cls == null) {
            throw new ClassNotFoundException(clsnm);
        }
        if (!MatrixComparatorProvider.class.isAssignableFrom(cls)) {
            throw new UiException("MatrixComparatorProvider must be implemented: " + clsnm);
        }
        return (MatrixComparatorProvider)cls.newInstance();
    }

    public String getOddRowSclass() {
        return this._scOddRow == null ? this.getZclass() + "-odd" : this._scOddRow;
    }

    public void setOddRowSclass(String scls) {
        if (scls != null && scls.length() == 0) {
            scls = null;
        }
        if (!Objects.equals((Object)this._scOddRow, (Object)scls)) {
            this._scOddRow = scls;
            this.smartUpdate("oddRowSclass", scls);
        }
    }

    public int getPreloadSize() {
        if (this._preloadsz < 0) {
            int sz = 50;
            if ((sz = Utils.getIntAttribute((Component)this, (String)"org.zkoss.zkmax.zul.biglistbox.preloadSize", (int)sz, (boolean)true)) < 0) {
                throw new UiException("nonnegative is required: " + sz);
            }
            this._preloadsz = sz;
        }
        return this._preloadsz;
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) {
        if (rows < 0) {
            rows = 0;
        }
        if (this._rows != rows) {
            this._rows = rows;
            this.invalidate();
        }
    }

    public int getCols() {
        return this._cols;
    }

    public void setCols(int cols) {
        if (cols < 0) {
            cols = 0;
        }
        if (this._frozenCols > cols - 1) {
            throw new UiException("FrozenCols cannot be greater than cols size");
        }
        if (this._cols != cols) {
            this._cols = cols;
            this.invalidate();
        }
    }

    public String getRowHeight() {
        return this._rowHeight;
    }

    public void setRowHeight(String rowHeight) {
        if (Strings.isEmpty((String)rowHeight)) {
            rowHeight = "30px";
        }
        if (!this._rowHeight.equals(rowHeight)) {
            this._rowHeight = rowHeight;
            this.invalidate();
        }
    }

    public String getColWidth() {
        return this._colWidth;
    }

    public void setColWidth(String colWidth) {
        if (Strings.isEmpty((String)colWidth)) {
            colWidth = "60px";
        }
        if (!this._colWidth.equals(colWidth)) {
            this._colWidth = colWidth;
            this.invalidate();
        }
    }

    public MatrixModel<?, ?, ?, ?> getModel() {
        return this._model;
    }

    private void resetInfos() {
        this._currentX = 0;
        this._currentY = 0;
    }

    public void setModel(MatrixModel<?, ?, ?, ?> model) {
        if (model != null) {
            if (!(model instanceof Selectable)) {
                throw new UiException(model.getClass() + " must implement " + Selectable.class);
            }
            if (this._frozenCols > model.getColumnSize()) {
                throw new UiException("FrozenCols cannot be greater than model's getColumnSize()");
            }
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                    this.resetInfos();
                }
                this._model = model;
                this.initDataListener();
                this.postOnInitRender();
            }
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            this.invalidate();
        }
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        this.syncModel();
        this.invalidate();
    }

    private void syncModel() {
        this.syncModel0(51);
    }

    private void cleanTempData() {
        this._tmpColData = null;
        this._tmpRowData = this._tmpColData;
        this._tmpColDataFx = this._tmpColData;
        this._tmpRowDataFx = this._tmpColData;
    }

    private void syncModel0(int type) {
        if (this._model != null) {
            int maxColSize = this._model.getColumnSize();
            int preloadsz = this.getPreloadSize();
            int initCols = this._currentX > preloadsz ? this._currentX - preloadsz : 0;
            int endCols = this._currentX + (this._cols - this._frozenCols) + preloadsz;
            if (endCols > maxColSize) {
                endCols = maxColSize;
            }
            int maxRowSize = this._model.getSize();
            int initRows = this._currentY > preloadsz ? this._currentY - preloadsz : 0;
            int endRows = this._currentY + this._rows + preloadsz;
            if (endRows > maxRowSize) {
                endRows = maxRowSize;
            }
            this._deltaX = this._currentX - initCols;
            this._deltaY = this._currentY - initRows;
            this._deltaX1 = endCols - initCols;
            this._deltaY1 = endRows - initRows;
            this.smartUpdate("_deltaX", this._deltaX);
            this.smartUpdate("_deltaY", this._deltaY);
            this.smartUpdate("_deltaX1", this._deltaX1);
            this.smartUpdate("_deltaY1", this._deltaY1);
            if ((type & 0x33) != 0) {
                this._tmpRowDataFx = this.syncRowData(0, initCols > this._frozenCols ? this._cols : this._frozenCols, initRows, endRows);
                this.smartUpdate("rowDataFx", new Object[]{0, this._currentY, this._tmpRowDataFx});
                this._tmpColDataFx = this.syncColData(0, initCols > this._frozenCols ? this._cols : this._frozenCols);
                this.smartUpdate("colDataFx", new Object[]{0, this._tmpColDataFx});
            }
            if ((type & 0x33) != 0) {
                this._tmpColData = this.syncColData(initCols, endCols);
                this.smartUpdate("colData", new Object[]{this._currentX, this._tmpColData});
            }
            if ((type & 0x33) != 0) {
                this._tmpRowData = this.syncRowData(initCols, endCols, initRows, endRows);
                this.smartUpdate("rowData", new Object[]{this._currentX, this._currentY, this._tmpRowData});
            }
            Events.postEvent((String)"onAfterRender", (Component)this, null);
        }
    }

    private String[][] syncColData(int x1, int x2) {
        boolean old = this._childable;
        int initCols = x1;
        int endCols = x2;
        int colSize = endCols - initCols;
        int headSize = this._model.getHeadSize();
        String[][] tmpColData = new String[headSize][colSize];
        MatrixRenderer<?> renderer = this.getRealMatrixRenderer();
        try {
            this._childable = true;
            for (int rowIndex = 0; rowIndex < headSize; ++rowIndex) {
                Object value = this._model.getHeadAt(rowIndex);
                int col = 0;
                int clen = endCols;
                for (int colIndex = initCols; colIndex < clen; ++colIndex) {
                    tmpColData[rowIndex][col++] = renderer.renderHeader((Component)this, value, rowIndex, colIndex);
                }
            }
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        finally {
            this._childable = old;
            this.getChildren().clear();
        }
        return tmpColData;
    }

    private String[][] syncRowData(int x1, int x2, int y1, int y2) {
        MatrixRenderer<Object> renderer = this.getRealMatrixRenderer();
        boolean old = this._childable;
        int initCols = x1;
        int endCols = x2;
        int colSize = endCols - initCols;
        int initRows = y1;
        int endRows = y2;
        int rowSize = endRows - initRows;
        String[][] tmpRowData = new String[rowSize][colSize];
        try {
            this._childable = true;
            Selectable<Object> smodel = this.getSelectableModel();
            this._jsel = -1;
            int row = 0;
            int rlen = endRows;
            for (int rowIndex = initRows; rowIndex < rlen; ++rowIndex) {
                Object value = this._model.getElementAt(rowIndex);
                int col = 0;
                int clen = endCols;
                for (int colIndex = initCols; colIndex < clen; ++colIndex) {
                    if (this._jsel < 0 && smodel.isSelected(value)) {
                        this._jsel = rowIndex;
                    }
                    tmpRowData[row][col++] = renderer.renderCell((Component)this, value, rowIndex, colIndex);
                }
                ++row;
            }
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        finally {
            this._childable = old;
            this.getChildren().clear();
        }
        return tmpRowData;
    }

    public <T> MatrixRenderer<T> getRealMatrixRenderer() {
        MatrixRenderer<T> renderer = this.getMatrixRenderer();
        return renderer != null ? renderer : _defMTRend;
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    public <T> MatrixRenderer<T> getMatrixRenderer() {
        return this._matrixRenderer;
    }

    public void setMatrixRenderer(MatrixRenderer<?> renderer) {
        if (this._matrixRenderer != renderer) {
            this._matrixRenderer = renderer;
            this.invalidate();
        }
    }

    public void setMatrixRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setMatrixRenderer((MatrixRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public void invalidate() {
        if ((this._tmpRowData == null || this._frozenCols > 0 && (this._tmpRowDataFx == null || this._tmpColDataFx == null)) && this._model != null && this._model.getSize() > 0) {
            this.postOnInitRender();
        }
        Runtime.init((Object)((Object)this));
        super.invalidate();
    }

    protected boolean isChildable() {
        return this._childable;
    }

    private void doSelectionChanged() {
        Selectable<Object> smodel = this.getSelectableModel();
        if (smodel.isSelectionEmpty()) {
            if (this._jsel >= 0) {
                this.setSelectedIndex(-1);
            }
            return;
        }
        if (this._jsel >= 0 && smodel.isSelected(this._model.getElementAt(this._jsel))) {
            return;
        }
        int sz = this._model.getSize();
        for (int i = 0; i < sz; ++i) {
            if (!smodel.isSelected(this._model.getElementAt(i))) continue;
            this.setSelectedIndex(i);
            return;
        }
        this.setSelectedIndex(-1);
    }

    private Selectable<Object> getSelectableModel() {
        if (this._model instanceof Selectable) {
            return (Selectable)this._model;
        }
        return null;
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    switch (event.getType()) {
                        case 4: {
                            Biglistbox.this.doSelectionChanged();
                            return;
                        }
                        case 6: {
                            return;
                        }
                        case 0: {
                            Biglistbox.this.smartUpdate("dirtyModel", true);
                            Biglistbox.this.syncModel();
                            Biglistbox.this.cleanTempData();
                            return;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            int colSize = Biglistbox.this._model.getColumnSize();
                            int rowSize = Biglistbox.this._model.getSize();
                            if (colSize < Biglistbox.this._currentX) {
                                Biglistbox.this._currentX = colSize - (Biglistbox.this._cols - Biglistbox.this._frozenCols);
                            }
                            if (rowSize < Biglistbox.this._currentY) {
                                Biglistbox.this._currentY = rowSize - Biglistbox.this._rows;
                            }
                            Biglistbox.this.smartUpdate("dirtyModel", true);
                        }
                    }
                    Biglistbox.this.postOnInitRender();
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    public Object getSelectedObject() {
        return this._model != null && this._jsel > -1 ? this._model.getElementAt(this._jsel) : null;
    }

    private void setSelectedIndex(int jsel) {
        if (jsel < -1) {
            jsel = -1;
        }
        if (jsel != this._jsel) {
            this._jsel = jsel;
            this.smartUpdate("selectedIndex", jsel);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Sortable sm;
        super.renderProperties(renderer);
        Runtime.init((Object)((Object)this));
        int cacheSize = Utils.getIntAttribute((Component)this, (String)"org.zkoss.zkmax.zul.biglistbox.clientCacheSize", (int)1, (boolean)true);
        if (cacheSize != 1) {
            renderer.render("_clientCacheSize", cacheSize);
        }
        if (this._frozenCols > 0) {
            renderer.render("frozenCols", this._frozenCols);
        }
        this.render(renderer, "fixFrozenCols", this._fixFrozenCols);
        renderer.render("selectedIndex", this._jsel);
        this.render(renderer, "oddRowSclass", this._scOddRow);
        if (!this._autoCols) {
            renderer.render("autoCols", this._autoCols);
        }
        if (!this._autoRows) {
            renderer.render("autoRows", this._autoRows);
        }
        if (this._rows != 30) {
            this.render(renderer, "rows", this._rows);
        }
        if (this._cols != 30) {
            this.render(renderer, "cols", this._cols);
        }
        if (!"60px".equals(this._colWidth)) {
            this.render(renderer, "colWidth", this._colWidth);
        }
        if (!"30px".equals(this._rowHeight)) {
            this.render(renderer, "rowHeight", this._rowHeight);
        }
        this.render(renderer, "rowSize", this.getModel().getSize());
        this.render(renderer, "colSize", this.getModel().getColumnSize());
        if (this._sortDsc != null) {
            this.render(renderer, "sortDescending", true);
        }
        if (this._sortAsc != null) {
            this.render(renderer, "sortAscending", true);
        }
        if (this._sortingColumnIndex >= 0) {
            this.render(renderer, "_sortingColumnIndex", this._sortingColumnIndex);
        }
        if ((sm = this.getSortableModel()) != null) {
            String direction = "natural";
            if (this._sortDsc != null) {
                direction = sm.getSortDirection(this._sortDsc.getColumnComparator(this._sortingColumnIndex));
            }
            if ("natural".equals(direction) && this._sortAsc != null) {
                direction = sm.getSortDirection(this._sortAsc.getColumnComparator(this._sortingColumnIndex));
            }
            if (!"natural".equals(direction)) {
                this.render(renderer, "sortDirection", direction);
            }
        }
        if (this._deltaX > 0) {
            this.render(renderer, "_deltaX", this._deltaX);
        }
        if (this._deltaY > 0) {
            this.render(renderer, "_deltaY", this._deltaY);
        }
        if (this._deltaX1 > 0) {
            this.render(renderer, "_deltaX1", this._deltaX1);
        }
        if (this._deltaY1 > 0) {
            this.render(renderer, "_deltaY1", this._deltaY1);
        }
        if (this._currentX > 0) {
            this.render(renderer, "_currentX", this._currentX);
        }
        if (this._currentY > 0) {
            this.render(renderer, "_currentY", this._currentY);
        }
        if (this._tmpRowDataFx != null) {
            this.render(renderer, "rowDataFx", new Object[]{0, this._currentY, this._tmpRowDataFx});
            this._tmpRowDataFx = null;
        }
        if (this._tmpColDataFx != null) {
            this.render(renderer, "colDataFx", new Object[]{0, this._tmpColDataFx});
            this._tmpColDataFx = null;
        }
        if (this._tmpRowData != null) {
            this.render(renderer, "rowData", new Object[]{this._currentX, this._currentY, this._tmpRowData});
            this._tmpRowData = null;
        }
        if (this._tmpColData != null) {
            this.render(renderer, "colData", new Object[]{this._currentX, this._tmpColData});
            this._tmpColData = null;
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-biglistbox";
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onSelect")) {
            this._jsel = (Integer)request.getData().get("rowIndex");
            Integer x = (int)((Integer)request.getData().get("columnIndex"));
            Integer index = this._jsel;
            LinkedHashSet<Object> selObjs = new LinkedHashSet<Object>();
            if (index >= 0) {
                if (!this._multiple) {
                    selObjs.clear();
                }
                selObjs.add(this._model.getElementAt(index));
            }
            if (this._model != null) {
                this.getSelectableModel().setSelection(selObjs);
            }
            Events.postEvent((Event)new SelectEvent("onSelect", (Component)this, null, selObjs, null, (Object)new Integer[]{x, index}, 0));
        } else if ("onScrollY".equals(cmd)) {
            ScrollEventExt evt = ScrollEventExt.getScrollEventExt(request);
            boolean reload = AuRequests.getBoolean((Map)request.getData(), (String)"reload");
            this._currentY = evt.getY();
            this._currentX = evt.getX();
            if (reload) {
                if (this._frozenCols > 0 && this._currentX > this._cols) {
                    this.syncModel0(18);
                } else {
                    this.syncModel0(2);
                }
                this.cleanTempData();
            }
            Events.postEvent((Event)evt);
        } else if ("onScrollX".equals(cmd)) {
            ScrollEventExt evt = ScrollEventExt.getScrollEventExt(request);
            boolean reload = AuRequests.getBoolean((Map)request.getData(), (String)"reload");
            this._currentY = evt.getY();
            this._currentX = evt.getX();
            if (reload) {
                if (this._frozenCols > 0 && this._currentX > this._cols) {
                    this.syncModel0(19);
                } else {
                    this.syncModel0(3);
                }
                this.cleanTempData();
            }
            Events.postEvent((Event)evt);
        } else if ("onScroll".equals(cmd)) {
            ScrollEventExt evt = ScrollEventExt.getScrollEventExt(request);
            Events.postEvent((Event)evt);
        } else if ("onAdjustRows".equals(cmd)) {
            this._rows = (Integer)request.getData().get("");
        } else if ("onAdjustCols".equals(cmd)) {
            this._cols = (Integer)request.getData().get("");
        } else if (cmd.equals("onSort")) {
            SortEventExt evt = SortEventExt.getSortEventExt(request);
            Events.postEvent((Event)evt);
        } else if ("onCellClick".equals(cmd)) {
            Events.postEvent((Event)CellClickEvent.getCellClickEvent(request));
        } else if ("onAdjustFrozenCols".equals(cmd)) {
            int frozenCols = (Integer)request.getData().get("");
            if (frozenCols < this._frozenCols) {
                int diff = this._frozenCols - frozenCols;
                if (this._currentX - diff == frozenCols) {
                    this._currentX -= diff;
                }
            } else {
                int diff = frozenCols - this._frozenCols;
                if (frozenCols == this._currentX + diff) {
                    this._currentX += diff;
                }
            }
            this._frozenCols = frozenCols;
        } else {
            super.service(request, everError);
        }
    }

    public void onSort(SortEventExt event) {
        int columnIndex;
        this._sortingColumnIndex = columnIndex = event.getColumnIndex();
        this.sort(event.isAscending(), columnIndex);
    }

    public Sortable getSortableModel() {
        if (this._model instanceof Sortable) {
            return (Sortable)this._model;
        }
        return null;
    }

    public boolean sort(boolean ascending, int columnIndex) {
        String dir = this.getSortableModel().getSortDirection(ascending ? this.getSortAscending().getColumnComparator(columnIndex) : this.getSortDescending().getColumnComparator(columnIndex));
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        return this.doSort(ascending, columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doSort(boolean ascending, int columnIndex) {
        MatrixComparatorProvider<?> cmpr;
        MatrixComparatorProvider<?> matrixComparatorProvider = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Scopes.beforeInterpret((Scope)this);
        try {
            Sortable model = this.getSortableModel();
            if (model != null) {
                model.sort(cmpr.getColumnComparator(columnIndex), ascending);
            }
        }
        finally {
            Scopes.afterInterpret();
        }
        return true;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        s.writeObject(this._model instanceof Serializable || this._model instanceof Externalizable ? this._model : null);
        this.willSerialize(this._matrixRenderer);
        s.writeObject(this._matrixRenderer instanceof Serializable || this._matrixRenderer instanceof Externalizable ? this._matrixRenderer : null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (MatrixModel)s.readObject();
        this.didDeserialize(this._model);
        this._matrixRenderer = (MatrixRenderer)s.readObject();
        this.didDeserialize(this._matrixRenderer);
        if (this._model != null) {
            this.initDataListener();
            this.postOnInitRender();
        }
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._matrixRenderer);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._matrixRenderer);
    }

    static {
        Biglistbox.addClientEvent(Biglistbox.class, (String)"onSelect", (int)8193);
        Biglistbox.addClientEvent(Biglistbox.class, (String)"onScroll", (int)8192);
        Biglistbox.addClientEvent(Biglistbox.class, (String)"onScrollY", (int)8195);
        Biglistbox.addClientEvent(Biglistbox.class, (String)"onScrollX", (int)8195);
        Biglistbox.addClientEvent(Biglistbox.class, (String)"onAdjustRows", (int)8195);
        Biglistbox.addClientEvent(Biglistbox.class, (String)"onAdjustCols", (int)8195);
        Biglistbox.addClientEvent(Biglistbox.class, (String)"onSort", (int)8192);
        Biglistbox.addClientEvent(Biglistbox.class, (String)"onCellClick", (int)8192);
        Biglistbox.addClientEvent(Biglistbox.class, (String)"onAdjustFrozenCols", (int)8195);
        _defMTRend = new MatrixRenderer<Object>(){

            @Override
            public String renderCell(final Component owner, final Object data, final int rowIndex, final int colIndex) {
                Biglistbox self = (Biglistbox)owner;
                Template tm = self.getTemplate("rows");
                if (tm == null) {
                    return Objects.toString(self.getModel().getCellAt(data, colIndex));
                }
                Component[] items = tm.create(owner, null, new VariableResolver(){

                    public Object resolveVariable(String name) {
                        if ("each".equals(name)) {
                            return data;
                        }
                        if ("forEachStatus".equals(name)) {
                            return new ForEachStatus(){

                                public ForEachStatus getPrevious() {
                                    return null;
                                }

                                public Object getEach() {
                                    return data;
                                }

                                public int getIndex() {
                                    return colIndex;
                                }

                                public Integer getBegin() {
                                    return 0;
                                }

                                public Integer getEnd() {
                                    return ((Biglistbox)owner).getModel().getSize();
                                }
                            };
                        }
                        if ("matrixInfo".equals(name)) {
                            return new Integer[]{colIndex, rowIndex};
                        }
                        return null;
                    }
                }, null);
                if (items.length != 1) {
                    throw new UiException("The model template must have exactly one item, not " + items.length);
                }
                items[0].detach();
                if (items[0] instanceof Label) {
                    return ((Label)items[0]).getValue();
                }
                if (items[0] instanceof Html) {
                    return ((Html)items[0]).getContent();
                }
                throw new UiException("The model template can only support Label or Html component, not " + items[0]);
            }

            @Override
            public String renderHeader(final Component owner, final Object data, final int rowIndex, final int colIndex) {
                Biglistbox self = (Biglistbox)owner;
                Template tm = self.getTemplate("heads");
                if (tm == null) {
                    return Objects.toString(self.getModel().getHeaderAt(data, colIndex));
                }
                Component[] items = tm.create(owner, null, new VariableResolver(){

                    public Object resolveVariable(String name) {
                        if ("each".equals(name)) {
                            return data;
                        }
                        if ("forEachStatus".equals(name)) {
                            return new ForEachStatus(){

                                public ForEachStatus getPrevious() {
                                    return null;
                                }

                                public Object getEach() {
                                    return data;
                                }

                                public int getIndex() {
                                    return colIndex;
                                }

                                public Integer getBegin() {
                                    return 0;
                                }

                                public Integer getEnd() {
                                    return ((Biglistbox)owner).getModel().getSize();
                                }
                            };
                        }
                        if ("matrixInfo".equals(name)) {
                            return new Integer[]{colIndex, rowIndex};
                        }
                        return null;
                    }
                }, null);
                if (items.length != 1) {
                    throw new UiException("The model template must have exactly one item, not " + items.length);
                }
                items[0].detach();
                if (items[0] instanceof Label) {
                    return ((Label)items[0]).getValue();
                }
                if (items[0] instanceof Html) {
                    return ((Html)items[0]).getContent();
                }
                throw new UiException("The model template can only support Label or Html component, not " + items[0]);
            }
        };
    }
}

