/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.xel.ognl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.zkoss.lang.Classes;
import org.zkoss.xel.Expression;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.zkmax.xel.ognl.MapperClassResolver;
import org.zkoss.zkmax.xel.ognl.OGNLXelExpression;
import org.zkoss.zkmax.xel.ognl.ResolverProxy;
import org.zkoss.zkmax.xel.util.ExpressionFragment;

public class OGNLFactory
implements ExpressionFactory {
    public boolean isSupported(int feature) {
        return feature == 2;
    }

    public Expression parseExpression(XelContext ctx, String expression, Class expectedType) throws XelException {
        try {
            List<Object> frags = ExpressionFragment.parse(expression);
            Object[] fs = new Object[frags.size()];
            int j = 0;
            for (Object o : frags) {
                fs[j] = o instanceof ExpressionFragment ? Ognl.parseExpression((String)((ExpressionFragment)o).getExpression()) : o;
                ++j;
            }
            return new OGNLXelExpression(fs, expectedType);
        }
        catch (OgnlException ex) {
            throw new XelException((Throwable)ex);
        }
    }

    public Object evaluate(XelContext ctx, String expression, Class expectedType) throws XelException {
        Map ognlctx = OGNLFactory.getContext(ctx);
        Object root = OGNLFactory.getRoot(ctx);
        try {
            List<Object> frags = ExpressionFragment.parse(expression);
            if (frags.size() == 1) {
                Object o = frags.get(0);
                return Classes.coerce((Class)expectedType, (Object)(o instanceof String ? o : Ognl.getValue((String)((ExpressionFragment)o).getExpression(), (Map)ognlctx, (Object)root, null)));
            }
            StringBuffer sb = new StringBuffer(256);
            for (Object o : frags) {
                if (o instanceof String) {
                    sb.append(o);
                    continue;
                }
                Object val = Ognl.getValue((String)((ExpressionFragment)o).getExpression(), (Map)ognlctx, (Object)root, null);
                if (val == null) continue;
                sb.append(val);
            }
            return Classes.coerce((Class)expectedType, (Object)sb.toString());
        }
        catch (OgnlException ex) {
            throw new XelException((Throwable)ex);
        }
    }

    public static Map getContext(XelContext ctx) {
        FunctionMapper mapper = ctx.getFunctionMapper();
        return Ognl.addDefaultContext(null, (ClassResolver)(mapper != null ? new MapperClassResolver(mapper) : null), (Map)Collections.EMPTY_MAP);
    }

    public static Object getRoot(XelContext ctx) {
        return new ResolverProxy(ctx);
    }

    static {
        OgnlRuntime.setPropertyAccessor(ResolverProxy.class, (PropertyAccessor)new PropertyAccessor(){

            public Object getProperty(Map context, Object target, Object name) throws OgnlException {
                return target instanceof ResolverProxy && name instanceof String ? ((ResolverProxy)target).resolve((String)name) : null;
            }

            public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
                throw new UnsupportedOperationException();
            }
        });
    }
}

