/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.lang.Generics;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesktopRecycle
implements org.zkoss.zk.ui.util.DesktopRecycle {
    private static final String ATTR_RECYCLE = DesktopRecycle.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeRemove(Execution exec, Desktop desktop, int cause) {
        Map<String, Info> cache;
        Session sess;
        Session session = sess = exec.getSession();
        synchronized (session) {
            cache = Generics.cast((Map)((Map)sess.getAttribute(ATTR_RECYCLE)));
            if (cache == null) {
                cache = this.newCache0(sess);
                sess.setAttribute(ATTR_RECYCLE, cache);
            }
        }
        String uri = DesktopRecycle.getURI(desktop);
        if (this.shallCache(desktop, uri, cause)) {
            Map<String, Info> map = cache;
            synchronized (map) {
                Info info = new Info(desktop);
                Info prev = cache.put(uri, info);
                if (prev != null && prev.time > info.time) {
                    cache.put(uri, prev);
                }
            }
        }
        return true;
    }

    protected static String getURI(Desktop desktop) {
        String p = desktop.getRequestPath();
        String qs = desktop.getQueryString();
        return qs != null ? p + '?' + qs : p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRemove(Session sess, Desktop desktop) {
        Map cache = Generics.cast((Map)((Map)sess.getAttribute(ATTR_RECYCLE)));
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                cache.remove(DesktopRecycle.getURI(desktop));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Desktop beforeService(Execution exec, String uri) {
        Map cache;
        Session sess = exec.getSession();
        if (sess != null && (cache = Generics.cast((Map)((Map)sess.getAttribute(ATTR_RECYCLE)))) != null) {
            Map map = cache;
            synchronized (map) {
                Info info = (Info)cache.get(uri);
                if (info != null) {
                    int elapsed = info.getElapsed();
                    if (this.shallReuse(info.desktop, uri, elapsed)) {
                        cache.remove(uri);
                        return info.desktop;
                    }
                    if (this.shallExpunge(info.desktop, uri, elapsed)) {
                        cache.remove(uri);
                    }
                }
            }
        }
        return null;
    }

    public void afterService(Desktop desktop) {
    }

    protected Map newCache(Session sess) {
        return new HashMap();
    }

    private Map<String, Info> newCache0(Session sess) {
        return this.newCache(sess);
    }

    protected boolean shallCache(Desktop desktop, String uri, int cause) {
        return true;
    }

    protected boolean shallReuse(Desktop desktop, String uri, int secElapsed) {
        return secElapsed <= 600;
    }

    protected boolean shallExpunge(Desktop desktop, String uri, int secElapsed) {
        return secElapsed > 600;
    }

    private static class Info
    implements Serializable {
        private final Desktop desktop;
        private final long time;

        private Info(Desktop desktop) {
            this.desktop = desktop;
            this.time = System.currentTimeMillis();
        }

        private int getElapsed() {
            return (int)((System.currentTimeMillis() - this.time) / 1000L);
        }
    }
}

