/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.select;

import java.lang.reflect.Method;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.select.impl.Reflections;
import org.zkoss.zkmax.ui.select.annotation.Subscribe;

public class SelectorsExt {
    public static void subscribeEventQueues(Object controller) {
        SelectorsExt.subscribeEventQueues(controller, false);
    }

    static void resubscribeEventQueues(Object controller) {
        SelectorsExt.subscribeEventQueues(controller, true);
    }

    private static void subscribeEventQueues(final Object controller, boolean rewire) {
        Reflections.forMethods(controller.getClass(), Subscribe.class, (Reflections.MethodRunner)new Reflections.MethodRunner<Subscribe>(){

            public void onMethod(Class<?> clazz, Method method, Subscribe anno) {
                if ((method.getModifiers() & 8) != 0) {
                    throw new UiException("Cannot add forward to static method: " + method.getName());
                }
                int paramLen = method.getParameterTypes().length;
                if (paramLen > 1) {
                    throw new UiException("Event handler method should have at most one parameter: " + method.getName());
                }
                EventQueue eq = EventQueues.lookup((String)anno.value(), (String)anno.scope(), (boolean)true);
                eq.subscribe((EventListener)new Selectors.ComposerEventListener(method, controller));
            }
        });
    }

    public static class ExtendedUtilityHandlerImpl
    extends SelectorComposer.UtilityHandlerImpl {
        private static final long serialVersionUID = 1L;

        public void subscribeEventQueues(Object controller) {
            SelectorsExt.subscribeEventQueues(controller);
        }

        public void resubscribeEventQueues(Object controller) {
            SelectorsExt.resubscribeEventQueues(controller);
        }
    }
}

