/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.ext.render.Merger;
import org.zkoss.zk.ui.impl.UiEngineImpl;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.StubComponent;
import org.zkoss.zk.ui.sys.StubsComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiEngineExtension
implements UiEngineImpl.Extension {
    public void afterCreate(Component[] comps) {
        if (comps != null) {
            int j = comps.length;
            while (--j >= 0) {
                comps[j] = UiEngineExtension.merge(comps[j]);
            }
        }
    }

    public void afterRenderComponents(Collection comps) {
        HashMap<Component, boolean[]> stubinfs = new HashMap<Component, boolean[]>();
        for (Component c : comps) {
            boolean[] stubinf = UiEngineExtension.getStubInfo(c.getParent(), stubinfs);
            UiEngineExtension.stub(c, stubinf[0], stubinf[1]);
        }
    }

    public void afterRenderNewPage(Page page) {
        this.afterRenderComponents(page.getRoots());
    }

    private static final boolean[] getStubInfo(Component comp, Map<Component, boolean[]> stubinfs) {
        boolean[] stubinf = stubinfs.get(comp);
        if (stubinf == null) {
            Boolean stubnative = null;
            Boolean stubonly = null;
            for (Component c = comp; c != null; c = c.getParent()) {
                if (stubnative == null) {
                    stubnative = UiEngineExtension.shallStubNative(c);
                }
                if (stubonly == null) {
                    stubonly = UiEngineExtension.shallStubonly(c);
                }
                if (stubnative != null && stubonly != null) break;
            }
            stubinf = new boolean[]{stubnative == null || stubnative != false, stubonly != null && stubonly != false};
            stubinfs.put(comp, stubinf);
        }
        return stubinf;
    }

    private static final Boolean shallStubNative(Component comp) {
        Object sn = comp.getAttribute("org.zkoss.zk.ui.stub.native");
        if (sn != null) {
            return Boolean.TRUE.equals(sn) || "true".equals(sn);
        }
        if ("paging".equals(comp.getMold())) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static final Boolean shallStubonly(Component comp) {
        String so = comp.getStubonly();
        return "inherit".equals(so) ? null : Boolean.valueOf("true".equals(so));
    }

    private static final boolean stub(Component comp, boolean stubnative, boolean stubonly) {
        if (comp instanceof StubsComponent) {
            return true;
        }
        Boolean val = UiEngineExtension.shallStubNative(comp);
        if (val != null) {
            stubnative = val;
        }
        if ((val = UiEngineExtension.shallStubonly(comp)) != null) {
            stubonly = val;
        }
        boolean allstub = true;
        boolean anychild = false;
        Component child = comp.getFirstChild();
        while (child != null) {
            Component n = child.getNextSibling();
            if (!UiEngineExtension.stub(child, stubnative, stubonly)) {
                allstub = false;
            }
            child = n;
            anychild = true;
        }
        boolean bNative = comp instanceof Native;
        if (bNative && !stubnative || !bNative && !stubonly) {
            return false;
        }
        if (allstub && anychild) {
            new StubsComponent().replace(comp, false, true, false);
            return true;
        }
        new StubComponent().replace(comp, false, true, true);
        return !anychild;
    }

    private static final Component merge(Component comp) {
        Component c;
        Object xc;
        Merger p = null;
        Component child = comp.getFirstChild();
        while (child != null) {
            Object xc2;
            child = UiEngineExtension.merge(child);
            if (p != null) {
                Component c2 = p.mergeNextSibling();
                if (c2 != null) {
                    child = c2;
                }
                p = null;
            }
            Component n = child.getNextSibling();
            if (p == null && n != null && (xc2 = ((ComponentCtrl)child).getExtraCtrl()) instanceof Merger) {
                p = (Merger)xc2;
            }
            child = n;
        }
        child = comp.getFirstChild();
        if (child != null && (xc = ((ComponentCtrl)comp).getExtraCtrl()) instanceof Merger && (c = ((Merger)xc).mergeChildren()) != null) {
            return c;
        }
        return comp;
    }
}

