/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.comet;

import java.io.IOException;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zkex.ui.comet.CometServerPush;
import org.zkoss.zkmax.ui.comet.CometAsyncServlet;

public class CometServerPush
extends org.zkoss.zkex.ui.comet.CometServerPush {
    private static final Log log = Log.lookup(CometServerPush.class);
    private boolean _async;

    public CometServerPush() {
        this(CometServerPush.defaultAsync());
    }

    private static final boolean defaultAsync() {
        String PROP = "org.zkoss.zkmax.ui.comet.async.disabled";
        String s = Library.getProperty((String)"org.zkoss.zkmax.ui.comet.async.disabled");
        boolean disabled = "true".equals(s);
        boolean servlet3 = Servlets.isServlet3();
        if (!disabled && s != null && !servlet3) {
            log.warning("org.zkoss.zkmax.ui.comet.async.disabled ignored, since the server doesn't support Servlet 3");
        }
        return !disabled && servlet3;
    }

    public CometServerPush(boolean async) {
        this._async = async;
    }

    public void start(Desktop desktop) {
        if (this._async && !CometAsyncServlet.isInstalled(desktop.getWebApp().getServletContext())) {
            log.warning("The asynchronous comet not used because CometAsyncServlet failed to install");
            this._async = false;
        }
        super.start(desktop);
    }

    protected String getStartScript() {
        if (!this._async) {
            return super.getStartScript();
        }
        return "zk.load('zkex.cmsp');zk.afterLoad(function(){zkmax.cmsp.start('" + this.getDesktop().getId() + "');});";
    }

    protected String getStopScript() {
        if (!this._async) {
            return super.getStopScript();
        }
        return "zkmax.cmsp.stop('" + this.getDesktop().getId() + "');";
    }

    protected void onStart() {
        if (!this._async) {
            super.onStart();
            return;
        }
    }

    protected synchronized boolean setBusy() {
        return super.setBusy();
    }

    protected void processRequest(Execution exec, CometServerPush.AsyncInfo ai) throws IOException {
        super.processRequest(exec, ai);
    }
}

