/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import javax.servlet.ServletException;
import org.zkoss.bind.Converter;
import org.zkoss.bind.Validator;
import org.zkoss.bind.impl.SystemConverters;
import org.zkoss.bind.impl.SystemValidators;
import org.zkoss.bind.validator.DeferredValidator;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zkmax.bind.impl.ChildrenBindingConverter;

public class Init {
    public static final String APP_CONVERTERS = "org.zkoss.bind.appConverters";
    public static final String APP_VALIDATORS = "org.zkoss.bind.appValidators";
    private static final Log _log = Log.lookup(SystemConverters.class);

    public static void init(WebApp wapp) throws ServletException {
        String validators;
        SystemConverters.set((String)"childrenBinding", (Converter)new ChildrenBindingConverter());
        SystemValidators.set((String)"beanValidator", (Validator)new DeferredValidator("org.zkoss.zkmax.bind.BeanValidator"));
        SystemValidators.set((String)"formBeanValidator", (Validator)new DeferredValidator("org.zkoss.zkmax.bind.FormBeanValidator"));
        String converters = Library.getProperty((String)APP_CONVERTERS);
        if (!Strings.isBlank((String)converters)) {
            String[][] pairs;
            for (String[] pair : pairs = Init.parsePairs(converters)) {
                try {
                    SystemConverters.set((String)pair[0], (Converter)((Converter)Classes.newInstanceByThread((String)pair[1])));
                }
                catch (Exception x) {
                    _log.error(x.getMessage(), (Throwable)x);
                }
            }
        }
        if (!Strings.isBlank((String)(validators = Library.getProperty((String)APP_VALIDATORS)))) {
            String[][] pairs;
            for (String[] pair : pairs = Init.parsePairs(validators)) {
                try {
                    SystemValidators.set((String)pair[0], (Validator)((Validator)Classes.newInstanceByThread((String)pair[1])));
                }
                catch (Exception x) {
                    _log.error(x.getMessage(), (Throwable)x);
                }
            }
        }
    }

    private static String[][] parsePairs(String pairs) {
        String[] items = pairs.split(",");
        String[][] result = new String[items.length][];
        for (int i = 0; i < items.length; ++i) {
            String[] val = items[i].split("=", 2);
            if (val.length != 2) {
                throw new IllegalSyntaxException("pairs syntax error " + pairs);
            }
            result[i] = new String[2];
            result[i][0] = val[0].trim();
            result[i][1] = val[1].trim();
        }
        return result;
    }
}

