/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.zkoss.bind.Property;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.validator.AbstractValidator;
import org.zkoss.bind.validator.BeanValidations;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormBeanValidator
extends AbstractValidator {
    protected Validator getValidator() {
        return BeanValidations.getValidator();
    }

    protected Set<ConstraintViolation<?>> validate(Class clz, String property, Object value) {
        return this.getValidator().validateValue(clz, property, value, new Class[0]);
    }

    protected void sort(List<ConstraintViolation<?>> viloations) {
        Collections.sort(viloations, new Comparator<ConstraintViolation<?>>(){

            @Override
            public int compare(ConstraintViolation<?> o1, ConstraintViolation<?> o2) {
                String s1 = ((Object)o1.getConstraintDescriptor().getAnnotation()).toString();
                String s2 = ((Object)o2.getConstraintDescriptor().getAnnotation()).toString();
                return s1.compareTo(s2);
            }
        });
    }

    protected void handleConstraintViolation(ValidationContext ctx, String key, Set<ConstraintViolation<?>> violations) {
        int s = violations.size();
        if (s == 1) {
            this.addInvalidMessages(ctx, key, new String[]{violations.iterator().next().getMessage()});
        } else if (s > 0) {
            String[] msgs = new String[violations.size()];
            ArrayList l = new ArrayList(violations);
            this.sort(l);
            for (int i = 0; i < msgs.length; ++i) {
                msgs[i] = ((ConstraintViolation)l.get(i)).getMessage();
            }
            this.addInvalidMessages(ctx, key, msgs);
        }
    }

    protected Class getBeanClass(ValidationContext ctx, Object base) {
        return base.getClass();
    }

    public void validate(ValidationContext ctx) {
        Property p = ctx.getProperty();
        Object base = p.getBase();
        if (ctx.getBindContext().getBinding() instanceof SaveFormBinding) {
            String prefix = (String)ctx.getValidatorArg("prefix");
            if (Strings.isEmpty((String)prefix)) {
                throw new NullPointerException("prefix of message key is empty, did you set prefix argument in @validator?");
            }
            Class clz = this.getBeanClass(ctx, base);
            Map beanProps = ctx.getProperties(base);
            String pname = null;
            for (Property prop : beanProps.values()) {
                Set<ConstraintViolation<?>> s;
                pname = prop.getProperty();
                if (".".equals(pname) || (s = this.validate(clz, pname, prop.getValue())).size() <= 0) continue;
                this.handleConstraintViolation(ctx, prefix + pname, s);
            }
        } else {
            throw new UiException("Can be used in form binding only");
        }
    }
}

