/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.http;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.mesg.Messages;
import org.zkoss.util.CacheMap;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.zk.au.http.AuExtension;
import org.zkoss.zk.au.http.DHtmlUpdateServlet;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.FiledownloadListener;

public class AuDownloader
implements AuExtension {
    private static final Log log = Log.lookup(AuDownloader.class);
    private static FiledownloadListener _listener;
    private static final String URI_PREFIX = "/download";
    private static final CacheMap<String, Character> _dls;
    private ServletContext _ctx;
    private static char[] _encc;

    public static void init(WebApp wapp) throws ServletException {
        if (DHtmlUpdateServlet.getAuExtension((WebApp)wapp, (String)URI_PREFIX) == null) {
            String clsnm = Library.getProperty((String)"org.zkoss.zkmax.zul.FiledownloadListener.class");
            if (clsnm != null) {
                try {
                    _listener = (FiledownloadListener)Classes.newInstanceByThread((String)clsnm);
                }
                catch (Throwable ex) {
                    log.warning("Failed to instantiate " + clsnm);
                }
            }
            DHtmlUpdateServlet.addAuExtension((WebApp)wapp, (String)URI_PREFIX, (AuExtension)new AuDownloader());
            Runtime.init((Object)wapp);
            _dls.setMaxSize(Library.getIntProperty((String)"org.zkoss.zk.download.resumable.maxsize", (int)4096));
            _dls.setLifetime(Library.getIntProperty((String)"org.zkoss.zk.download.resumable.lifetime", (int)14400) * 1000);
        }
    }

    private AuDownloader() {
    }

    public void init(DHtmlUpdateServlet servlet) {
        this._ctx = servlet.getServletContext();
    }

    public void destroy() {
    }

    public static String getDownloadURI(File file, String contentType, String data) {
        return AuDownloader.getDownloadURI('f', file.getAbsolutePath(), contentType, data);
    }

    public static String getDownloadURI(URL url, String contentType, String data) {
        return AuDownloader.getDownloadURI('u', url.toExternalForm(), contentType, data);
    }

    public static String getDownloadURI(String path, String contentType, String data) {
        String dir;
        if (path.length() > 0 && path.charAt(0) != '/' && (dir = Executions.getCurrent().getDesktop().getCurrentDirectory()) != null) {
            path = dir + path;
        }
        return AuDownloader.getDownloadURI('p', path, contentType, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDownloadURI(char type, String path, String contentType, String data) {
        int v1;
        char cc;
        Desktop desktop = Executions.getCurrent().getDesktop();
        StringBuffer sb = new StringBuffer(256).append(URI_PREFIX).append('/').append(type);
        int j = path.length();
        int v3 = 0;
        while (--j >= 0 && (cc = path.charAt(j)) != '/') {
            if (cc != '\\') continue;
            v3 = 16;
            break;
        }
        int n = contentType != null ? (contentType.length() > 0 ? 2 : 1) : (v1 = 0);
        int v2 = data != null ? (data.length() > 0 ? 8 : 4) : 0;
        sb.append((char)(v1 + v2 + v3 + 65));
        if (v1 == 2) {
            AuDownloader.encode(sb, contentType);
            if (v2 == 8) {
                sb.append('/');
            }
        }
        if (v2 == 8) {
            AuDownloader.encode(sb, data);
        }
        sb.append('/');
        if (j >= 0) {
            AuDownloader.encode(sb, path.substring(0, j));
            sb.append('/').append(path.substring(j + 1));
        } else {
            sb.append(path);
        }
        CacheMap<String, Character> cacheMap = _dls;
        synchronized (cacheMap) {
            _dls.put((Object)path, (Object)new Character(type));
        }
        return desktop.getUpdateURI(sb.toString());
    }

    private static void encode(StringBuffer sb, String txt) {
        if (txt != null && txt.length() != 0) {
            Random rand = new Random();
            int gpsz = 62 / _encc.length;
            int len = txt.length();
            block0: for (int j = 0; j < len; ++j) {
                char cc = txt.charAt(j);
                int k = _encc.length;
                while (--k >= 0) {
                    if (cc != _encc[k]) continue;
                    sb.append('m');
                    int v = gpsz * k + rand.nextInt(gpsz);
                    if (v < 26) {
                        sb.append((char)(97 + v));
                        continue block0;
                    }
                    if (v < 52) {
                        sb.append((char)(65 + v - 26));
                        continue block0;
                    }
                    sb.append((char)(48 + v - 52));
                    continue block0;
                }
                sb.append(cc);
            }
        }
    }

    private static String decode(String txt) {
        StringBuffer sb = new StringBuffer(256);
        int gpsz = 62 / _encc.length;
        int len = txt.length();
        for (int j = 0; j < len; ++j) {
            char cc = txt.charAt(j);
            if (cc == 'm' && ++j < len) {
                cc = txt.charAt(j);
                int v = cc >= 'a' && cc <= 'z' ? cc - 97 : (cc >= 'A' && cc <= 'Z' ? cc - 65 + 26 : (cc >= '0' && cc <= '9' ? cc - 48 + 52 : -1));
                if (v >= 0) {
                    sb.append(_encc[v / gpsz]);
                    continue;
                }
                sb.append('m');
            }
            sb.append(cc);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        String path = null;
        String contentType = null;
        String data = null;
        char type = '\u0000';
        int j = pi.indexOf(47, 1);
        if (j >= 0 && j < pi.length() - 3) {
            int k;
            type = pi.charAt(++j);
            int v = pi.charAt(++j) - 65;
            if ((k = pi.indexOf(47, ++j)) >= 0 && v <= 26 && v >= 0) {
                switch (v & 3) {
                    case 1: {
                        contentType = "";
                        break;
                    }
                    case 2: {
                        contentType = AuDownloader.decode(pi.substring(j, k));
                        j = k + 1;
                        k = pi.indexOf(47, j);
                    }
                }
                switch (v & 0xC) {
                    case 4: {
                        data = "";
                        break;
                    }
                    case 8: {
                        if (k < 0) break;
                        data = AuDownloader.decode(pi.substring(j, k));
                        j = k + 1;
                        k = pi.indexOf(47, j);
                    }
                }
                if ((v & 0xF) == 0) {
                    j = k + 1;
                    k = pi.indexOf(47, j);
                }
                path = k >= 0 ? AuDownloader.decode(pi.substring(j, k)) + ((v & 0x10) != 0 ? (char)'\\' : '/') + pi.substring(k + 1) : pi.substring(j);
            }
        }
        Runtime.init((Object)this);
        Media media = null;
        Object source = null;
        if (path != null && path.length() > 0) {
            URL url;
            Character o;
            CacheMap<String, Character> cacheMap = _dls;
            synchronized (cacheMap) {
                _dls.expunge();
                o = (Character)_dls.getWithoutExpunge((Object)path);
            }
            if (o.charValue() != type) {
                response.sendError(410, Messages.get((int)MZk.PAGE_NOT_FOUND, (Object)(path != null ? path : pi)));
                return;
            }
            if (type == 'p') {
                source = path;
                url = this._ctx.getResource(path);
                if (url != null) {
                    media = new AMedia(url, contentType, null);
                }
            } else if (type == 'f') {
                File file = new File(path);
                source = file;
                media = new AMedia(file, contentType, null);
            } else if (type == 'u') {
                url = new URL(path);
                source = url;
                media = new AMedia(url, contentType, null);
            }
        }
        if (media == null) {
            response.sendError(410, Messages.get((int)MZk.PAGE_NOT_FOUND, (Object)(path != null ? path : pi)));
            return;
        }
        if (_listener != null && (media = _listener.onDownload(media, source, data)) == null) {
            response.sendError(403, "Not allowed " + path);
            return;
        }
        Https.write((HttpServletRequest)request, (HttpServletResponse)response, (Media)media, (boolean)true, (boolean)true);
    }

    static {
        _dls = new CacheMap();
        _encc = new char[]{'m', '/', '\\', 'r', ':', 'g', 's', '?', ';', '%'};
    }
}

