/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet;

import java.io.Serializable;
import org.zkoss.lang.Objects;

public class StyleSheet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20100514L;
    private final String _href;
    private final String _type;
    private final String _content;
    private final String _media;

    public StyleSheet(String href, String type) {
        this(href, type, null, false);
    }

    public StyleSheet(String content, String type, boolean byContent) {
        this(content, type, null, byContent);
    }

    public StyleSheet(String content, String type, String media, boolean byContent) {
        if (content == null) {
            throw new IllegalArgumentException("null content");
        }
        if (byContent) {
            this._href = null;
            this._content = content;
        } else {
            this._href = content;
            this._content = null;
        }
        this._type = type != null && type.length() != 0 ? type : "text/css";
        this._media = media != null && media.length() != 0 ? media : null;
    }

    public String getHref() {
        return this._href;
    }

    public String getType() {
        return this._type;
    }

    public String getMedia() {
        return this._media;
    }

    public String getContent() {
        return this._content;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return "[href: " + this._href + " type=" + this._type + ']';
    }

    public int hashCode() {
        return this._href.hashCode() + this._type.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StyleSheet)) {
            return false;
        }
        StyleSheet ss = (StyleSheet)o;
        return Objects.equals((Object)ss._href, (Object)this._href) && Objects.equals((Object)ss._type, (Object)this._type) && Objects.equals((Object)ss._content, (Object)this._content) && Objects.equals((Object)ss._media, (Object)this._media);
    }
}

