/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.embedded;

import java.util.Arrays;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.CommonDeployableContainer;
import org.jboss.as.arquillian.container.embedded.EmbeddedContainerConfiguration;
import org.jboss.as.arquillian.container.embedded.SecurityActions;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.StandaloneServer;

public final class EmbeddedDeployableContainer
extends CommonDeployableContainer<EmbeddedContainerConfiguration> {
    private StandaloneServer server;

    public void setup(EmbeddedContainerConfiguration config) {
        super.setup((CommonContainerConfiguration)config);
        if (config.getCleanServerBaseDir() != null) {
            SecurityActions.setSystemProperty("jboss.embedded.root", config.getCleanServerBaseDir());
        }
        String[] cmdArgs = EmbeddedDeployableContainer.getCommandArgs(config);
        this.server = EmbeddedProcessFactory.createStandaloneServer((String)config.getJbossHome(), (String)config.getModulePath(), (String[])config.getSystemPackagesArray(), (String[])cmdArgs);
    }

    public Class<EmbeddedContainerConfiguration> getConfigurationClass() {
        return EmbeddedContainerConfiguration.class;
    }

    protected void startInternal() throws LifecycleException {
        try {
            this.server.start();
        }
        catch (Throwable e) {
            throw new LifecycleException("Could not invoke start on: " + this.server, e);
        }
    }

    protected void stopInternal(Integer timeout) throws LifecycleException {
        try {
            this.server.stop();
        }
        catch (Throwable e) {
            throw new LifecycleException("Could not invoke stop on: " + this.server, e);
        }
    }

    private static String[] getCommandArgs(EmbeddedContainerConfiguration config) {
        String configFile = config.getServerConfig();
        String arguments = config.getJbossArguments();
        if (arguments == null) {
            if (configFile == null) {
                return new String[0];
            }
            return new String[]{"-c=" + configFile};
        }
        if (configFile == null) {
            return arguments.split("\\s+");
        }
        String[] args = arguments.split("\\s+");
        int i = args.length;
        args = Arrays.copyOf(args, i + 1);
        args[i] = "-c=" + configFile;
        return args;
    }
}

