/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.signing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import org.vafer.jdeb.shaded.bc.bcpg.ArmoredOutputStream;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGOutputStream;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPrivateKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSecretKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSecretKeyRing;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSecretKeyRingCollection;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignature;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignatureGenerator;
import org.vafer.jdeb.shaded.bc.openpgp.PGPUtil;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.vafer.jdeb.shaded.compress.io.LineIterator;

public class PGPSigner {
    private static final byte[] EOL = "\n".getBytes(Charset.forName("UTF-8"));
    private PGPSecretKey secretKey;
    private PGPPrivateKey privateKey;

    public PGPSigner(InputStream keyring, String keyId, String passphrase) throws IOException, PGPException {
        this.secretKey = this.getSecretKey(keyring, keyId);
        if (this.secretKey == null) {
            throw new PGPException(String.format("Specified key %s does not exist in key ring %s", keyId, keyring));
        }
        this.privateKey = this.secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder(new BcPGPDigestCalculatorProvider()).build(passphrase.toCharArray()));
    }

    public void clearSign(String input, OutputStream output) throws IOException, PGPException, GeneralSecurityException {
        this.clearSign(new ByteArrayInputStream(input.getBytes("UTF-8")), output);
    }

    public void clearSign(InputStream input, OutputStream output) throws IOException, PGPException, GeneralSecurityException {
        int digest = 2;
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(new BcPGPContentSignerBuilder(this.privateKey.getPublicKeyPacket().getAlgorithm(), digest));
        signatureGenerator.init(1, this.privateKey);
        ArmoredOutputStream armoredOutput = new ArmoredOutputStream(output);
        armoredOutput.beginClearText(digest);
        LineIterator iterator = new LineIterator(new InputStreamReader(input));
        while (iterator.hasNext()) {
            String line = iterator.nextLine();
            byte[] data = this.trim(line).getBytes("UTF-8");
            armoredOutput.write(data);
            armoredOutput.write(EOL);
            signatureGenerator.update(data);
            if (!iterator.hasNext()) continue;
            signatureGenerator.update(EOL);
        }
        armoredOutput.endClearText();
        PGPSignature signature = signatureGenerator.generate();
        signature.encode(new BCPGOutputStream(armoredOutput));
        armoredOutput.close();
    }

    public PGPSecretKey getSecretKey() {
        return this.secretKey;
    }

    public PGPPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    private PGPSecretKey getSecretKey(InputStream input, String keyId) throws IOException, PGPException {
        PGPSecretKeyRingCollection keyrings = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(input));
        Iterator rIt = keyrings.getKeyRings();
        while (rIt.hasNext()) {
            PGPSecretKeyRing kRing = (PGPSecretKeyRing)rIt.next();
            Iterator kIt = kRing.getSecretKeys();
            while (kIt.hasNext()) {
                PGPSecretKey key = (PGPSecretKey)kIt.next();
                if (!key.isSigningKey() || !String.format("%08x", key.getKeyID() & 0xFFFFFFFFL).equals(keyId.toLowerCase())) continue;
                return key;
            }
        }
        return null;
    }

    private String trim(String line) {
        int len;
        char[] chars = line.toCharArray();
        for (len = chars.length; len > 0 && Character.isWhitespace(chars[len - 1]); --len) {
        }
        return line.substring(0, len);
    }
}

