/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.mapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarArchiveEntry;

public final class LsMapper
implements Mapper {
    private final Map<String, TarArchiveEntry> mapping;
    private final Pattern basePattern = Pattern.compile("^\\./(.*):$");
    private final Pattern totalPattern = Pattern.compile("^total ([0-9]+)$");
    private final Pattern dirPattern = Pattern.compile("^d([rwx-]{9})\\s+([0-9]+)\\s+(\\S*)\\s+(\\S*)\\s+([0-9]+)\\s+(.*)\\s+[\\.]{1,2}$");
    private final Pattern filePattern = Pattern.compile("^([d-])([rwx-]{9})\\s+([0-9]+)\\s+(\\S*)\\s+(\\S*)\\s+([0-9]+)\\s+(.*)\\s+(.*)$");
    private final Pattern newlinePattern = Pattern.compile("$");

    public LsMapper(InputStream pInput) throws IOException, ParseError {
        this.mapping = this.parse(pInput);
    }

    private String readBase(BufferedReader reader) throws IOException, ParseError {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        Matcher matcher = this.basePattern.matcher(line);
        if (!matcher.matches()) {
            throw new ParseError("expected base line but got \"" + line + "\"");
        }
        return matcher.group(1);
    }

    private String readTotal(BufferedReader reader) throws IOException, ParseError {
        String line = reader.readLine();
        Matcher matcher = this.totalPattern.matcher(line);
        if (!matcher.matches()) {
            throw new ParseError("expected total line but got \"" + line + "\"");
        }
        return matcher.group(1);
    }

    private TarArchiveEntry readDir(BufferedReader reader, String base) throws IOException, ParseError {
        String current = reader.readLine();
        Matcher currentMatcher = this.dirPattern.matcher(current);
        if (!currentMatcher.matches()) {
            throw new ParseError("expected dirline but got \"" + current + "\"");
        }
        String parent = reader.readLine();
        Matcher parentMatcher = this.dirPattern.matcher(parent);
        if (!parentMatcher.matches()) {
            throw new ParseError("expected dirline but got \"" + parent + "\"");
        }
        TarArchiveEntry entry = new TarArchiveEntry(base, true);
        entry.setMode(this.convertModeFromString(currentMatcher.group(1)));
        entry.setUserName(currentMatcher.group(3));
        entry.setGroupName(currentMatcher.group(4));
        return entry;
    }

    private int convertModeFromString(String mode) {
        char[] m = mode.toCharArray();
        int sum = 0;
        int bit = 1;
        for (int i = m.length - 1; i >= 0; --i) {
            if (m[i] != '-') {
                sum += bit;
            }
            bit += bit;
        }
        return sum;
    }

    private TarArchiveEntry readFile(BufferedReader reader, String base) throws IOException, ParseError {
        Matcher currentMatcher;
        String type;
        do {
            String line;
            if ((line = reader.readLine()) == null) {
                return null;
            }
            currentMatcher = this.filePattern.matcher(line);
            if (currentMatcher.matches()) continue;
            Matcher newlineMatcher = this.newlinePattern.matcher(line);
            if (newlineMatcher.matches()) {
                return null;
            }
            throw new ParseError("expected file line but got \"" + line + "\"");
        } while (!(type = currentMatcher.group(1)).startsWith("-"));
        TarArchiveEntry entry = new TarArchiveEntry(base + "/" + currentMatcher.group(8), true);
        entry.setMode(this.convertModeFromString(currentMatcher.group(2)));
        entry.setUserName(currentMatcher.group(4));
        entry.setGroupName(currentMatcher.group(5));
        return entry;
    }

    private Map<String, TarArchiveEntry> parse(InputStream pInput) throws IOException, ParseError {
        HashMap<String, TarArchiveEntry> mapping = new HashMap<String, TarArchiveEntry>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(pInput));
        boolean first = true;
        block0: while (true) {
            String base;
            if (first) {
                base = "";
                first = false;
            } else {
                base = this.readBase(reader);
                if (base == null) break;
            }
            this.readTotal(reader);
            TarArchiveEntry dir = this.readDir(reader, base);
            mapping.put(dir.getName(), dir);
            while (true) {
                TarArchiveEntry file;
                if ((file = this.readFile(reader, base)) == null) continue block0;
                mapping.put(file.getName(), file);
            }
            break;
        }
        return mapping;
    }

    @Override
    public TarArchiveEntry map(TarArchiveEntry pEntry) {
        TarArchiveEntry entry = this.mapping.get(pEntry.getName());
        if (entry != null) {
            return entry;
        }
        return pEntry;
    }

    public static final class ParseError
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseError(String message) {
            super(message);
        }
    }
}

