/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.format.impl;

import java.util.regex.Pattern;
import org.tinygroup.format.PatternDefine;

public class DefaultPatternDefine
implements PatternDefine {
    private static final String DEFAULT_PATTERN_STRING = "([$]+[{]+[a-zA-Z0-9[.[_[:[/[#]]]]]]+[}])";
    private static final String DEFAULT_POSTFIX_PATTERN_STRING = "}";
    private static final String DEFAULT_PREFIX_PATTERN_STRING = "${";
    private static final char DEFAULT_SPLIT_CHAR = ':';
    private String prefixPatternString = "${";
    private String postfixPatternString = "}";
    private String patternString = "([$]+[{]+[a-zA-Z0-9[.[_[:[/[#]]]]]]+[}])";
    private Pattern pattern;
    private char splitChar = (char)58;

    @Override
    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.patternString);
        }
        return this.pattern;
    }

    @Override
    public void setPrefixPatternString(String prefixPatternString) {
        this.prefixPatternString = prefixPatternString;
    }

    @Override
    public void setPostfixPatternString(String postfixPatternString) {
        this.postfixPatternString = postfixPatternString;
    }

    @Override
    public void setPatternString(String patternString) {
        this.patternString = patternString;
    }

    @Override
    public String getPureMatchText(String string) {
        int startPos = this.prefixPatternString.length();
        int endPos = string.length() - this.postfixPatternString.length();
        return string.substring(startPos, endPos);
    }

    @Override
    public String getFullMatchText(String string) {
        return String.format("%s%s%s", this.prefixPatternString, string, this.postfixPatternString);
    }

    @Override
    public char getSplitChar() {
        return this.splitChar;
    }

    @Override
    public void setSplitChar(char splitChar) {
        this.splitChar = splitChar;
    }
}

