/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.config.util;

import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

public class TinyConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyConfig.class);

    public static String getString(String key, String defaultValue, boolean allowBlank) {
        if (!TinyConfig.contain(key)) {
            return defaultValue;
        }
        String value = TinyConfig.getValue(key);
        if (StringUtil.isBlank((String)value)) {
            if (allowBlank) {
                return value;
            }
            return defaultValue;
        }
        return value;
    }

    public static Boolean getBoolean(String key, Boolean defaultValue, boolean notallowParseException) {
        String value = TinyConfig.getValue(key);
        if (StringUtil.isBlank((String)value)) {
            return defaultValue;
        }
        if (notallowParseException) {
            return Boolean.valueOf(value);
        }
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            LOGGER.warnMessage("\u8f6c\u6362\u914d\u7f6e\u53c2\u6570:{}\u4e3aBoolean\u65f6\u51fa\u9519,\u503c:{}", new Object[]{key, value});
            return defaultValue;
        }
    }

    public static int getInt(String key, int defaultValue, boolean notallowParseException) {
        String value = TinyConfig.getValue(key);
        if (StringUtil.isBlank((String)value)) {
            return defaultValue;
        }
        if (notallowParseException) {
            return Integer.parseInt(value);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            LOGGER.warnMessage("\u8f6c\u6362\u914d\u7f6e\u53c2\u6570:{}\u4e3aInt\u65f6\u51fa\u9519,\u503c:{}", new Object[]{key, value});
            return defaultValue;
        }
    }

    public static Integer getInteger(String key, Integer defaultValue, boolean notallowParseException) {
        String value = TinyConfig.getValue(key);
        if (StringUtil.isBlank((String)value)) {
            return defaultValue;
        }
        if (notallowParseException) {
            return Integer.valueOf(value);
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            LOGGER.warnMessage("\u8f6c\u6362\u914d\u7f6e\u53c2\u6570:{}\u4e3aInteger\u65f6\u51fa\u9519,\u503c:{}", new Object[]{key, value});
            return defaultValue;
        }
    }

    public static String getValue(String key) {
        ConfigurationManager manager = ConfigurationUtil.getConfigurationManager();
        return manager.getConfiguration(key);
    }

    public static boolean contain(String key) {
        ConfigurationManager manager = ConfigurationUtil.getConfigurationManager();
        return manager.getConfiguration().containsKey(key);
    }

    public static void setValue(String key, String value) {
        ConfigurationManager manager = ConfigurationUtil.getConfigurationManager();
        manager.setConfiguration(key, value);
    }
}

