/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.config.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

public class IpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IpUtil.class);

    public static InetAddress getLocalHostLanAddress() throws Exception {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u5ba2\u6237\u7aef\u83b7\u53d6InetAddress\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    public static String getLocalIp() {
        try {
            return IpUtil.getLocalHostLanAddress().getHostAddress();
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u83b7\u53d6\u672c\u673aIP\u5931\u8d25", (Throwable)e);
            return "unkonwn_ip";
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOGGER.logMessage(LogLevel.ERROR, "\u83b7\u53d6\u672c\u673a\u4e3b\u673a\u540d\u5931\u8d25", (Throwable)e);
            return "unkonwn_hostname";
        }
    }
}

