/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.config.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tinygroup.commons.tools.ValueUtil;
import org.tinygroup.config.ConfigManagerFactory;
import org.tinygroup.config.Configuration;
import org.tinygroup.config.ConfigurationLoader;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.util.ConfigurationUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.PathFilter;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationManagerImpl.class);
    private ConfigurationLoader configurationLoader;
    private XmlNode applicationConfiguration;
    private Map<String, XmlNode> componentConfigurationMap = new HashMap<String, XmlNode>();
    private Collection<Configuration> configurationList;

    @Override
    public void setConfigurationLoader(ConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
    }

    @Override
    public void setComponentConfiguration(String key, XmlNode componentConfiguration) {
        this.componentConfigurationMap.put(key, componentConfiguration);
    }

    @Override
    public XmlNode getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    @Override
    public void setApplicationConfiguration(XmlNode applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    public Map<String, XmlNode> getComponentConfigurationMap() {
        return this.componentConfigurationMap;
    }

    @Override
    public void setComponentConfigurationMap(Map<String, XmlNode> componentConfigurationMap) {
        this.componentConfigurationMap = componentConfigurationMap;
    }

    @Override
    public XmlNode getComponentConfiguration(String key) {
        return this.componentConfigurationMap.get(key);
    }

    @Override
    public void distributeConfiguration() {
        if (this.configurationList != null) {
            LOGGER.logMessage(LogLevel.INFO, "\u6b63\u5728\u5206\u53d1\u5e94\u7528\u914d\u7f6e\u4fe1\u606f...");
            PathFilter pathFilter = new PathFilter((Node)this.applicationConfiguration);
            for (Configuration configurationItem : this.configurationList) {
                XmlNode componentConfig = this.componentConfigurationMap.get(configurationItem.getComponentConfigPath());
                XmlNode appConfig = null;
                if (configurationItem.getApplicationNodePath() != null) {
                    appConfig = (XmlNode)pathFilter.findNode(configurationItem.getApplicationNodePath());
                }
                configurationItem.config(appConfig, componentConfig);
            }
            LOGGER.logMessage(LogLevel.INFO, "\u5e94\u7528\u914d\u7f6e\u4fe1\u606f\u5206\u53d1\u5b8c\u6bd5");
        }
    }

    @Override
    public void setConfigurationList(Collection<Configuration> configurationList) {
        this.configurationList = configurationList;
    }

    @Override
    public void setConfiguration(String key, String value) {
        ConfigManagerFactory.getManager().addConfig(key, value);
    }

    @Override
    public <T> T getConfiguration(Class<T> type, String key, T defaultValue) {
        String value = ConfigManagerFactory.getManager().getConfig(key);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return (T)ValueUtil.getValue((String)value, (String)type.getName());
    }

    public void loadConfiguration() {
        if (this.configurationLoader != null) {
            this.setApplicationConfiguration(this.configurationLoader.loadApplicationConfiguration());
            this.setComponentConfigurationMap(this.configurationLoader.loadComponentConfiguration());
        }
    }

    @Override
    @Deprecated
    public Map<String, String> getConfiguration() {
        return ConfigManagerFactory.getManager().getConfigMap();
    }

    @Override
    public String getConfiguration(String key) {
        return ConfigManagerFactory.getManager().getConfig(key);
    }

    @Override
    public void replace() {
        String applicationInfo = this.getApplicationConfiguration().toString();
        String newInfo = ConfigurationUtil.replace(applicationInfo, this.getConfiguration());
        XmlNode newXml = (XmlNode)new XmlStringParser().parse(newInfo).getRoot();
        this.setApplicationConfiguration(newXml);
    }

    @Override
    public void clear() {
        if (this.configurationList != null) {
            this.configurationList.clear();
        }
        this.componentConfigurationMap.clear();
        ConfigManagerFactory.getManager().clear();
        this.applicationConfiguration = null;
    }
}

