/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.config;

import java.util.Map;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.ValueUtil;
import org.tinygroup.config.ConfigCurdManager;

public class ConfigManager
extends ConfigCurdManager {
    public ConfigManager() {
    }

    public ConfigManager(boolean isConfigMap) {
        super(isConfigMap);
    }

    public Map<String, String> getConfigMap() {
        return this.merageMap;
    }

    public <T> T getConfig(Class<T> type, String key, T defaultValue) {
        String value = this.getConfig(key);
        if (StringUtil.isBlank((String)value)) {
            return defaultValue;
        }
        return (T)ValueUtil.getValue((String)value, (String)type.getName());
    }

    public String getConfig(String key) {
        return this.getConfigMap().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfig(String key, String value) {
        ConfigManager configManager = this;
        synchronized (configManager) {
            this.head.getMap().put(key, value);
            if (!this.exist(key)) {
                this.merageMap.put(key, value);
            }
        }
    }

    private boolean exist(String key) {
        ConfigCurdManager.MapItem item = this.head.next;
        while (item != null) {
            if (item.containsKey(key)) {
                return true;
            }
            item = item.next;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfig(String key) {
        ConfigManager configManager = this;
        synchronized (configManager) {
            this.head.getMap().remove(key);
            if (!this.exist(key)) {
                this.merageMap.remove(key);
            }
        }
    }

    public void clear() {
        for (Map.Entry entry : this.configs.entrySet()) {
            ((ConfigCurdManager.MapItem)entry.getValue()).clear();
        }
        this.configs.clear();
        this.configs = null;
        this.merageMap.clear();
        this.merageMap = null;
        this.tail.clear();
        this.tail = null;
        this.head.clear();
        this.head = null;
    }
}

