/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tinygroup.config.ConfigMap;
import org.tinygroup.config.util.ConfigurationUtil;

public class ConfigCurdManager {
    public static final String HEAD_KEY = "head";
    public static final String TAIL_KEY = "tail";
    Map<String, MapItem> configs = new HashMap<String, MapItem>();
    boolean isConfigMap = true;
    Map<String, String> merageMap;
    MapItem tail;
    MapItem head;

    public ConfigCurdManager() {
        this(true);
    }

    public ConfigCurdManager(boolean isConfigMap) {
        this.isConfigMap = isConfigMap;
        this.head = new MapItem(isConfigMap);
        this.head.next = this.tail = new MapItem(isConfigMap);
        this.tail.pre = this.head;
        this.merageMap = isConfigMap ? new HashMap<String, String>() : new ConfigMap();
    }

    private void putMapItem(String name, MapItem mapitem) {
        this.configs.put(name, mapitem);
        this.configsChange();
    }

    private void configsChange() {
        this.computeTempMap();
    }

    protected void computeTempMap() {
        if (this.isConfigMap) {
            this.configMapMod();
        } else {
            this.notconfigMapMod();
        }
    }

    private void notconfigMapMod() {
        Map<String, String> tempStore = new HashMap<String, String>();
        MapItem item = this.head;
        while (item != null) {
            this.merage(tempStore, new HashMap<String, String>(item.getMap()));
            item = item.next;
        }
        tempStore = ConfigurationUtil.replace(tempStore);
        ConfigMap tempMap3 = ((ConfigMap)this.merageMap).clone();
        this.compareAndUpdate(tempMap3, tempStore);
        this.merageMap = tempMap3;
    }

    private void merage(Map<String, String> tempStore, HashMap<String, String> hashMap) {
        tempStore.putAll(hashMap);
    }

    private void configMapMod() {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        MapItem item = this.head;
        while (item != null) {
            tempMap.putAll(item.getMap());
            item = item.next;
        }
        this.merageMap = tempMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(String name, Map<String, String> map) {
        if (this.checkDuplicateName(name, map)) {
            return;
        }
        ConfigCurdManager configCurdManager = this;
        synchronized (configCurdManager) {
            this.addBefore(this.tail, name, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(String name, Map<String, String> map) {
        if (this.checkDuplicateName(name, map)) {
            return;
        }
        ConfigCurdManager configCurdManager = this;
        synchronized (configCurdManager) {
            this.addAfter(this.head, name, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAfter(String targetName, String name, Map<String, String> map) {
        if (this.checkDuplicateName(name, map)) {
            return;
        }
        ConfigCurdManager configCurdManager = this;
        synchronized (configCurdManager) {
            MapItem targetItem = this.configs.get(targetName);
            if (targetItem == null) {
                throw new RuntimeException("not found target Map :" + targetName);
            }
            this.addAfter(targetItem, name, map);
        }
    }

    private boolean checkDuplicateName(String name, Map<String, String> map) {
        if (this.configs.containsKey(name)) {
            this.replace(name, map);
            return true;
        }
        return false;
    }

    public boolean ifExistTargetMapItem(String name) {
        return this.configs.containsKey(name);
    }

    private void addAfter(MapItem targetItem, String name, Map<String, String> map) {
        MapItem mapitem = new MapItem(map, this.isConfigMap);
        MapItem oldAfter = targetItem.next;
        oldAfter.pre = mapitem;
        mapitem.next = oldAfter;
        mapitem.pre = targetItem;
        targetItem.next = mapitem;
        this.putMapItem(name, mapitem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBefore(String targetName, String name, Map<String, String> map) {
        if (this.checkDuplicateName(name, map)) {
            return;
        }
        ConfigCurdManager configCurdManager = this;
        synchronized (configCurdManager) {
            MapItem targetItem = this.configs.get(targetName);
            if (targetItem == null) {
                throw new RuntimeException("not found target Map :" + targetName);
            }
            this.addBefore(targetItem, name, map);
        }
    }

    private void addBefore(MapItem targetItem, String name, Map<String, String> map) {
        MapItem mapitem = new MapItem(map, this.isConfigMap);
        MapItem oldpre = targetItem.pre;
        oldpre.next = mapitem;
        mapitem.pre = oldpre;
        mapitem.next = targetItem;
        targetItem.pre = mapitem;
        this.putMapItem(name, mapitem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String name, Map<String, String> map) {
        ConfigCurdManager configCurdManager = this;
        synchronized (configCurdManager) {
            MapItem targetItem = this.configs.get(name);
            if (targetItem == null) {
                throw new RuntimeException("not found target Map :" + name);
            }
            this.replace(targetItem, name, map);
        }
    }

    private void replace(MapItem targetItem, String name, Map<String, String> dest) {
        ConfigMap orMap;
        Map<String, String> cloneOrMap = orMap = targetItem.getMap();
        cloneOrMap = orMap instanceof ConfigMap ? ((ConfigMap)orMap).clone() : new HashMap<String, String>(orMap);
        HashMap<String, String> temp = new HashMap<String, String>(dest);
        this.compareAndUpdate(cloneOrMap, temp);
        targetItem.setMap(cloneOrMap);
        this.putMapItem(name, targetItem);
    }

    private void compareAndUpdate(Map<String, String> source, Map<String, String> dest) {
        Iterator<Map.Entry<String, String>> it = source.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<String>();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            if (!dest.containsKey(key)) {
                deleteKeys.add(key);
                continue;
            }
            String newValue = dest.remove(key);
            String oldValue = source.get(key);
            if (this.compare(oldValue, newValue)) continue;
            source.put(key, newValue);
        }
        for (String key : dest.keySet()) {
            source.put(key, dest.get(key));
        }
        for (String key : deleteKeys) {
            source.remove(key);
        }
    }

    private boolean compare(String value, String oldValue) {
        if (oldValue == null) {
            return value == null;
        }
        return oldValue.equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapItem(String name) {
        ConfigCurdManager configCurdManager = this;
        synchronized (configCurdManager) {
            MapItem removeItem = this.configs.remove(name);
            if (removeItem != null) {
                MapItem nextItem;
                MapItem preItem = removeItem.pre;
                preItem.next = nextItem = removeItem.next;
                nextItem.pre = preItem;
                this.configsChange();
            }
        }
    }

    class MapItem {
        Map<String, String> map;
        MapItem pre;
        MapItem next;

        public MapItem(boolean useConfigMap) {
            this(new HashMap<String, String>(), useConfigMap);
        }

        public void setMap(Map<String, String> cloneOrMap) {
            this.map = cloneOrMap;
        }

        public MapItem(Map<String, String> map2, boolean useConfigMap) {
            this.map = useConfigMap ? new ConfigMap(map2) : new HashMap<String, String>(map2);
        }

        public Map<String, String> getMap() {
            return this.map;
        }

        public boolean containsKey(String key) {
            return this.map.containsKey(key);
        }

        public void clear() {
            this.map.clear();
            this.map = null;
            this.pre = null;
            this.next = null;
        }
    }
}

