/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.RPCRequest;

public class RPCBlockRequest
extends RPCRequest {
    private final long mBlockId;
    private final long mOffset;
    private final long mLength;

    public RPCBlockRequest(long blockId, long offset, long length) {
        this.mBlockId = blockId;
        this.mOffset = offset;
        this.mLength = length;
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_BLOCK_REQUEST;
    }

    public static RPCBlockRequest decode(ByteBuf in) {
        long blockId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        return new RPCBlockRequest(blockId, offset, length);
    }

    @Override
    public int getEncodedLength() {
        return 24;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mBlockId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
    }

    @Override
    public void validate() {
        Preconditions.checkState((this.mOffset >= 0L ? 1 : 0) != 0, (String)"Offset can not be negative: %s", (Object[])new Object[]{this.mOffset});
        Preconditions.checkState((this.mLength >= 0L || this.mLength == -1L ? 1 : 0) != 0, (String)"Length can not be negative except -1: %s", (Object[])new Object[]{this.mLength});
    }

    public String toString() {
        return "RPCBlockRequest(" + this.mBlockId + ", " + this.mOffset + ", " + this.mLength + ")";
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }
}

