/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.TachyonURI;
import tachyon.client.BlockInStream;
import tachyon.client.BlockOutStream;
import tachyon.client.EmptyBlockInStream;
import tachyon.client.FileInStream;
import tachyon.client.FileOutStream;
import tachyon.client.InStream;
import tachyon.client.OutStream;
import tachyon.client.ReadType;
import tachyon.client.RemoteBlockInStream;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.WriteType;
import tachyon.conf.TachyonConf;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.NetAddress;
import tachyon.underfs.UnderFileSystem;

public class TachyonFile
implements Comparable<TachyonFile> {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    final TachyonFS mTachyonFS;
    final int mFileId;
    private Object mUFSConf = null;
    private final TachyonConf mTachyonConf;

    TachyonFile(TachyonFS tfs, int fid, TachyonConf tachyonConf) {
        this.mTachyonFS = tfs;
        this.mFileId = fid;
        this.mTachyonConf = tachyonConf;
    }

    private ClientFileInfo getCachedFileStatus() throws IOException {
        return this.mTachyonFS.getFileStatus(this.mFileId, true);
    }

    private ClientFileInfo getUnCachedFileStatus() throws IOException {
        return this.mTachyonFS.getFileStatus(this.mFileId, false);
    }

    @Override
    public int compareTo(TachyonFile o) {
        if (this.mFileId == o.mFileId) {
            return 0;
        }
        return this.mFileId < o.mFileId ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TachyonFile) {
            return this.compareTo((TachyonFile)obj) == 0;
        }
        return false;
    }

    public long getBlockId(int blockIndex) throws IOException {
        return this.mTachyonFS.getBlockId(this.mFileId, blockIndex);
    }

    public long getBlockSizeByte() throws IOException {
        return this.getCachedFileStatus().getBlockSizeByte();
    }

    public synchronized ClientBlockInfo getClientBlockInfo(int blockIndex) throws IOException {
        return this.mTachyonFS.getClientBlockInfo(this.getBlockId(blockIndex));
    }

    public long getCreationTimeMs() throws IOException {
        return this.getCachedFileStatus().getCreationTimeMs();
    }

    public int getDiskReplication() {
        return 3;
    }

    public InStream getInStream(ReadType readType) throws IOException {
        if (readType == null) {
            throw new IOException("ReadType can not be null.");
        }
        if (!this.isComplete()) {
            throw new IOException("The file " + this + " is not complete.");
        }
        if (this.isDirectory()) {
            throw new IOException("Cannot open a directory for reading.");
        }
        ClientFileInfo fileStatus = this.getUnCachedFileStatus();
        List<Long> blocks = fileStatus.getBlockIds();
        if (blocks.size() == 0) {
            return new EmptyBlockInStream(this, readType, this.mTachyonConf);
        }
        if (blocks.size() == 1) {
            return BlockInStream.get(this, readType, 0, this.mUFSConf, this.mTachyonConf);
        }
        return new FileInStream(this, readType, this.mUFSConf, this.mTachyonConf);
    }

    public String getLocalFilename(int blockIndex) throws IOException {
        int blockLockId;
        ClientBlockInfo blockInfo = this.getClientBlockInfo(blockIndex);
        long blockId = blockInfo.getBlockId();
        String filename = this.mTachyonFS.lockBlock(blockId, blockLockId = this.mTachyonFS.getBlockLockId());
        if (filename != null) {
            this.mTachyonFS.unlockBlock(blockId, blockLockId);
        }
        return filename;
    }

    public List<String> getLocationHosts() throws IOException {
        List<NetAddress> locations;
        ArrayList<String> ret = new ArrayList<String>();
        if (this.getNumberOfBlocks() > 0 && (locations = this.getClientBlockInfo(0).getLocations()) != null) {
            for (NetAddress location : locations) {
                ret.add(location.mHost);
            }
        }
        return ret;
    }

    public int getNumberOfBlocks() throws IOException {
        return this.getUnCachedFileStatus().getBlockIds().size();
    }

    public OutStream getOutStream(WriteType writeType) throws IOException {
        if (this.isComplete()) {
            throw new IOException("Overriding after completion not supported.");
        }
        if (writeType == null) {
            throw new IOException("WriteType can not be null.");
        }
        return new FileOutStream(this, writeType, this.mUFSConf, this.mTachyonConf);
    }

    public String getPath() throws IOException {
        return this.getUnCachedFileStatus().getPath();
    }

    public Object getUFSConf() {
        return this.mUFSConf;
    }

    String getUfsPath() throws IOException {
        ClientFileInfo info = this.getCachedFileStatus();
        if (!info.getUfsPath().isEmpty()) {
            return info.getUfsPath();
        }
        return this.getUnCachedFileStatus().getUfsPath();
    }

    public int hashCode() {
        return this.mFileId;
    }

    public boolean isComplete() throws IOException {
        return this.getCachedFileStatus().isComplete || this.getUnCachedFileStatus().isComplete;
    }

    public boolean isDirectory() throws IOException {
        return this.getCachedFileStatus().isFolder;
    }

    public boolean isFile() throws IOException {
        return !this.isDirectory();
    }

    public boolean isInMemory() throws IOException {
        return this.getUnCachedFileStatus().getInMemoryPercentage() == 100;
    }

    public long length() throws IOException {
        return this.getUnCachedFileStatus().getLength();
    }

    public boolean needPin() throws IOException {
        return this.getUnCachedFileStatus().isPinned;
    }

    public boolean promoteBlock(int blockIndex) throws IOException {
        ClientBlockInfo blockInfo = this.getClientBlockInfo(blockIndex);
        return this.mTachyonFS.promoteBlock(blockInfo.getBlockId());
    }

    public TachyonByteBuffer readByteBuffer(int blockIndex) throws IOException {
        if (!this.isComplete()) {
            return null;
        }
        TachyonByteBuffer ret = this.readLocalByteBuffer(blockIndex);
        if (ret == null) {
            ret = this.readRemoteByteBuffer(this.getClientBlockInfo(blockIndex));
        }
        return ret;
    }

    TachyonByteBuffer readLocalByteBuffer(int blockIndex) throws IOException {
        return this.readLocalByteBuffer(blockIndex, 0L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TachyonByteBuffer readLocalByteBuffer(int blockIndex, long offset, long len) throws IOException {
        if (offset < 0L) {
            throw new IOException("Offset can not be negative: " + offset);
        }
        if (len < 0L && len != -1L) {
            throw new IOException("Length can not be negative except -1: " + len);
        }
        ClientBlockInfo info = this.getClientBlockInfo(blockIndex);
        long blockId = info.blockId;
        int blockLockId = this.mTachyonFS.getBlockLockId();
        String localFileName = this.mTachyonFS.lockBlock(blockId, blockLockId);
        if (localFileName != null) {
            Closer closer = Closer.create();
            try {
                RandomAccessFile localFile = (RandomAccessFile)closer.register((Closeable)new RandomAccessFile(localFileName, "r"));
                long fileLength = localFile.length();
                String error = null;
                if (offset > fileLength) {
                    error = String.format("Offset(%d) is larger than file length(%d)", offset, fileLength);
                }
                if (error == null && len != -1L && offset + len > fileLength) {
                    error = String.format("Offset(%d) plus length(%d) is larger than file length(%d)", offset, len, fileLength);
                }
                if (error != null) {
                    throw new IOException(error);
                }
                if (len == -1L) {
                    len = fileLength - offset;
                }
                FileChannel localFileChannel = (FileChannel)closer.register((Closeable)localFile.getChannel());
                MappedByteBuffer buf = localFileChannel.map(FileChannel.MapMode.READ_ONLY, offset, len);
                this.mTachyonFS.accessLocalBlock(blockId);
                TachyonByteBuffer tachyonByteBuffer = new TachyonByteBuffer(this.mTachyonFS, buf, blockId, blockLockId);
                return tachyonByteBuffer;
            }
            catch (FileNotFoundException e) {
                LOG.info(localFileName + " is not on local disk.");
            }
            catch (IOException e) {
                LOG.warn("Failed to read local file " + localFileName + " because:", (Throwable)e);
            }
            finally {
                closer.close();
            }
        }
        this.mTachyonFS.unlockBlock(blockId, blockLockId);
        return null;
    }

    TachyonByteBuffer readRemoteByteBuffer(ClientBlockInfo blockInfo) {
        ByteBuffer buf = RemoteBlockInStream.readRemoteByteBuffer(this.mTachyonFS, blockInfo, 0L, blockInfo.length, this.mTachyonConf);
        return buf == null ? null : new TachyonByteBuffer(this.mTachyonFS, buf, blockInfo.blockId, -1);
    }

    public boolean recache() throws IOException {
        int numberOfBlocks = this.getNumberOfBlocks();
        if (numberOfBlocks == 0) {
            return true;
        }
        boolean succeed = true;
        for (int k = 0; k < numberOfBlocks; ++k) {
            succeed &= this.recache(k);
        }
        return succeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recache(int blockIndex) throws IOException {
        String path = this.getUfsPath();
        UnderFileSystem underFsClient = UnderFileSystem.get(path, this.mTachyonConf);
        InputStream inputStream = null;
        OutStream bos = null;
        try {
            int limit;
            inputStream = underFsClient.open(path);
            long length = this.getBlockSizeByte();
            long offset = (long)blockIndex * length;
            inputStream.skip(offset);
            int bufferBytes = (int)this.mTachyonConf.getBytes("tachyon.user.file.buffer.bytes", 0x100000L);
            byte[] buffer = new byte[bufferBytes];
            bos = BlockOutStream.get(this, WriteType.TRY_CACHE, blockIndex, this.mTachyonConf);
            while (length > 0L && (limit = inputStream.read(buffer)) >= 0) {
                if (limit == 0) continue;
                if (length >= (long)limit) {
                    bos.write(buffer, 0, limit);
                    length -= (long)limit;
                    continue;
                }
                bos.write(buffer, 0, (int)length);
                length = 0L;
            }
            bos.close();
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            if (bos != null) {
                bos.cancel();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return true;
    }

    public boolean rename(TachyonURI path) throws IOException {
        return this.mTachyonFS.rename(this.mFileId, path);
    }

    public void setUFSConf(Object conf) {
        this.mUFSConf = conf;
    }

    public String toString() {
        try {
            return this.getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("File does not exist anymore: " + this.mFileId);
        }
    }
}

