/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import com.google.common.io.Closer;
import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.BlockOutStream;
import tachyon.client.RemoteBlockWriter;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.conf.TachyonConf;
import tachyon.util.CommonUtils;

public class RemoteBlockOutStream
extends BlockOutStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final int mBlockIndex;
    private final long mBlockId;
    private final long mBlockCapacityBytes;
    private final Closer mCloser;
    private final RemoteBlockWriter mRemoteWriter;
    private final ByteBuffer mBuffer;
    private final long mBufferBytes;
    private long mWrittenBytes = 0L;
    private long mFlushedBytes = 0L;
    private boolean mClosed = true;

    RemoteBlockOutStream(TachyonFile file, WriteType opType, int blockIndex, TachyonConf tachyonConf) throws IOException {
        this(file, opType, blockIndex, tachyonConf.getBytes("tachyon.user.quota.unit.bytes", 0x800000L), tachyonConf);
    }

    RemoteBlockOutStream(TachyonFile file, WriteType opType, int blockIndex, long initialBytes, TachyonConf tachyonConf) throws IOException {
        super(file, opType, tachyonConf);
        if (!opType.isCache()) {
            throw new IOException("RemoteBlockOutStream only supports WriteType.CACHE. opType: " + (Object)((Object)opType));
        }
        this.mBlockIndex = blockIndex;
        this.mBlockCapacityBytes = this.mFile.getBlockSizeByte();
        this.mBlockId = this.mFile.getBlockId(this.mBlockIndex);
        this.mCloser = Closer.create();
        this.mBufferBytes = this.mTachyonConf.getBytes("tachyon.user.file.buffer.bytes", 0x100000L);
        this.mBuffer = ByteBuffer.allocate(Ints.checkedCast((long)this.mBufferBytes));
        this.mRemoteWriter = (RemoteBlockWriter)this.mCloser.register((Closeable)RemoteBlockWriter.Factory.createRemoteBlockWriter(tachyonConf));
        this.mRemoteWriter.open(this.mTachyonFS.getWorkerDataServerAddress(), this.mBlockId, this.mTachyonFS.getUserId());
        this.mClosed = false;
    }

    private synchronized void writeToRemoteBlock(byte[] bytes, int offset, int length) throws IOException {
        this.mRemoteWriter.write(bytes, offset, length);
        this.mFlushedBytes += (long)length;
        this.mTachyonFS.getClientMetrics().incBytesWrittenRemote(length);
    }

    private void flushBuffer() throws IOException {
        this.writeToRemoteBlock(this.mBuffer.array(), 0, this.mBuffer.position());
        this.mBuffer.clear();
    }

    @Override
    public void cancel() throws IOException {
        if (!this.mClosed) {
            this.mCloser.close();
            this.mClosed = true;
            if (this.mFlushedBytes > 0L) {
                this.mTachyonFS.cancelBlock(this.mBlockId);
            }
            LOG.info(String.format("Canceled output of block. blockId(%d)", this.mBlockId));
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            if (this.mBuffer.position() > 0) {
                this.writeToRemoteBlock(this.mBuffer.array(), 0, this.mBuffer.position());
            }
            this.mCloser.close();
            if (this.mWrittenBytes > 0L) {
                this.mTachyonFS.cacheBlock(this.mBlockId);
                this.mTachyonFS.getClientMetrics().incBlocksWrittenRemote(1L);
            }
            this.mClosed = true;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.mBuffer.position() > 0) {
            this.flushBuffer();
        }
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    @Override
    public long getRemainingSpaceBytes() {
        return this.mBlockCapacityBytes - this.mWrittenBytes;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException(String.format("Buffer length (%d), offset(%d), len(%d)", b.length, off, len));
        }
        if (this.mClosed) {
            throw new IOException("Cannot write because block is already closed. blockId: " + this.mBlockId);
        }
        if (this.mWrittenBytes + (long)len > this.mBlockCapacityBytes) {
            throw new IOException("Out of capacity.");
        }
        if (len == 0) {
            return;
        }
        if (this.mBuffer.position() > 0 && (long)(this.mBuffer.position() + len) > this.mBufferBytes) {
            this.flushBuffer();
        }
        if ((long)len > this.mBufferBytes / 2L) {
            if (this.mBuffer.position() > 0) {
                this.flushBuffer();
            }
            this.writeToRemoteBlock(b, off, len);
        } else {
            this.mBuffer.put(b, off, len);
        }
        this.mWrittenBytes += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mClosed) {
            throw new IOException("Cannot write because block is already closed. blockId: " + this.mBlockId);
        }
        if (this.mWrittenBytes + 1L > this.mBlockCapacityBytes) {
            throw new IOException("Out of capacity.");
        }
        if ((long)this.mBuffer.position() >= this.mBufferBytes) {
            this.flushBuffer();
        }
        CommonUtils.putIntByteBuffer(this.mBuffer, b);
        ++this.mWrittenBytes;
    }
}

