/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.lock;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tio.utils.cache.caffeine.CaffeineCache;

public class LockUtils {
    private static final String LOCK_TYPE_OBJ = "OBJ";
    private static final String LOCK_TYPE_RW = "RW";
    private static final Object defaultLockObjForObj = new Object();
    private static final Object defaultLockObjForRw = new Object();
    private static final CaffeineCache LOCAL_LOCKS = CaffeineCache.register(LockUtils.class.getName() + "OBJ", null, 3600L);
    private static final CaffeineCache LOCAL_READWRITE_LOCKS = CaffeineCache.register(LockUtils.class.getName() + "RW", null, 3600L);

    public static Serializable getLockObj(String key) {
        return LockUtils.getLockObj(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable getLockObj(String key, Object myLock) {
        Serializable lock = LOCAL_LOCKS.get(key);
        if (lock == null) {
            Object ml = myLock;
            if (ml == null) {
                ml = defaultLockObjForObj;
            }
            Object object = ml;
            synchronized (object) {
                lock = LOCAL_LOCKS.get(key);
                if (lock == null) {
                    lock = new Serializable(){
                        private static final long serialVersionUID = 255956860617836425L;
                    };
                    LOCAL_LOCKS.put(key, lock);
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReentrantReadWriteLock getReentrantReadWriteLock(String key, Object myLock) {
        ReentrantReadWriteLock lock = (ReentrantReadWriteLock)LOCAL_READWRITE_LOCKS.get(key);
        if (lock == null) {
            Object ml = myLock;
            if (ml == null) {
                ml = defaultLockObjForRw;
            }
            Object object = ml;
            synchronized (object) {
                lock = (ReentrantReadWriteLock)LOCAL_READWRITE_LOCKS.get(key);
                if (lock == null) {
                    lock = new ReentrantReadWriteLock();
                    LOCAL_READWRITE_LOCKS.put(key, lock);
                }
            }
        }
        return lock;
    }
}

