/*
 * Decompiled with CFR 0.152.
 */
package breeze.util;

import breeze.util.BloomFilter$;
import breeze.util.package$;
import breeze.util.package$AwesomeBitSet$;
import java.util.BitSet;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001\u001d\u00111B\u00117p_64\u0015\u000e\u001c;fe*\u00111\u0001B\u0001\u0005kRLGNC\u0001\u0006\u0003\u0019\u0011'/Z3{K\u000e\u0001QC\u0001\u0005\u0015'\u0011\u0001\u0011bD\u001a\u0011\u0005)iQ\"A\u0006\u000b\u00031\tQa]2bY\u0006L!AD\u0006\u0003\r\u0005s\u0017PU3g!\u0011Q\u0001C\u0005\u0019\n\u0005EY!!\u0003$v]\u000e$\u0018n\u001c82!\t\u0019B\u0003\u0004\u0001\u0005\u0013U\u0001\u0001\u0015!A\u0001\u0006\u00041\"!\u0001+\u0012\u0005]Q\u0002C\u0001\u0006\u0019\u0013\tI2BA\u0004O_RD\u0017N\\4\u0011\u0005)Y\u0012B\u0001\u000f\f\u0005\r\te.\u001f\u0015\u0005)y\t3\u0006\u0005\u0002\u000b?%\u0011\u0001e\u0003\u0002\fgB,7-[1mSj,G-M\u0003$E\r*CE\u0004\u0002\u000bG%\u0011AeC\u0001\u0004\u0013:$\u0018\u0007\u0002\u0013'U1q!a\n\u0016\u000e\u0003!R!!\u000b\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0011'B\u0012-[=rcB\u0001\u0006.\u0013\tq3\"\u0001\u0003M_:<\u0017\u0007\u0002\u0013'U1\u0001\"AC\u0019\n\u0005IZ!a\u0002\"p_2,\u0017M\u001c\t\u0003\u0015QJ!!N\u0006\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011]\u0002!Q1A\u0005\u0002a\n!B\\;n\u0005V\u001c7.\u001a;t+\u0005I\u0004C\u0001\u0006;\u0013\tY4BA\u0002J]RD\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006I!O\u0001\f]Vl')^2lKR\u001c\b\u0005\u0003\u0005@\u0001\t\u0015\r\u0011\"\u00019\u0003AqW/\u001c%bg\"4UO\\2uS>t7\u000f\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003:\u0003EqW/\u001c%bg\"4UO\\2uS>t7\u000f\t\u0005\t\u0007\u0002\u0011)\u0019!C\u0001\t\u0006!!-\u001b;t+\u0005)\u0005C\u0001$K\u001b\u00059%BA\u0002I\u0015\u0005I\u0015\u0001\u00026bm\u0006L!aS$\u0003\r\tKGoU3u\u0011!i\u0005A!A!\u0002\u0013)\u0015!\u00022jiN\u0004\u0003\"B(\u0001\t\u0003\u0001\u0016A\u0002\u001fj]&$h\b\u0006\u0003R'R+\u0006c\u0001*\u0001%5\t!\u0001C\u00038\u001d\u0002\u0007\u0011\bC\u0003@\u001d\u0002\u0007\u0011\bC\u0003D\u001d\u0002\u0007Q\tC\u0003P\u0001\u0011\u0005q\u000bF\u0002R1fCQa\u000e,A\u0002eBQa\u0010,A\u0002eBQa\u0014\u0001\u0005\u0002m#\"!\u0015/\t\u000b]R\u0006\u0019A\u001d\t\u000by\u0003A\u0011A0\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005A\u0002\u0007\"B1^\u0001\u0004\u0011\u0012!A8\t\u000b\r\u0004A\u0011\u00013\u0002\u0011\r|g\u000e^1j]N$\"\u0001M3\t\u000b\u0005\u0014\u0007\u0019\u0001\n\t\u000b\u001d\u0004A\u0011\u00015\u0002\t1|\u0017\rZ\u000b\u0002SB\u0011!B[\u0005\u0003W.\u0011a\u0001R8vE2,\u0007\"B7\u0001\t\u0003r\u0017AB3rk\u0006d7\u000f\u0006\u00021_\")\u0001\u000f\u001ca\u00015\u0005)q\u000e\u001e5fe\")!\u000f\u0001C\u0001g\u0006AA\u0005\u001d7vg\u0012*\u0017\u000f\u0006\u0002uk6\t\u0001\u0001C\u0003bc\u0002\u0007!\u0003C\u0003x\u0001\u0011\u0005\u00010\u0001\u0003%C6\u0004HCA)z\u0011\u0015Qh\u000f1\u0001R\u0003\u0011!\b.\u0019;\t\u000bq\u0004A\u0011B?\u0002%\rDWmY6D_6\u0004\u0018\r^5cS2LG/\u001f\u000b\u0004}\u0006\r\u0001C\u0001\u0006\u0000\u0013\r\t\ta\u0003\u0002\u0005+:LG\u000fC\u0003{w\u0002\u0007\u0011\u000bC\u0004\u0002\b\u0001!\t!!\u0003\u0002\t\u0011\u0012\u0017M\u001d\u000b\u0004#\u0006-\u0001B\u0002>\u0002\u0006\u0001\u0007\u0011\u000bC\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u000f\u0011\u0012\u0017M\u001d\u0013fcR\u0019A/a\u0005\t\ri\fi\u00011\u0001R\u0011\u001d\t9\u0002\u0001C\u0001\u00033\tq\u0001J1na\u0012*\u0017\u000fF\u0002u\u00037AaA_A\u000b\u0001\u0004\t\u0006bBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\u000eI\u0005l\u0007\u000f\n;jY\u0012,G%Z9\u0015\u0007Q\f\u0019\u0003\u0003\u0004{\u0003;\u0001\r!\u0015\u0005\b\u0003O\u0001A\u0011AA\u0015\u0003)!\u0013-\u001c9%i&dG-\u001a\u000b\u0004#\u0006-\u0002B\u0002>\u0002&\u0001\u0007\u0011\u000bC\u0004\u00020\u0001!I!!\r\u0002\u0017\r|W\u000e];uK\"\u000b7\u000f\u001b\u000b\u0006s\u0005M\u0012q\u0007\u0005\b\u0003k\ti\u00031\u0001:\u0003\u0005A\u0007BB1\u0002.\u0001\u0007\u0011\bK\u0004\u0001\u0003w\t\t%a\u0011\u0011\u0007)\ti$C\u0002\u0002@-\u0011\u0001cU3sS\u0006dg+\u001a:tS>tW+\u0013#\u0002\u000bY\fG.^3\u001f\u0003\u00059q!a\u0012\u0003\u0011\u0003\tI%A\u0006CY>|WNR5mi\u0016\u0014\bc\u0001*\u0002L\u00191\u0011A\u0001E\u0001\u0003\u001b\u001aB!a\u0013\ng!9q*a\u0013\u0005\u0002\u0005ECCAA%\u0011!\t)&a\u0013\u0005\u0002\u0005]\u0013aC8qi&l\u0017\r\\*ju\u0016$b!!\u0017\u0002`\u0005\r\u0004#\u0002\u0006\u0002\\eJ\u0014bAA/\u0017\t1A+\u001e9mKJBq!!\u0019\u0002T\u0001\u0007\u0011.\u0001\tfqB,7\r^3e\u001dVl\u0017\n^3ng\"9\u0011QMA*\u0001\u0004I\u0017!\u00054bYN,\u0007k\\:ji&4XMU1uK\"A\u0011\u0011NA&\t\u0003\tY'\u0001\bpaRLW.\u00197msNK'0\u001a3\u0016\t\u00055\u00141\u000f\u000b\u0007\u0003_\n)(a\u001e\u0011\tI\u0003\u0011\u0011\u000f\t\u0004'\u0005MDAB\u000b\u0002h\t\u0007a\u0003C\u0004\u0002b\u0005\u001d\u0004\u0019A5\t\u000f\u0005\u0015\u0014q\ra\u0001S\"Q\u00111PA&\u0003\u0003%I!! \u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u007f\u0002B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0004\u0003\u000bC\u0015\u0001\u00027b]\u001eLA!!#\u0002\u0004\n1qJ\u00196fGR\u0004")
public class BloomFilter<T>
implements Function1<T, Object>,
Serializable {
    public static final long serialVersionUID = 1L;
    private final int numBuckets;
    private final int numHashFunctions;
    private final BitSet bits;

    public static <T> BloomFilter<T> optimallySized(double d, double d2) {
        return BloomFilter$.MODULE$.optimallySized(d, d2);
    }

    public static Tuple2<Object, Object> optimalSize(double d, double d2) {
        return BloomFilter$.MODULE$.optimalSize(d, d2);
    }

    public boolean apply$mcZD$sp(double v1) {
        return Function1.class.apply$mcZD$sp((Function1)this, (double)v1);
    }

    public double apply$mcDD$sp(double v1) {
        return Function1.class.apply$mcDD$sp((Function1)this, (double)v1);
    }

    public float apply$mcFD$sp(double v1) {
        return Function1.class.apply$mcFD$sp((Function1)this, (double)v1);
    }

    public int apply$mcID$sp(double v1) {
        return Function1.class.apply$mcID$sp((Function1)this, (double)v1);
    }

    public long apply$mcJD$sp(double v1) {
        return Function1.class.apply$mcJD$sp((Function1)this, (double)v1);
    }

    public void apply$mcVD$sp(double v1) {
        Function1.class.apply$mcVD$sp((Function1)this, (double)v1);
    }

    public boolean apply$mcZF$sp(float v1) {
        return Function1.class.apply$mcZF$sp((Function1)this, (float)v1);
    }

    public double apply$mcDF$sp(float v1) {
        return Function1.class.apply$mcDF$sp((Function1)this, (float)v1);
    }

    public float apply$mcFF$sp(float v1) {
        return Function1.class.apply$mcFF$sp((Function1)this, (float)v1);
    }

    public int apply$mcIF$sp(float v1) {
        return Function1.class.apply$mcIF$sp((Function1)this, (float)v1);
    }

    public long apply$mcJF$sp(float v1) {
        return Function1.class.apply$mcJF$sp((Function1)this, (float)v1);
    }

    public void apply$mcVF$sp(float v1) {
        Function1.class.apply$mcVF$sp((Function1)this, (float)v1);
    }

    public boolean apply$mcZI$sp(int v1) {
        return Function1.class.apply$mcZI$sp((Function1)this, (int)v1);
    }

    public double apply$mcDI$sp(int v1) {
        return Function1.class.apply$mcDI$sp((Function1)this, (int)v1);
    }

    public float apply$mcFI$sp(int v1) {
        return Function1.class.apply$mcFI$sp((Function1)this, (int)v1);
    }

    public int apply$mcII$sp(int v1) {
        return Function1.class.apply$mcII$sp((Function1)this, (int)v1);
    }

    public long apply$mcJI$sp(int v1) {
        return Function1.class.apply$mcJI$sp((Function1)this, (int)v1);
    }

    public void apply$mcVI$sp(int v1) {
        Function1.class.apply$mcVI$sp((Function1)this, (int)v1);
    }

    public boolean apply$mcZJ$sp(long v1) {
        return Function1.class.apply$mcZJ$sp((Function1)this, (long)v1);
    }

    public double apply$mcDJ$sp(long v1) {
        return Function1.class.apply$mcDJ$sp((Function1)this, (long)v1);
    }

    public float apply$mcFJ$sp(long v1) {
        return Function1.class.apply$mcFJ$sp((Function1)this, (long)v1);
    }

    public int apply$mcIJ$sp(long v1) {
        return Function1.class.apply$mcIJ$sp((Function1)this, (long)v1);
    }

    public long apply$mcJJ$sp(long v1) {
        return Function1.class.apply$mcJJ$sp((Function1)this, (long)v1);
    }

    public void apply$mcVJ$sp(long v1) {
        Function1.class.apply$mcVJ$sp((Function1)this, (long)v1);
    }

    public <A> Function1<A, Object> compose(Function1<A, T> g) {
        return Function1.class.compose((Function1)this, g);
    }

    public <A> Function1<T, A> andThen(Function1<Object, A> g) {
        return Function1.class.andThen((Function1)this, g);
    }

    public String toString() {
        return Function1.class.toString((Function1)this);
    }

    public int numBuckets() {
        return this.numBuckets;
    }

    public int numHashFunctions() {
        return this.numHashFunctions;
    }

    public BitSet bits() {
        return this.bits;
    }

    public boolean apply(T o) {
        int hi = ScalaRunTime$.MODULE$.hash(o);
        for (int h = 0; h < this.numHashFunctions(); ++h) {
            int hash = this.breeze$util$BloomFilter$$computeHash(h, hi);
            if (this.bits().get(hash % this.numBuckets())) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean contains(T o) {
        return this.apply(o);
    }

    public double load() {
        return (double)this.bits().cardinality() / (double)this.numBuckets();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof BloomFilter)) return false;
        BloomFilter bloomFilter = (BloomFilter)object;
        if (this.numBuckets() != bloomFilter.numBuckets()) return false;
        if (this.numHashFunctions() != bloomFilter.numHashFunctions()) return false;
        BitSet bitSet = this.bits();
        BitSet bitSet2 = bloomFilter.bits();
        if (bitSet != null) {
            if (!((Object)bitSet).equals(bitSet2)) return false;
            return true;
        }
        if (bitSet2 == null) return true;
        return false;
    }

    public BloomFilter<T> $plus$eq(T o) {
        int hi = o.hashCode();
        for (int h = 0; h < this.numHashFunctions(); ++h) {
            int hash = this.breeze$util$BloomFilter$$computeHash(h, hi);
            this.bits().set(hash % this.numBuckets());
        }
        return this;
    }

    public BloomFilter<T> $amp(BloomFilter<T> that) {
        this.checkCompatibility(that);
        return new BloomFilter<T>(this.numBuckets(), this.numHashFunctions(), package$AwesomeBitSet$.MODULE$.$amp$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits()));
    }

    public void checkCompatibility(BloomFilter<T> that) {
        Predef$.MODULE$.require(that.numBuckets() == this.numBuckets(), (Function0)new Serializable(this){

            public final String apply() {
                return "Must have the same number of buckets to intersect";
            }
        });
        Predef$.MODULE$.require(that.numHashFunctions() == this.numHashFunctions(), (Function0)new Serializable(this){

            public final String apply() {
                return "Must have the same number of hash functions to intersect";
            }
        });
    }

    public BloomFilter<T> $bar(BloomFilter<T> that) {
        this.checkCompatibility(that);
        return new BloomFilter<T>(this.numBuckets(), this.numHashFunctions(), package$AwesomeBitSet$.MODULE$.$bar$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits()));
    }

    public BloomFilter<T> $bar$eq(BloomFilter<T> that) {
        this.checkCompatibility(that);
        package$AwesomeBitSet$.MODULE$.$bar$eq$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits());
        return this;
    }

    public BloomFilter<T> $amp$eq(BloomFilter<T> that) {
        this.checkCompatibility(that);
        package$AwesomeBitSet$.MODULE$.$amp$eq$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits());
        return this;
    }

    public BloomFilter<T> $amp$tilde$eq(BloomFilter<T> that) {
        this.checkCompatibility(that);
        package$AwesomeBitSet$.MODULE$.$amp$tilde$eq$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits());
        return this;
    }

    public BloomFilter<T> $amp$tilde(BloomFilter<T> that) {
        this.checkCompatibility(that);
        return new BloomFilter<T>(this.numBuckets(), this.numHashFunctions(), package$AwesomeBitSet$.MODULE$.$amp$tilde$extension(package$.MODULE$.AwesomeBitSet(this.bits()), that.bits()));
    }

    public int breeze$util$BloomFilter$$computeHash(int h, int o) {
        return scala.math.package$.MODULE$.abs(MurmurHash3$.MODULE$.mixLast(o, h));
    }

    public boolean apply$mcI$sp(int o) {
        return this.apply((T)BoxesRunTime.boxToInteger((int)o));
    }

    public boolean apply$mcJ$sp(long o) {
        return this.apply((T)BoxesRunTime.boxToLong((long)o));
    }

    public boolean contains$mcI$sp(int o) {
        return this.contains(BoxesRunTime.boxToInteger((int)o));
    }

    public boolean contains$mcJ$sp(long o) {
        return this.contains(BoxesRunTime.boxToLong((long)o));
    }

    public BloomFilter<T> $plus$eq$mcI$sp(int o) {
        return this.$plus$eq(BoxesRunTime.boxToInteger((int)o));
    }

    public BloomFilter<T> $plus$eq$mcJ$sp(long o) {
        return this.$plus$eq(BoxesRunTime.boxToLong((long)o));
    }

    public BloomFilter<Object> $amp$mcI$sp(BloomFilter<Object> that) {
        return this.$amp(that);
    }

    public BloomFilter<Object> $amp$mcJ$sp(BloomFilter<Object> that) {
        return this.$amp(that);
    }

    public void checkCompatibility$mcI$sp(BloomFilter<Object> that) {
        this.checkCompatibility(that);
    }

    public void checkCompatibility$mcJ$sp(BloomFilter<Object> that) {
        this.checkCompatibility(that);
    }

    public BloomFilter<Object> $bar$mcI$sp(BloomFilter<Object> that) {
        return this.$bar(that);
    }

    public BloomFilter<Object> $bar$mcJ$sp(BloomFilter<Object> that) {
        return this.$bar(that);
    }

    public BloomFilter<T> $bar$eq$mcI$sp(BloomFilter<Object> that) {
        return this.$bar$eq(that);
    }

    public BloomFilter<T> $bar$eq$mcJ$sp(BloomFilter<Object> that) {
        return this.$bar$eq(that);
    }

    public BloomFilter<T> $amp$eq$mcI$sp(BloomFilter<Object> that) {
        return this.$amp$eq(that);
    }

    public BloomFilter<T> $amp$eq$mcJ$sp(BloomFilter<Object> that) {
        return this.$amp$eq(that);
    }

    public BloomFilter<T> $amp$tilde$eq$mcI$sp(BloomFilter<Object> that) {
        return this.$amp$tilde$eq(that);
    }

    public BloomFilter<T> $amp$tilde$eq$mcJ$sp(BloomFilter<Object> that) {
        return this.$amp$tilde$eq(that);
    }

    public BloomFilter<Object> $amp$tilde$mcI$sp(BloomFilter<Object> that) {
        return this.$amp$tilde(that);
    }

    public BloomFilter<Object> $amp$tilde$mcJ$sp(BloomFilter<Object> that) {
        return this.$amp$tilde(that);
    }

    public BloomFilter(int numBuckets, int numHashFunctions, BitSet bits) {
        this.numBuckets = numBuckets;
        this.numHashFunctions = numHashFunctions;
        this.bits = bits;
        Function1.class.$init$((Function1)this);
    }

    public BloomFilter(int numBuckets, int numHashFunctions) {
        this(numBuckets, numHashFunctions, new BitSet(numBuckets));
    }

    public BloomFilter(int numBuckets) {
        this(numBuckets, 3);
    }
}

