/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.config.ConfigurationReader;
import reactor.core.config.DispatcherConfiguration;
import reactor.core.config.DispatcherType;
import reactor.core.config.ReactorConfiguration;

public class PropertiesConfigurationReader
implements ConfigurationReader {
    private static final Pattern REACTOR_NAME_PATTERN = Pattern.compile("reactor\\.dispatchers\\.(.+?)\\.type");
    private static final String FORMAT_DISPATCHER_BACKLOG = "reactor.dispatchers.%s.backlog";
    private static final String FORMAT_DISPATCHER_SIZE = "reactor.dispatchers.%s.size";
    private static final String FORMAT_DISPATCHER_TYPE = "reactor.dispatchers.%s.type";
    private static final String FORMAT_RESOURCE_NAME = "/META-INF/reactor/%s.properties";
    private static final String PROPERTY_PREFIX_REACTOR = "reactor.";
    private static final String PROPERTY_NAME_PROFILES_ACTIVE = "reactor.profiles.active";
    private static final String PROPERTY_NAME_PROFILES_DEFAULT = "reactor.profiles.default";
    private static final String PROPERTY_NAME_DEFAULT_DISPATCHER = "reactor.dispatchers.default";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String defaultProfileNameDefault;

    public PropertiesConfigurationReader() {
        this("reactor-environment");
    }

    public PropertiesConfigurationReader(String defaultProfileNameDefault) {
        this.defaultProfileNameDefault = defaultProfileNameDefault;
    }

    @Override
    public ReactorConfiguration read() {
        Properties configuration = new Properties();
        this.applyProfile(this.loadDefaultProfile(), configuration);
        for (Properties activeProfile : this.loadActiveProfiles()) {
            this.applyProfile(activeProfile, configuration);
        }
        this.applySystemProperties(configuration);
        String defaultDispatcherName = configuration.getProperty(PROPERTY_NAME_DEFAULT_DISPATCHER, "shared");
        List<DispatcherConfiguration> dispatcherConfiguration = this.createDispatcherConfiguration(configuration);
        return new ReactorConfiguration(dispatcherConfiguration, defaultDispatcherName, configuration);
    }

    private Properties loadDefaultProfile() {
        String defaultProfileName = System.getProperty(PROPERTY_NAME_PROFILES_DEFAULT, this.defaultProfileNameDefault);
        Properties defaultProfile = this.loadProfile(defaultProfileName);
        return defaultProfile;
    }

    private List<Properties> loadActiveProfiles() {
        ArrayList<Properties> activeProfiles = new ArrayList<Properties>();
        if (null != System.getProperty(PROPERTY_NAME_PROFILES_ACTIVE)) {
            String[] profileNames;
            for (String profileName : profileNames = System.getProperty(PROPERTY_NAME_PROFILES_ACTIVE).split(",")) {
                activeProfiles.add(this.loadProfile(profileName.trim()));
            }
        }
        return activeProfiles;
    }

    private void applyProfile(Properties profile, Properties configuration) {
        configuration.putAll((Map<?, ?>)profile);
    }

    private void applySystemProperties(Properties configuration) {
        for (String prop : System.getProperties().stringPropertyNames()) {
            if (!prop.startsWith(PROPERTY_PREFIX_REACTOR)) continue;
            configuration.put(prop, System.getProperty(prop));
        }
    }

    private List<DispatcherConfiguration> createDispatcherConfiguration(Properties configuration) {
        List<String> dispatcherNames = this.getDispatcherNames(configuration);
        ArrayList<DispatcherConfiguration> dispatcherConfigurations = new ArrayList<DispatcherConfiguration>(dispatcherNames.size());
        for (String dispatcherName : dispatcherNames) {
            DispatcherType type = this.getType(dispatcherName, configuration);
            if (type == null) continue;
            dispatcherConfigurations.add(new DispatcherConfiguration(dispatcherName, type, this.getBacklog(dispatcherName, configuration), this.getSize(dispatcherName, configuration)));
        }
        return dispatcherConfigurations;
    }

    private List<String> getDispatcherNames(Properties configuration) {
        ArrayList<String> dispatcherNames = new ArrayList<String>();
        for (Object propertyName : configuration.keySet()) {
            Matcher matcher = REACTOR_NAME_PATTERN.matcher((String)propertyName);
            if (!matcher.matches()) continue;
            dispatcherNames.add(matcher.group(1));
        }
        return dispatcherNames;
    }

    private DispatcherType getType(String dispatcherName, Properties configuration) {
        String type = configuration.getProperty(String.format(FORMAT_DISPATCHER_TYPE, dispatcherName));
        if ("dispatcherGroup".equals(type)) {
            return DispatcherType.DISPATCHER_GROUP;
        }
        if ("mpsc".equals(type)) {
            return DispatcherType.MPSC;
        }
        if ("ringBuffer".equals(type)) {
            return DispatcherType.RING_BUFFER;
        }
        if ("synchronous".equals(type)) {
            return DispatcherType.SYNCHRONOUS;
        }
        if ("threadPoolExecutor".equals(type)) {
            return DispatcherType.THREAD_POOL_EXECUTOR;
        }
        if ("workQueue".equals(type)) {
            return DispatcherType.WORK_QUEUE;
        }
        this.logger.warn("The type '{}' of Dispatcher '{}' is not recognized", (Object)type, (Object)dispatcherName);
        return null;
    }

    private Integer getBacklog(String dispatcherName, Properties configuration) {
        return this.getInteger(String.format(FORMAT_DISPATCHER_BACKLOG, dispatcherName), configuration);
    }

    private Integer getSize(String dispatcherName, Properties configuration) {
        return this.getInteger(String.format(FORMAT_DISPATCHER_SIZE, dispatcherName), configuration);
    }

    private Integer getInteger(String propertyName, Properties configuration) {
        String property = configuration.getProperty(propertyName);
        if (property != null) {
            return Integer.parseInt(property);
        }
        return null;
    }

    protected Properties loadProfile(String name) {
        Properties properties = new Properties();
        try (InputStream inputStream = this.getClass().getResourceAsStream(String.format(FORMAT_RESOURCE_NAME, name));){
            if (null != inputStream) {
                properties.load(inputStream);
            } else {
                this.logger.debug("No properties file found in the classpath at '{}' for profile '{}'", (Object)String.format(FORMAT_RESOURCE_NAME, name), (Object)name);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to load properties from '{}' for profile '{}'", String.format(FORMAT_RESOURCE_NAME, name), name, e);
        }
        return properties;
    }
}

