/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.object;

public class DataTypes {
    public static final byte CORE_END_OBJECT = -1;
    public static final byte CORE_SWITCH = -17;
    public static final byte CORE_SKIP = 0;
    public static final byte CORE_NULL = 1;
    public static final byte CORE_BOOLEAN = 2;
    public static final byte CORE_NUMBER = 3;
    public static final byte CORE_STRING = 4;
    public static final byte CORE_DATE = 5;
    public static final byte CORE_ARRAY = 6;
    public static final byte CORE_MAP = 7;
    public static final byte CORE_XML = 8;
    public static final byte CORE_OBJECT = 9;
    public static final byte CORE_BYTEARRAY = 16;
    public static final byte OPT_REFERENCE = 17;
    public static final byte CUSTOM_MOCK_MASK = 32;
    public static final byte CUSTOM_AMF_MASK = 48;
    public static final byte CUSTOM_RTMP_MASK = 64;
    public static final byte CUSTOM_JSON_MASK = 80;
    public static final byte CUSTOM_XML_MASK = 96;
    public static final byte CORE_VECTOR_INT = 61;
    public static final byte CORE_VECTOR_UINT = 62;
    public static final byte CORE_VECTOR_NUMBER = 63;
    public static final byte CORE_VECTOR_OBJECT = 64;

    public static String toStringValue(byte dataType) {
        switch (dataType) {
            case 0: {
                return "skip";
            }
            case 1: {
                return "null";
            }
            case 2: {
                return "Boolean";
            }
            case 3: {
                return "Number";
            }
            case 4: {
                return "String";
            }
            case 5: {
                return "Date";
            }
            case 6: {
                return "Array";
            }
            case 7: {
                return "List";
            }
            case 8: {
                return "XML";
            }
            case 9: {
                return "Object";
            }
            case 16: {
                return "ByteArray";
            }
            case 61: {
                return "Vector<int>";
            }
            case 62: {
                return "Vector<uint>";
            }
            case 63: {
                return "Vector<Number>";
            }
            case 64: {
                return "Vector<Object>";
            }
            case 17: {
                return "Reference";
            }
        }
        if (dataType >= 32 && dataType < 48) {
            return "MOCK[" + (dataType - 32) + ']';
        }
        if (dataType >= 48 && dataType < 64) {
            return "AMF[" + (dataType - 48) + ']';
        }
        if (dataType >= 64 && dataType < 80) {
            return "RTMP[" + (dataType - 64) + ']';
        }
        if (dataType >= 80 && dataType < 96) {
            return "JSON[" + (dataType - 80) + ']';
        }
        return "XML[" + (dataType - 96) + ']';
    }

    public static boolean isBasicType(byte type) {
        return type <= 5;
    }

    public static boolean isComplexType(byte type) {
        return type >= 6 || type <= 9;
    }

    public static boolean isCustomType(byte type) {
        return type >= 48;
    }
}

