/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractSequentialList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AudioCodec;
import org.red5.codec.VideoCodec;
import org.red5.io.IStreamableFile;
import org.red5.io.ITag;
import org.red5.io.ITagWriter;
import org.red5.io.amf.Input;
import org.red5.io.amf.Output;
import org.red5.io.flv.FLVHeader;
import org.red5.io.flv.IFLV;
import org.red5.io.flv.impl.FLV;
import org.red5.io.object.Deserializer;
import org.red5.io.utils.IOUtils;
import org.red5.media.processor.IPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLVWriter
implements ITagWriter {
    private static Logger log = LoggerFactory.getLogger(FLVWriter.class);
    private static final int HEADER_LENGTH = 9;
    private static final int TAG_HEADER_LENGTH = 11;
    private static final byte[] DEFAULT_STREAM_ID = new byte[]{0, 0, 0};
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private static IFLV flv;
    private volatile long bytesWritten;
    private int offset;
    private int timeOffset;
    private volatile int audioCodecId = -1;
    private volatile int videoCodecId = -1;
    private AtomicBoolean audioConfigWritten = new AtomicBoolean(false);
    private AtomicBoolean videoConfigWritten = new AtomicBoolean(false);
    private volatile int soundRate;
    private volatile int soundSize;
    private volatile boolean soundType;
    private boolean append;
    private int duration;
    private int videoDataSize = 0;
    private int audioDataSize = 0;
    private SeekableByteChannel fileChannel;
    private SeekableByteChannel dataChannel;
    private String filePath;
    private final Semaphore lock = new Semaphore(1, true);
    private volatile int lastTagSize;
    private LinkedList<IPostProcessor> postProcessors;
    private AtomicBoolean finalized = new AtomicBoolean(false);
    private String recordedDate = ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT);
    private Map<String, ?> meta;
    private long appendOffset = 13L;

    public FLVWriter(String filePath) {
        this.filePath = filePath;
        log.debug("Writing to: {}", (Object)filePath);
        try {
            this.createDataFile();
        }
        catch (Exception e) {
            log.error("Failed to create FLV writer", (Throwable)e);
        }
    }

    public FLVWriter(File file, boolean append) {
        this(file.toPath(), append);
    }

    public FLVWriter(Path path, boolean append) {
        this.filePath = path.toFile().getAbsolutePath();
        this.append = append;
        log.debug("Writing to: {} {}", (Object)this.filePath, (Object)flv);
        try {
            if (append) {
                this.meta = this.getMetaData(path, 5);
                if (this.meta != null) {
                    for (Map.Entry<String, ?> entry : this.meta.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if ("duration".equals(key)) {
                            if (value instanceof Double) {
                                Double d = (Double)value * 1000.0;
                                this.duration = d.intValue();
                                continue;
                            }
                            this.duration = Integer.valueOf((String)value) * 1000;
                            continue;
                        }
                        if (!"recordeddate".equals(key)) continue;
                        this.recordedDate = String.valueOf(value);
                    }
                    this.timeOffset = this.duration;
                    log.debug("Duration: {}", (Object)this.duration);
                }
                Files.move(path, path.resolveSibling(path.toFile().getName().replace(".flv", ".old")), new CopyOption[0]);
                log.debug("Previous flv renamed");
            }
            this.createDataFile();
        }
        catch (Exception e) {
            log.error("Failed to create FLV writer", (Throwable)e);
        }
    }

    private Map<String, ?> getMetaData(Path path, int maxTags) throws IOException {
        Map meta = null;
        SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.READ);
        long size = channel.size();
        log.debug("Channel open: {} size: {} position: {}", new Object[]{channel.isOpen(), size, channel.position()});
        if (size > 0L) {
            channel.position(this.appendOffset);
            ByteBuffer dst = ByteBuffer.allocate(11);
            do {
                int read;
                if ((read = channel.read(dst)) <= 0) continue;
                dst.flip();
                byte tagType = (byte)(dst.get() & 0x1F);
                int bodySize = IOUtils.readUnsignedMediumInt(dst);
                int timestamp = IOUtils.readExtendedMediumInt(dst);
                int streamId = IOUtils.readUnsignedMediumInt(dst);
                log.debug("Data type: {} timestamp: {} stream id: {} body size: {}", new Object[]{tagType, timestamp, streamId, bodySize});
                if (tagType == 18) {
                    ByteBuffer buf = ByteBuffer.allocate(bodySize);
                    read = channel.read(buf);
                    if (read > 0) {
                        buf.flip();
                        IoBuffer ioBuf = IoBuffer.wrap((ByteBuffer)buf);
                        Input input = new Input(ioBuf);
                        String metaType = (String)Deserializer.deserialize(input, String.class);
                        log.debug("Metadata type: {}", (Object)metaType);
                        meta = (Map)Deserializer.deserialize(input, Map.class);
                        input = null;
                        ioBuf.clear();
                        ioBuf.free();
                        if (meta.containsKey("duration")) {
                            this.appendOffset = channel.position() + 4L;
                            break;
                        }
                    }
                    buf.compact();
                }
                channel.position(channel.position() + 4L);
                dst.compact();
            } while (--maxTags > 0);
            channel.close();
        }
        return meta;
    }

    @Override
    public void writeHeader() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(13);
        FLVHeader flvHeader = new FLVHeader();
        flvHeader.setFlagAudio(this.audioCodecId != -1);
        flvHeader.setFlagVideo(this.videoCodecId != -1);
        flvHeader.write(buf);
        this.createOutputFile();
        this.bytesWritten = this.fileChannel.write(buf);
        assert (13L - this.bytesWritten == 0L);
        log.debug("Header size: {} bytes written: {}", (Object)13, (Object)this.bytesWritten);
        buf.clear();
        buf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean writeTag(ITag tag) throws IOException {
        boolean onWrittenSetVideoFlag = false;
        boolean onWrittenSetAudioFlag = false;
        try {
            block43: {
                byte[] bodyBuf;
                int timestamp;
                ByteBuffer tagBuffer;
                int totalTagSize;
                byte dataType;
                int bodySize;
                long prevBytesWritten;
                block42: {
                    int id2;
                    block44: {
                        block45: {
                            this.lock.acquire();
                            log.trace("writeTag: {}", (Object)tag);
                            prevBytesWritten = this.bytesWritten;
                            log.trace("Previous bytes written: {}", (Object)prevBytesWritten);
                            bodySize = tag.getBodySize();
                            log.trace("Tag body size: {}", (Object)bodySize);
                            int previousTagSize = tag.getPreviousTagSize();
                            if (previousTagSize != this.lastTagSize) {
                                log.trace("Incoming previous tag size: {} does not match current value for last tag size: {}", (Object)previousTagSize, (Object)this.lastTagSize);
                            }
                            if (this.dataChannel == null) break block43;
                            if (log.isTraceEnabled()) {
                                log.trace("Current file position: {}", (Object)this.dataChannel.position());
                            }
                            dataType = tag.getDataType();
                            IoBuffer tagBody = tag.getBody();
                            totalTagSize = 11 + bodySize + 4;
                            tagBuffer = ByteBuffer.allocate(totalTagSize);
                            timestamp = tag.getTimestamp() + this.timeOffset;
                            bodyBuf = null;
                            if (bodySize <= 0) break block42;
                            bodyBuf = new byte[bodySize];
                            tagBody.get(bodyBuf);
                            if (dataType != 8) break block44;
                            this.audioDataSize += bodySize;
                            if (this.audioCodecId != -1) break block45;
                            id2 = bodyBuf[0] & 0xFF;
                            this.audioCodecId = (id2 & 0xF0) >> 4;
                            log.debug("Audio codec id: {}", (Object)this.audioCodecId);
                            if (this.audioCodecId == AudioCodec.AAC.getId()) {
                                log.trace("AAC audio type");
                                this.soundRate = 44100;
                                this.soundSize = 16;
                                this.soundType = true;
                                if (bodyBuf[1] != 0) {
                                    log.debug("Rejecting AAC data since config has not yet been written");
                                    boolean bl = false;
                                    return bl;
                                }
                                onWrittenSetAudioFlag = true;
                                break block42;
                            } else if (this.audioCodecId == AudioCodec.SPEEX.getId()) {
                                log.trace("Speex audio type");
                                this.soundRate = 5500;
                                this.soundSize = 16;
                                this.soundType = false;
                                break block42;
                            } else {
                                switch ((id2 & 0xC) >> 2) {
                                    case 0: {
                                        this.soundRate = 5500;
                                        break;
                                    }
                                    case 1: {
                                        this.soundRate = 11000;
                                        break;
                                    }
                                    case 2: {
                                        this.soundRate = 22000;
                                        break;
                                    }
                                    case 3: {
                                        this.soundRate = 44100;
                                        break;
                                    }
                                }
                                log.debug("Sound rate: {}", (Object)this.soundRate);
                                switch ((id2 & 2) >> 1) {
                                    case 0: {
                                        this.soundSize = 8;
                                        break;
                                    }
                                    case 1: {
                                        this.soundSize = 16;
                                        break;
                                    }
                                }
                                log.debug("Sound size: {}", (Object)this.soundSize);
                                this.soundType = (id2 & 1) > 0;
                                log.debug("Sound type: {}", (Object)this.soundType);
                            }
                            break block42;
                        }
                        if (!this.audioConfigWritten.get() && this.audioCodecId == AudioCodec.AAC.getId()) {
                            if (bodyBuf[1] != 0) {
                                boolean id2 = false;
                                return id2;
                            }
                            onWrittenSetAudioFlag = true;
                        }
                        break block42;
                    }
                    if (dataType == 9) {
                        this.videoDataSize += bodySize;
                        if (this.videoCodecId == -1) {
                            id2 = bodyBuf[0] & 0xFF;
                            this.videoCodecId = id2 & 0xF;
                            log.debug("Video codec id: {}", (Object)this.videoCodecId);
                            if (this.videoCodecId == VideoCodec.AVC.getId()) {
                                if (bodyBuf[1] != 0) {
                                    log.debug("Rejecting AVC data since config has not yet been written");
                                    boolean bl = false;
                                    return bl;
                                }
                                onWrittenSetVideoFlag = true;
                            }
                        } else if (!this.videoConfigWritten.get() && this.videoCodecId == VideoCodec.AVC.getId()) {
                            if (bodyBuf[1] != 0) {
                                log.debug("Rejecting AVC data since config has not yet been written");
                                boolean bl = false;
                                return bl;
                            }
                            onWrittenSetVideoFlag = true;
                        }
                    }
                }
                IOUtils.writeUnsignedByte(tagBuffer, dataType);
                IOUtils.writeMediumInt(tagBuffer, bodySize);
                IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
                tagBuffer.put(DEFAULT_STREAM_ID);
                if (bodyBuf != null) {
                    tagBuffer.put(bodyBuf);
                }
                this.lastTagSize = 11 + bodySize;
                tagBuffer.putInt(this.lastTagSize);
                tagBuffer.flip();
                this.dataChannel.write(tagBuffer);
                this.bytesWritten = this.dataChannel.position();
                if (log.isTraceEnabled()) {
                    log.trace("Tag written, check value: {} (should be 0)", (Object)(this.bytesWritten - prevBytesWritten - (long)totalTagSize));
                }
                tagBuffer.clear();
                log.debug("Current duration: {} timestamp: {}", (Object)this.duration, (Object)timestamp);
                this.duration = Math.max(this.duration, timestamp);
                if (this.bytesWritten - prevBytesWritten != (long)totalTagSize) {
                    log.debug("Not all of the bytes appear to have been written, prev-current: {}", (Object)(this.bytesWritten - prevBytesWritten));
                }
                boolean bl = true;
                return bl;
            }
            throw new IOException("FLV write channel has been closed", new ClosedChannelException());
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
            return false;
        }
        finally {
            this.updateInfoFile();
            if (onWrittenSetAudioFlag && this.audioConfigWritten.compareAndSet(false, true)) {
                log.trace("Audio configuration written");
            } else if (onWrittenSetVideoFlag && this.videoConfigWritten.compareAndSet(false, true)) {
                log.trace("Video configuration written");
            }
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeTag(byte dataType, IoBuffer data) throws IOException {
        if (this.timeOffset == 0) {
            this.timeOffset = (int)System.currentTimeMillis();
        }
        try {
            this.lock.acquire();
            if (log.isTraceEnabled()) {
                log.trace("writeTag - type: {} data: {}", (Object)dataType, (Object)data);
            }
            long prevBytesWritten = this.bytesWritten;
            log.trace("Previous bytes written: {}", (Object)prevBytesWritten);
            int bodySize = data.limit();
            log.debug("Tag body size: {}", (Object)bodySize);
            if (this.dataChannel != null) {
                log.debug("Current file position: {}", (Object)this.dataChannel.position());
                int totalTagSize = 11 + bodySize + 4;
                ByteBuffer tagBuffer = ByteBuffer.allocate(totalTagSize);
                IOUtils.writeUnsignedByte(tagBuffer, dataType);
                IOUtils.writeMediumInt(tagBuffer, bodySize);
                int timestamp = (int)(System.currentTimeMillis() - (long)this.timeOffset);
                IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
                tagBuffer.put(DEFAULT_STREAM_ID);
                log.trace("Tag buffer (after tag header) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                if (data.hasArray()) {
                    tagBuffer.put(data.array());
                    log.trace("Tag buffer (after body) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                }
                this.lastTagSize = 11 + bodySize;
                tagBuffer.putInt(this.lastTagSize);
                log.trace("Tag buffer (after prev tag size) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
                tagBuffer.flip();
                if (log.isDebugEnabled()) {
                    // empty if block
                }
                this.dataChannel.write(tagBuffer);
                this.bytesWritten = this.dataChannel.position();
                if (log.isTraceEnabled()) {
                    log.trace("Tag written, check value: {} (should be 0)", (Object)(this.bytesWritten - prevBytesWritten - (long)totalTagSize));
                }
                tagBuffer.clear();
                this.duration = Math.max(this.duration, timestamp);
                log.debug("Writer duration: {}", (Object)this.duration);
                if (this.bytesWritten - prevBytesWritten != (long)totalTagSize) {
                    log.debug("Not all of the bytes appear to have been written, prev-current: {}", (Object)(this.bytesWritten - prevBytesWritten));
                }
                boolean bl = true;
                return bl;
            }
            try {
                throw new IOException("FLV write channel has been closed", new ClosedChannelException());
            }
            catch (InterruptedException e) {
                log.warn("Exception acquiring lock", (Throwable)e);
            }
        }
        finally {
            this.updateInfoFile();
            this.lock.release();
        }
        return false;
    }

    @Override
    public boolean writeStream(byte[] b) {
        try {
            this.dataChannel.write(ByteBuffer.wrap(b));
            return true;
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    private void createOutputFile() throws IOException {
        this.fileChannel = Files.newByteChannel(Paths.get(this.filePath, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private void createDataFile() throws IOException {
        Path path = Paths.get(this.filePath + ".ser", new String[0]);
        if (Files.deleteIfExists(path)) {
            log.debug("Previous flv data file existed and was removed");
        }
        this.dataChannel = Files.newByteChannel(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.READ);
    }

    private void writeMetadataTag(double duration, int videoCodecId, int audioCodecId) throws IOException, InterruptedException, ExecutionException {
        log.debug("writeMetadataTag - duration: {} video codec: {} audio codec: {}", new Object[]{duration, videoCodecId, audioCodecId});
        IoBuffer buf = IoBuffer.allocate((int)256);
        buf.setAutoExpand(true);
        Output out = new Output(buf);
        out.writeString("onMetaData");
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (this.meta != null) {
            params.putAll(this.meta);
        }
        params.putIfAbsent("server", "Red5");
        params.putIfAbsent("recordeddate", this.recordedDate);
        params.put("duration", duration);
        if (log.isDebugEnabled()) {
            log.debug("Stored duration: {}", params.get("duration"));
        }
        if (videoCodecId != -1) {
            params.put("videocodecid", videoCodecId == 7 ? "avc1" : Integer.valueOf(videoCodecId));
            if (this.videoDataSize > 0) {
                params.put("videodatarate", (double)(8 * this.videoDataSize / 1024) / duration);
            }
        } else {
            params.put("novideocodec", 0);
        }
        if (audioCodecId != -1) {
            params.put("audiocodecid", audioCodecId == 10 ? "mp4a" : Integer.valueOf(audioCodecId));
            if (audioCodecId == AudioCodec.AAC.getId()) {
                params.put("audiosamplerate", 44100);
                params.put("audiosamplesize", 16);
            } else if (audioCodecId == AudioCodec.SPEEX.getId()) {
                params.put("audiosamplerate", 16000);
                params.put("audiosamplesize", 16);
            } else {
                params.put("audiosamplerate", this.soundRate);
                params.put("audiosamplesize", this.soundSize);
            }
            params.put("stereo", this.soundType);
            if (this.audioDataSize > 0) {
                params.put("audiodatarate", (double)(8 * this.audioDataSize / 1024) / duration);
            }
        } else {
            params.put("noaudiocodec", 0);
        }
        params.put("canSeekToEnd", true);
        out.writeMap(params);
        buf.flip();
        int bodySize = buf.limit();
        log.debug("Metadata size: {}", (Object)bodySize);
        int totalTagSize = 11 + bodySize + 4;
        ByteBuffer tagBuffer = ByteBuffer.allocate(totalTagSize);
        int timestamp = 0;
        byte[] bodyBuf = new byte[bodySize];
        buf.get(bodyBuf);
        IOUtils.writeUnsignedByte(tagBuffer, (byte)18);
        IOUtils.writeMediumInt(tagBuffer, bodySize);
        IOUtils.writeExtendedMediumInt(tagBuffer, timestamp);
        tagBuffer.put(DEFAULT_STREAM_ID);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after tag header) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.put(bodyBuf);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after body) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.putInt(11 + bodySize);
        if (log.isTraceEnabled()) {
            log.trace("Tag buffer (after prev tag size) limit: {} remaining: {}", (Object)tagBuffer.limit(), (Object)tagBuffer.remaining());
        }
        tagBuffer.flip();
        if (log.isTraceEnabled()) {
            log.trace("Writing metadata starting at position: {}", (Object)this.bytesWritten);
        }
        this.bytesWritten += (long)this.fileChannel.write(tagBuffer);
        if (log.isTraceEnabled()) {
            log.trace("Updated position: {}", (Object)this.bytesWritten);
        }
        tagBuffer.clear();
        buf.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long finalizeFlv() {
        long bytesTransferred;
        block52: {
            block53: {
                Object writePostProcessors;
                bytesTransferred = 0L;
                if (this.finalized.get()) break block53;
                log.debug("Finalizing {}", (Object)this.filePath);
                try {
                    int wrote;
                    int read;
                    File tmpFile = new File(this.filePath + ".info");
                    if (tmpFile.exists()) {
                        int[] nArray = FLVWriter.readInfoFile(tmpFile);
                        if (this.audioCodecId == -1 && nArray[0] > 0) {
                            this.audioCodecId = nArray[0];
                        }
                        if (this.videoCodecId == -1 && nArray[1] > 0) {
                            this.videoCodecId = nArray[1];
                        }
                        if (this.duration == 0 && nArray[2] > 0) {
                            this.duration = nArray[2];
                        }
                        if (this.audioDataSize == 0 && nArray[3] > 0) {
                            this.audioDataSize = nArray[3];
                        }
                        if (this.soundRate == 0 && nArray[4] > 0) {
                            this.soundRate = nArray[4];
                        }
                        if (this.soundSize == 0 && nArray[5] > 0) {
                            this.soundSize = nArray[5];
                        }
                        if (!this.soundType && nArray[6] > 0) {
                            this.soundType = true;
                        }
                        if (this.videoDataSize == 0 && nArray[7] > 0) {
                            this.videoDataSize = nArray[7];
                        }
                    } else {
                        log.debug("Flv info file not found");
                    }
                    tmpFile = null;
                    this.writeHeader();
                    log.debug("Pos post header: {}", (Object)this.fileChannel.position());
                    this.writeMetadataTag((double)this.duration * 0.001, this.videoCodecId, this.audioCodecId);
                    log.debug("Pos post meta: {}", (Object)this.fileChannel.position());
                    ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
                    if (this.append) {
                        Path path = Paths.get(this.filePath.replace(".flv", ".old"), new String[0]);
                        if (Files.exists(path, new LinkOption[0])) {
                            log.debug("Found previous flv: {} offset: {}", (Object)path, (Object)this.appendOffset);
                            SeekableByteChannel prevChannel = Files.newByteChannel(path, StandardOpenOption.READ);
                            prevChannel.position(this.appendOffset);
                            read = -1;
                            boolean showfirsttag = true;
                            do {
                                read = prevChannel.read(byteBuffer);
                                log.trace("Read: {} bytes", (Object)read);
                                if (read > 0) {
                                    byteBuffer.flip();
                                    if (showfirsttag) {
                                        showfirsttag = false;
                                        byteBuffer.mark();
                                        log.debug("Tag type: {}", (Object)(byteBuffer.get() & 0x1F));
                                        byteBuffer.reset();
                                    }
                                    wrote = this.fileChannel.write(byteBuffer);
                                    log.trace("Wrote: {} bytes", (Object)wrote);
                                    bytesTransferred += (long)wrote;
                                }
                                byteBuffer.compact();
                            } while (read > 0);
                            byteBuffer.clear();
                            prevChannel.close();
                            Files.deleteIfExists(path);
                            log.debug("Previous FLV bytes written: {} final position: {}", (Object)(this.bytesWritten + bytesTransferred), (Object)this.fileChannel.position());
                        } else {
                            log.warn("Previous flv to be appended was not found: {}", (Object)path);
                        }
                    }
                    long l = this.dataChannel.position();
                    log.trace("Data available: {} bytes", (Object)l);
                    this.dataChannel.position(0L);
                    read = -1;
                    do {
                        read = this.dataChannel.read(byteBuffer);
                        log.trace("Read: {} bytes", (Object)read);
                        if (read > 0) {
                            byteBuffer.flip();
                            wrote = this.fileChannel.write(byteBuffer);
                            log.trace("Wrote: {} bytes", (Object)wrote);
                            bytesTransferred += (long)wrote;
                        }
                        byteBuffer.compact();
                    } while (read > 0);
                    byteBuffer.clear();
                    this.dataChannel.close();
                    long length = this.fileChannel.position();
                    this.fileChannel.close();
                    if (bytesTransferred > 0L) {
                        if (!Files.deleteIfExists(Paths.get(this.filePath + ".info", new String[0]))) {
                            log.warn("FLV info file not deleted");
                        }
                        if (!Files.deleteIfExists(Paths.get(this.filePath + ".ser", new String[0]))) {
                            log.warn("FLV serial file not deleted");
                        }
                    }
                    log.debug("FLV bytes written: {} final position: {}", (Object)(this.bytesWritten + bytesTransferred), (Object)length);
                    this.finalized.compareAndSet(false, true);
                }
                catch (Exception e) {
                    LinkedList<Class<IPostProcessor>> writePostProcessors2;
                    try {
                        log.warn("Finalization of flv file failed; new finalize job will be spawned", (Throwable)e);
                        this.finalized.compareAndSet(false, true);
                    }
                    catch (Throwable throwable) {
                        LinkedList<Class<IPostProcessor>> writePostProcessors3;
                        this.finalized.compareAndSet(false, true);
                        if (flv != null && (writePostProcessors3 = ((FLV)flv).getWritePostProcessors()) != null) {
                            for (Class clazz : writePostProcessors3) {
                                try {
                                    this.addPostProcessor((IPostProcessor)clazz.newInstance());
                                }
                                catch (Exception e2) {
                                    log.warn("Post processor: {} instance creation failed", (Object)clazz, (Object)e2);
                                }
                            }
                        }
                        if (this.postProcessors != null) {
                            for (IPostProcessor postProcessor : this.postProcessors) {
                                log.debug("Execute: {}", (Object)postProcessor);
                                try {
                                    postProcessor.init(this.filePath);
                                    this.executor.submit(postProcessor).get();
                                }
                                catch (Throwable throwable2) {
                                    log.warn("Exception during post process on: {}", (Object)this.filePath, (Object)throwable2);
                                }
                            }
                            this.postProcessors.clear();
                        } else {
                            log.debug("No post processors configured");
                        }
                        throw throwable;
                    }
                    if (flv != null && (writePostProcessors2 = ((FLV)flv).getWritePostProcessors()) != null) {
                        for (Class clazz : writePostProcessors2) {
                            try {
                                this.addPostProcessor((IPostProcessor)clazz.newInstance());
                            }
                            catch (Exception e3) {
                                log.warn("Post processor: {} instance creation failed", (Object)clazz, (Object)e3);
                            }
                        }
                    }
                    if (this.postProcessors != null) {
                        for (IPostProcessor iPostProcessor : this.postProcessors) {
                            log.debug("Execute: {}", (Object)iPostProcessor);
                            try {
                                iPostProcessor.init(this.filePath);
                                this.executor.submit(iPostProcessor).get();
                            }
                            catch (Throwable throwable) {
                                log.warn("Exception during post process on: {}", (Object)this.filePath, (Object)throwable);
                            }
                        }
                        this.postProcessors.clear();
                    } else {
                        log.debug("No post processors configured");
                    }
                    break block52;
                }
                if (flv != null && (writePostProcessors = ((FLV)flv).getWritePostProcessors()) != null) {
                    Iterator iterator = ((AbstractSequentialList)writePostProcessors).iterator();
                    while (iterator.hasNext()) {
                        Class clazz = (Class)iterator.next();
                        try {
                            this.addPostProcessor((IPostProcessor)clazz.newInstance());
                        }
                        catch (Exception e) {
                            log.warn("Post processor: {} instance creation failed", (Object)clazz, (Object)e);
                        }
                    }
                }
                if (this.postProcessors != null) {
                    for (IPostProcessor iPostProcessor : this.postProcessors) {
                        log.debug("Execute: {}", (Object)iPostProcessor);
                        try {
                            iPostProcessor.init(this.filePath);
                            this.executor.submit(iPostProcessor).get();
                        }
                        catch (Throwable throwable) {
                            log.warn("Exception during post process on: {}", (Object)this.filePath, (Object)throwable);
                        }
                    }
                    this.postProcessors.clear();
                } else {
                    log.debug("No post processors configured");
                }
                break block52;
            }
            log.trace("Finalization already completed");
        }
        return bytesTransferred;
    }

    private static int[] readInfoFile(File tmpFile) {
        int[] info = new int[8];
        try (RandomAccessFile infoFile = new RandomAccessFile(tmpFile, "r");){
            info[0] = infoFile.readInt();
            info[1] = infoFile.readInt();
            info[2] = infoFile.readInt();
            info[3] = infoFile.readInt();
            info[4] = infoFile.readInt();
            info[5] = infoFile.readInt();
            info[6] = infoFile.readInt();
            info[7] = infoFile.readInt();
        }
        catch (Exception e) {
            log.warn("Exception reading flv file information data", (Throwable)e);
        }
        return info;
    }

    private void updateInfoFile() {
        try (RandomAccessFile infoFile = new RandomAccessFile(this.filePath + ".info", "rw");){
            infoFile.writeInt(this.audioCodecId);
            infoFile.writeInt(this.videoCodecId);
            infoFile.writeInt(this.duration);
            infoFile.writeInt(this.audioDataSize);
            infoFile.writeInt(this.soundRate);
            infoFile.writeInt(this.soundSize);
            infoFile.writeInt(this.soundType ? 1 : 0);
            infoFile.writeInt(this.videoDataSize);
        }
        catch (Exception e) {
            log.warn("Exception writing flv file information data", (Throwable)e);
        }
    }

    @Override
    public void close() {
        log.debug("close");
        boolean locked = false;
        try {
            locked = this.lock.tryAcquire(500L, TimeUnit.MILLISECONDS);
            if (locked) {
                this.finalizeFlv();
            }
        }
        catch (InterruptedException e) {
            log.warn("Exception acquiring lock", (Throwable)e);
        }
        finally {
            if (locked) {
                this.lock.release();
            }
            if (this.executor != null && !this.executor.isTerminated()) {
                this.executor.shutdown();
            }
        }
    }

    @Override
    public void addPostProcessor(IPostProcessor postProcessor) {
        if (this.postProcessors == null) {
            this.postProcessors = new LinkedList();
        }
        this.postProcessors.add(postProcessor);
    }

    @Override
    public IStreamableFile getFile() {
        return flv;
    }

    public static void setFLV(IFLV flv) {
        FLVWriter.flv = flv;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setVideoCodecId(int videoCodecId) {
        this.videoCodecId = videoCodecId;
    }

    public void setAudioCodecId(int audioCodecId) {
        this.audioCodecId = audioCodecId;
    }

    public void setSoundRate(int soundRate) {
        this.soundRate = soundRate;
    }

    public void setSoundSize(int soundSize) {
        this.soundSize = soundSize;
    }

    public void setSoundType(boolean soundType) {
        this.soundType = soundType;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setVideoDataSize(int videoDataSize) {
        this.videoDataSize = videoDataSize;
    }

    public void setAudioDataSize(int audioDataSize) {
        this.audioDataSize = audioDataSize;
    }

    public static boolean repair(String path, Integer audioId, Integer videoId) throws InterruptedException {
        boolean result = false;
        Object writer = null;
        log.debug("Serial file path: " + path);
        System.out.println("Serial file path: " + path);
        if (path.endsWith(".ser")) {
            File ser = new File(path);
            if (ser.exists() && ser.canRead()) {
                ser = null;
                String flvPath = path.substring(0, path.lastIndexOf(46));
                log.debug("Flv file path: " + flvPath);
                System.out.println("Flv file path: " + flvPath);
                File inf = new File(flvPath + ".info");
                if (inf.exists() && inf.canRead()) {
                    inf = null;
                    writer = new FLVWriter(flvPath);
                } else {
                    log.debug("Info file was not found or could not be read, using dummy data");
                    System.err.println("Info file was not found or could not be read, using dummy data");
                    writer = new FLVWriter(flvPath);
                    int acid = audioId == null ? 11 : audioId;
                    int vcid = videoId == null ? 7 : videoId;
                    ((FLVWriter)writer).setAudioCodecId(acid);
                    ((FLVWriter)writer).setVideoCodecId(vcid);
                    ((FLVWriter)writer).setDuration(Integer.MAX_VALUE);
                    ((FLVWriter)writer).setSoundRate(16000);
                    ((FLVWriter)writer).setSoundSize(16);
                }
            } else {
                log.error("Serial file was not found or could not be read");
                System.err.println("Serial file was not found or could not be read");
            }
        } else {
            log.error("Provide the path to your .ser file");
            System.err.println("Serial file was not found or could not be read");
        }
        if (writer != null) {
            Object object = writer;
            object.getClass();
            Future<?> future = super.submit((FLVWriter)object.new FLVFinalizer());
            try {
                future.get();
                log.debug("File repair completed");
                System.out.println("File repair completed");
                result = true;
            }
            catch (Exception e) {
                log.warn("Exception while finalizing: {}", (Object)path, (Object)e);
            }
        }
        return result;
    }

    private Future<?> submit(FLVFinalizer flvFinalizer) {
        if (this.executor != null && !this.executor.isTerminated()) {
            return this.executor.submit(flvFinalizer);
        }
        return null;
    }

    public static void main(String[] args) throws InterruptedException {
        if (args == null || args[0] == null) {
            System.err.println("Provide the path to your .ser file");
        } else {
            FLVWriter.repair(args[0], args.length > 1 && args[1] != null ? Integer.valueOf(args[1]) : null, args.length > 2 && args[2] != null ? Integer.valueOf(args[2]) : null);
        }
        System.exit(0);
    }

    private final class FLVFinalizer
    implements Runnable {
        private FLVFinalizer() {
        }

        @Override
        public void run() {
            log.debug("Finalizer run");
            try {
                boolean deleted = Files.deleteIfExists(Paths.get(FLVWriter.this.filePath, new String[0]));
                log.info("Deleted ({}) incomplete file: {}", (Object)deleted, (Object)FLVWriter.this.filePath);
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                log.error("Error on cleanup of flv", (Throwable)e);
            }
            FLVWriter.this.finalizeFlv();
            log.debug("Finalizer exit");
        }
    }
}

