/*
 * Decompiled with CFR 0.152.
 */
package org.red5.cache.impl;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.event.CacheManagerEventListener;
import org.red5.cache.ICacheStore;
import org.red5.cache.ICacheable;
import org.red5.cache.impl.CacheableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EhCacheImpl
implements ICacheStore,
ApplicationContextAware {
    protected static Logger log = LoggerFactory.getLogger(EhCacheImpl.class);
    private static Ehcache cache;
    private List<CacheConfiguration> configs;
    private String memoryStoreEvictionPolicy = "LRU";
    private int diskExpiryThreadIntervalSeconds = 120;
    private String diskStore = System.getProperty("java.io.tmpdir");
    private CacheManagerEventListener cacheManagerEventListener;
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public void init() {
        log.info("Loading ehcache");
        try {
            CacheManager cm = CacheManager.getInstance();
            Configuration configuration = new Configuration();
            String defaultCacheName = "default";
            for (CacheConfiguration conf : this.configs) {
                conf.setDiskExpiryThreadIntervalSeconds((long)this.diskExpiryThreadIntervalSeconds);
                conf.setMemoryStoreEvictionPolicy(this.memoryStoreEvictionPolicy);
                if (null == cache) {
                    defaultCacheName = conf.getName();
                    configuration.addDefaultCache(conf);
                    continue;
                }
                configuration.addCache(conf);
            }
            ConfigurationHelper helper = new ConfigurationHelper(cm, configuration);
            cache = helper.createDefaultCache();
            cache.initialise();
            cache.bootstrap();
            Set caches = helper.createCaches();
            if (log.isDebugEnabled()) {
                log.debug("Number of caches: " + caches.size() + " Default cache: " + (cache != null ? 1 : 0));
            }
            for (Cache nonDefaultCache : caches) {
                nonDefaultCache.initialise();
                nonDefaultCache.bootstrap();
                if (null != nonDefaultCache) continue;
                log.debug("Default cache name: {}", (Object)defaultCacheName);
                nonDefaultCache = cm.getCache(defaultCacheName);
            }
        }
        catch (Exception e) {
            log.warn("Error on cache init", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Cache is null? {}", (Object)(null == cache ? 1 : 0));
        }
    }

    @Override
    public ICacheable get(String name) {
        ICacheable ic = null;
        try {
            ic = (ICacheable)cache.get((Serializable)((Object)name)).getObjectValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return ic;
    }

    @Override
    public void put(String name, Object obj) {
        if (obj instanceof ICacheable) {
            cache.put(new Element((Object)name, obj));
        } else {
            cache.put(new Element((Object)name, (Object)new CacheableImpl(obj)));
        }
    }

    @Override
    public Iterator<String> getObjectNames() {
        return cache.getKeys().iterator();
    }

    @Override
    public Iterator<SoftReference<? extends ICacheable>> getObjects() {
        return null;
    }

    @Override
    public boolean offer(String name, Object obj) {
        boolean result = false;
        try {
            result = cache.isKeyInCache((Object)name);
            if (!result) {
                this.put(name, obj);
            }
            result = cache.isKeyInCache((Object)name);
        }
        catch (NullPointerException npe) {
            log.debug("Name: " + name + " Object: " + obj.getClass().getName(), (Throwable)npe);
        }
        return result;
    }

    @Override
    public boolean remove(ICacheable obj) {
        return cache.remove((Serializable)((Object)obj.getName()));
    }

    @Override
    public boolean remove(String name) {
        return cache.remove((Serializable)((Object)name));
    }

    public void setCacheConfigs(List<CacheConfiguration> configs) {
        this.configs = configs;
    }

    @Override
    public void setMaxEntries(int capacity) {
        if (log.isDebugEnabled()) {
            log.debug("Setting max entries for this cache to " + capacity);
        }
    }

    public String getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public void setMemoryStoreEvictionPolicy(String memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }

    public int getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public void setDiskExpiryThreadIntervalSeconds(int diskExpiryThreadIntervalSeconds) {
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
    }

    public String getDiskStore() {
        return this.diskStore;
    }

    public void setDiskStore(String diskStore) {
        this.diskStore = System.getProperty("diskStore");
    }

    public CacheManagerEventListener getCacheManagerEventListener() {
        return this.cacheManagerEventListener;
    }

    public void setCacheManagerEventListener(CacheManagerEventListener cacheManagerEventListener) {
        this.cacheManagerEventListener = cacheManagerEventListener;
    }

    public static long getCacheHit() {
        return cache.getStatistics().getCacheHits();
    }

    public static long getCacheMiss() {
        return cache.getStatistics().getCacheMisses();
    }

    @Override
    public void destroy() {
        try {
            CacheManager.getInstance().shutdown();
        }
        catch (Exception e) {
            log.warn("Error on cache shutdown", (Throwable)e);
        }
    }
}

