/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.matching;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.matching.Matcher;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMatcher
implements Matcher {
    private static final Logger logger = LoggerFactory.getLogger(PathMatcher.class);
    private final Set<String> excludedPaths = new HashSet<String>();
    private final Set<Pattern> excludedPatterns = new HashSet<Pattern>();

    public PathMatcher() {
    }

    public PathMatcher(String regexpPath) {
        this.excludeRegex(regexpPath);
    }

    public PathMatcher excludePath(String path) {
        PathMatcher.validatePath(path);
        this.excludedPaths.add(path);
        return this;
    }

    public PathMatcher excludeBranch(String path) {
        PathMatcher.validatePath(path);
        this.excludedPatterns.add(Pattern.compile("^" + path + "(/.*)?$"));
        return this;
    }

    public PathMatcher excludeRegex(String regex) {
        CommonHelper.assertNotBlank("regex", regex);
        logger.warn("Excluding paths with regexes is an advanced feature: be careful when defining your regular expression to avoid any security issues!");
        if (!regex.startsWith("^") || !regex.endsWith("$")) {
            throw new TechnicalException("Your regular expression: '" + regex + "' must start with a ^ and end with a $ to define a full path matching");
        }
        this.excludedPatterns.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public boolean matches(WebContext context) {
        return this.matches(context.getPath());
    }

    boolean matches(String path) {
        if (this.excludedPaths.contains(path)) {
            return false;
        }
        for (Pattern pattern : this.excludedPatterns) {
            if (!pattern.matcher(path).matches()) continue;
            return false;
        }
        return true;
    }

    public Set<String> getExcludedPaths() {
        return this.excludedPaths;
    }

    public Set<Pattern> getExcludedPatterns() {
        return this.excludedPatterns;
    }

    public void setExcludedPaths(Collection<String> paths) {
        this.excludedPaths.clear();
        paths.forEach(path -> this.excludePath((String)path));
    }

    public void setExcludedPatterns(Collection<String> regularExpressions) {
        this.excludedPatterns.clear();
        regularExpressions.forEach(regex -> this.excludeRegex((String)regex));
    }

    private static void validatePath(String path) {
        CommonHelper.assertNotBlank("path", path);
        if (!path.startsWith("/")) {
            throw new TechnicalException("Excluded path must begin with a /");
        }
    }
}

