/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.credentials.extractor;

import org.pac4j.core.context.HttpConstants;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.util.CommonHelper;

public class ParameterExtractor
implements CredentialsExtractor<TokenCredentials> {
    private final String parameterName;
    private final String clientName;
    private boolean supportGetRequest;
    private boolean supportPostRequest;

    public ParameterExtractor(String parameterName, String clientName) {
        this(parameterName, false, true, clientName);
    }

    public ParameterExtractor(String parameterName, boolean supportGetRequest, boolean supportPostRequest, String clientName) {
        this.parameterName = parameterName;
        this.supportGetRequest = supportGetRequest;
        this.supportPostRequest = supportPostRequest;
        this.clientName = clientName;
    }

    @Override
    public TokenCredentials extract(WebContext context) throws HttpAction, CredentialsException {
        String method = context.getRequestMethod();
        if (HttpConstants.HTTP_METHOD.GET.name().equalsIgnoreCase(method) && !this.supportGetRequest) {
            throw new CredentialsException("GET requests not supported");
        }
        if (HttpConstants.HTTP_METHOD.POST.name().equalsIgnoreCase(method) && !this.supportPostRequest) {
            throw new CredentialsException("POST requests not supported");
        }
        String value = context.getRequestParameter(this.parameterName);
        if (value == null) {
            return null;
        }
        return new TokenCredentials(value, this.clientName);
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "parameterName", this.parameterName, "clientName", this.clientName, "supportGetRequest", this.supportGetRequest, "supportPostRequest", this.supportPostRequest);
    }
}

