/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.credentials.authenticator;

import java.util.concurrent.TimeUnit;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.store.GuavaStore;
import org.pac4j.core.store.Store;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCachingAuthenticator<T extends Credentials>
extends InitializableWebObject
implements Authenticator<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Authenticator<T> delegate;
    private int cacheSize;
    private int timeout;
    private TimeUnit timeUnit;
    private Store<T, CommonProfile> store;

    public LocalCachingAuthenticator() {
    }

    public LocalCachingAuthenticator(Authenticator<T> delegate, Store<T, CommonProfile> store) {
        this.delegate = delegate;
        this.store = store;
    }

    public LocalCachingAuthenticator(Authenticator<T> delegate, int cacheSize, int timeout, TimeUnit timeUnit) {
        this.delegate = delegate;
        this.cacheSize = cacheSize;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    @Override
    public void validate(T credentials, WebContext context) throws HttpAction, CredentialsException {
        this.init(context);
        CommonProfile profile = this.store.get(credentials);
        if (profile == null) {
            this.logger.debug("No cached credentials found. Delegating authentication to {}...", this.delegate);
            this.delegate.validate(credentials, context);
            profile = ((Credentials)credentials).getUserProfile();
            this.logger.debug("Caching credential. Using profile {}...", (Object)profile);
            this.store.set(credentials, profile);
        } else {
            ((Credentials)credentials).setUserProfile(profile);
            this.logger.debug("Found cached credential. Using cached profile {}...", (Object)profile);
        }
    }

    @Override
    protected void internalInit(WebContext context) {
        if (this.store == null) {
            this.store = new GuavaStore<T, CommonProfile>(this.cacheSize, this.timeout, this.timeUnit);
        }
        if (this.delegate instanceof InitializableWebObject) {
            ((InitializableWebObject)((Object)this.delegate)).init(context);
        }
    }

    public void removeFromCache(T credentials) {
        this.store.remove(credentials);
    }

    public boolean isCached(T credentials) {
        return this.store.get(credentials) != null;
    }

    public Authenticator<T> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Authenticator<T> delegate) {
        this.delegate = delegate;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Store<T, CommonProfile> getStore() {
        return this.store;
    }

    public void setStore(Store<T, CommonProfile> store) {
        this.store = store;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "delegate", this.delegate, "store", this.store);
    }
}

