/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.bnd;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;

public class BndUtils {
    private static final Log LOG = LogFactory.getLog(BndUtils.class);
    private static final Pattern INSTRUCTIONS_PATTERN = Pattern.compile("([a-zA-Z_0-9-]+)=([-!\"'()*+,.0-9A-Z_a-z%;=/]+)");

    private BndUtils() {
    }

    public static InputStream createBundle(InputStream jarInputStream, Properties instructions, String jarInfo) throws IOException {
        NullArgumentException.validateNotNull((Object)jarInputStream, (String)"Jar URL");
        NullArgumentException.validateNotNull((Object)instructions, (String)"Instructions");
        NullArgumentException.validateNotEmpty((String)jarInfo, (String)"Jar info");
        LOG.debug((Object)("Creating bundle for [" + jarInfo + "]"));
        LOG.trace((Object)("Using instructions " + instructions));
        Jar jar = new Jar("dot", jarInputStream);
        Manifest manifest = jar.getManifest();
        if (manifest == null || manifest.getMainAttributes().getValue("Export-Package") == null && manifest.getMainAttributes().getValue("Import-Package") == null) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)instructions);
            properties.put("Generated-By-Ops4j-Pax-From", jarInfo);
            Analyzer analyzer = new Analyzer();
            analyzer.setJar(jar);
            analyzer.setProperties(properties);
            BndUtils.checkMandatoryProperties(analyzer, jar, jarInfo);
            analyzer.mergeManifest(manifest);
            analyzer.calcManifest();
        }
        return BndUtils.createInputStream(jar);
    }

    private static PipedInputStream createInputStream(final Jar jar) throws IOException {
        PipedInputStream pin = new PipedInputStream();
        final PipedOutputStream pout = new PipedOutputStream(pin);
        new Thread(){

            public void run() {
                try {
                    jar.write((OutputStream)pout);
                }
                catch (IOException e) {
                    throw new RuntimeException("Bundle cannot be generated", e);
                }
                finally {
                    try {
                        jar.close();
                        pout.close();
                    }
                    catch (IOException ignore) {
                        LOG.error((Object)"Bundle cannot be generated", (Throwable)ignore);
                    }
                }
            }
        }.start();
        return pin;
    }

    private static void checkMandatoryProperties(Analyzer analyzer, Jar jar, String symbolicName) {
        String exportPackage;
        String importPackage = analyzer.getProperty("Import-Package");
        if (importPackage == null || importPackage.trim().length() == 0) {
            analyzer.setProperty("Import-Package", "*;resolution:=optional");
        }
        if ((exportPackage = analyzer.getProperty("Export-Package")) == null || exportPackage.trim().length() == 0) {
            analyzer.setProperty("Export-Package", analyzer.calculateExportsFromContents(jar));
        }
        String localSymbolicName = analyzer.getProperty("Bundle-SymbolicName", symbolicName);
        analyzer.setProperty("Bundle-SymbolicName", BndUtils.generateSymbolicName(localSymbolicName));
    }

    private static String generateSymbolicName(String symbolicName) {
        return symbolicName.replaceAll("[^a-zA-Z_0-9.-]", "_");
    }

    public static Properties parseInstructions(String query) throws MalformedURLException {
        Properties instructions = new Properties();
        if (query != null) {
            try {
                String[] segments;
                for (String segment : segments = query.split("&")) {
                    if (segment.trim().length() <= 0) continue;
                    Matcher matcher = INSTRUCTIONS_PATTERN.matcher(segment);
                    if (matcher.matches()) {
                        instructions.setProperty(matcher.group(1), URLDecoder.decode(matcher.group(2), "UTF-8"));
                        continue;
                    }
                    throw new MalformedURLException("Invalid syntax for instruction [" + segment + "]. Take a look at http://www.aqute.biz/Code/Bnd.");
                }
            }
            catch (UnsupportedEncodingException e) {
                BndUtils.throwAsMalformedURLException("Could not retrieve the instructions from [" + query + "]", e);
            }
        }
        return instructions;
    }

    private static void throwAsMalformedURLException(String message, Exception cause) throws MalformedURLException {
        MalformedURLException exception = new MalformedURLException(message);
        exception.initCause(cause);
        throw exception;
    }
}

