/*
 * Copyright 2008 Members of the EGEE Collaboration.
 * Copyright 2008 University Corporation for Advanced Internet Development, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.ws.wsaddressing;

import javax.xml.namespace.QName;

import org.opensaml.xml.AttributeExtensibleXMLObject;

/**
 * Interface for type &lt;wsa:AttributedUnsignedLongType&gt;.
 * 
 * @see "WS-Addressing 1.0 - SOAP Binding"
 * 
 */
public interface AttributedUnsignedLong extends AttributeExtensibleXMLObject, WSAddressingObject {
    
    /** Local name of the XSI type. */
    public static final String TYPE_LOCAL_NAME = "AttributedUnsignedLongType"; 
        
    /** QName of the XSI type. */
    public static final QName TYPE_NAME = 
        new QName(WSAddressingConstants.WSA_NS, TYPE_LOCAL_NAME, WSAddressingConstants.WSA_PREFIX);
    
    /**
     * Gets the element's value.
     * 
     * @return the element's value
     */
    public Long getValue();

    /**
     * Sets the element's value.
     * 
     * @param newValue the new element value
     */
    public void setValue(Long newValue);

}
