/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.ofd.DocBody;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.res.OFDResource;
import org.ofdrw.core.basicStructure.res.Res;
import org.ofdrw.core.basicStructure.res.resources.DrawParams;
import org.ofdrw.core.basicStructure.res.resources.Fonts;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.pageDescription.drawParam.CT_DrawParam;
import org.ofdrw.core.text.font.CT_Font;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.model.OfdPageVo;

public class SealOFDReader
extends OFDReader {
    private ST_Loc docRoot;
    private Document document;

    public SealOFDReader(Path ofdFile) throws IOException {
        this(Files.newInputStream(ofdFile, new OpenOption[0]));
    }

    public SealOFDReader(InputStream inputStream) throws IOException {
        super(inputStream);
        try {
            this.getResourceLocator().save();
            DocBody docBody = this.getOFDDir().getOfd().getDocBody();
            this.docRoot = docBody.getDocRoot();
            this.document = this.getResourceLocator().get(this.docRoot, Document::new);
        }
        catch (FileNotFoundException | DocumentException var15) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + var15.getMessage(), var15);
        }
        finally {
            this.getResourceLocator().restore();
        }
    }

    public List<OfdPageVo> getOFDPageVO() {
        ArrayList<OfdPageVo> pageVoList = new ArrayList<OfdPageVo>();
        try {
            int pageSize = this.document.getPages().getSize();
            for (int i = 0; i < pageSize; ++i) {
                Page page = this.getPage(i + 1);
                OfdPageVo ofdPageVo = new OfdPageVo(page, null);
                pageVoList.add(ofdPageVo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.getResourceLocator().restore();
        }
        return pageVoList;
    }

    public List<CT_Font> getPublicResFonts() {
        ArrayList<CT_Font> ctFontList = new ArrayList<CT_Font>();
        try {
            this.getResourceLocator().save();
            this.getResourceLocator().cd(this.docRoot.parent());
            ST_Loc publicResLoc = this.document.getCommonData().getPublicRes();
            Res publicRes = this.getResourceLocator().get(publicResLoc, Res::new);
            for (int i = 0; i < publicRes.getFonts().size(); ++i) {
                Fonts fonts = (Fonts)publicRes.getFonts().get(i);
                ctFontList.addAll(fonts.getFonts());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.getResourceLocator().restore();
        }
        return ctFontList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CT_DrawParam> getPublicResDrawParam() {
        ArrayList<CT_DrawParam> ctDrawParamList = new ArrayList<CT_DrawParam>();
        try {
            this.getResourceLocator().save();
            this.getResourceLocator().cd(this.docRoot.parent());
            ST_Loc publicResLoc = this.document.getCommonData().getPublicRes();
            Res publicRes = this.getResourceLocator().get(publicResLoc, Res::new);
            ArrayList<DrawParams> drawParamsList = new ArrayList<DrawParams>();
            for (OFDResource item : publicRes.getResources()) {
                if (!(item instanceof DrawParams)) continue;
                drawParamsList.add((DrawParams)item);
            }
            for (int i = 0; i < drawParamsList.size(); ++i) {
                DrawParams drawParams = (DrawParams)drawParamsList.get(i);
                ctDrawParamList.addAll(drawParams.getDrawParams());
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.getResourceLocator().restore();
        }
        return ctDrawParamList;
    }
}

