/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.reader;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.dom4j.DocumentException;
import org.ofdrw.core.annotation.Annotations;
import org.ofdrw.core.attachment.Attachments;
import org.ofdrw.core.attachment.CT_Attachment;
import org.ofdrw.core.basicStructure.doc.CT_CommonData;
import org.ofdrw.core.basicStructure.doc.CT_PageArea;
import org.ofdrw.core.basicStructure.doc.Document;
import org.ofdrw.core.basicStructure.ofd.DocBody;
import org.ofdrw.core.basicStructure.pageObj.Page;
import org.ofdrw.core.basicStructure.pageTree.Pages;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.core.signatures.Signatures;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.pkg.container.OFDDir;
import org.ofdrw.pkg.container.VirtualContainer;
import org.ofdrw.reader.BadOFDException;
import org.ofdrw.reader.PageInfo;
import org.ofdrw.reader.ResourceLocator;
import org.ofdrw.reader.ZipUtil;

public class OFDReader
implements Closeable {
    private Path workDir;
    private OFDDir ofdDir;
    private ResourceLocator rl;
    private boolean closed = false;

    private OFDReader() {
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public OFDReader(Path ofdFile) throws IOException {
        if (ofdFile == null || Files.notExists(ofdFile, new LinkOption[0])) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4f4d\u7f6e(ofdFile)\u4e0d\u6b63\u786e");
        }
        this.workDir = Files.createTempDirectory("ofd-tmp-", new FileAttribute[0]);
        ZipUtil.unZipFiles(ofdFile.toFile(), this.workDir.toAbsolutePath().toString() + File.separator);
        this.ofdDir = new OFDDir(this.workDir);
        this.rl = new ResourceLocator(this.ofdDir);
    }

    public OFDReader(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u8f93\u5165\u6d41(stream)\u4e0d\u6b63\u786e");
        }
        this.workDir = Files.createTempDirectory("ofd-tmp-", new FileAttribute[0]);
        ZipUtil.unZipFiles(stream, this.workDir.toAbsolutePath().toString() + File.separator);
        this.ofdDir = new OFDDir(this.workDir);
        this.rl = new ResourceLocator(this.ofdDir);
    }

    public OFDDir getOFDDir() {
        return this.ofdDir;
    }

    public ST_Loc getDefaultDocSignaturesPath() {
        try {
            this.rl.save();
            this.rl.cd("/");
            DocBody docBody = this.ofdDir.getOfd().getDocBody();
            ST_Loc loc = docBody.getSignatures();
            if (loc == null) {
                ST_Loc sT_Loc = null;
                return sT_Loc;
            }
            String signListFileAbsPath = this.rl.toAbsolutePath(loc);
            ST_Loc sT_Loc = ST_Loc.getInstance((String)signListFileAbsPath);
            return sT_Loc;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
        finally {
            this.rl.restore();
        }
    }

    public Signatures getDefaultSignatures() {
        ST_Loc signaturesLoc = this.getDefaultDocSignaturesPath();
        if (signaturesLoc == null) {
            throw new BadOFDException("OFD\u6587\u6863\u4e2d\u4e0d\u5b58\u5728Signatures.xml");
        }
        try {
            return this.rl.get(signaturesLoc, Signatures::new);
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
    }

    public boolean hasSignature() {
        DocBody docBody = null;
        try {
            docBody = this.ofdDir.getOfd().getDocBody();
            ST_Loc signaturesLoc = docBody.getSignatures();
            return signaturesLoc != null;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
    }

    public Annotations getAnnotations() {
        try {
            this.rl.save();
            DocBody docBody = this.ofdDir.getOfd().getDocBody();
            ST_Loc docRoot = docBody.getDocRoot();
            Document document = this.rl.get(docRoot, Document::new);
            this.rl.cd(docRoot.parent());
            ST_Loc annotations = document.getAnnotations();
            if (annotations == null) {
                Annotations annotations2 = null;
                return annotations2;
            }
            Annotations annotations3 = this.rl.get(annotations, Annotations::new);
            return annotations3;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.rl.restore();
        }
    }

    public int getNumberOfPages() {
        try {
            this.rl.save();
            DocBody docBody = this.ofdDir.getOfd().getDocBody();
            ST_Loc docRoot = docBody.getDocRoot();
            Document document = this.rl.get(docRoot, Document::new);
            this.rl.cd(docRoot.parent());
            Pages pages = document.getPages();
            int n = pages.getSize();
            return n;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new BadOFDException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.rl.restore();
        }
    }

    public PageInfo getPageInfo(int pageNum) {
        if (pageNum <= 0) {
            throw new NumberFormatException("\u9875\u7801(pageNum)\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        try {
            int index = pageNum - 1;
            this.rl.save();
            DocBody docBody = this.ofdDir.getOfd().getDocBody();
            ST_Loc docRoot = docBody.getDocRoot();
            Document document = this.rl.get(docRoot, Document::new);
            this.rl.cd(docRoot.parent());
            Pages pages = document.getPages();
            List pageList = pages.getPages();
            if (index >= pageList.size()) {
                throw new NumberFormatException(pageNum + "\u8d85\u8fc7\u6700\u5927\u9875\u7801:" + pageList.size());
            }
            ST_Loc pageLoc = ((org.ofdrw.core.basicStructure.pageTree.Page)pageList.get(index)).getBaseLoc();
            Page obj = this.rl.get(pageLoc, Page::new);
            pageLoc = this.rl.getAbsTo(pageLoc);
            ST_Box pageSize = this.getPageSize(obj);
            PageInfo pageInfo = new PageInfo().setIndex(pageNum).setId(((org.ofdrw.core.basicStructure.pageTree.Page)pageList.get(index)).getID()).setObj(obj).setSize(pageSize.clone()).setPageAbsLoc(pageLoc);
            return pageInfo;
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new RuntimeException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
        }
        finally {
            this.rl.restore();
        }
    }

    public ST_Box getPageSize(Page page) {
        CT_PageArea pageArea = page.getArea();
        if (pageArea == null || pageArea.getPhysicalBox() == null) {
            Document document;
            try {
                document = this.ofdDir.obtainDocDefault().getDocument();
            }
            catch (FileNotFoundException | DocumentException e) {
                throw new BadOFDException("OFD\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage(), e);
            }
            CT_CommonData commonData = document.getCommonData();
            pageArea = commonData.getPageArea();
        }
        return pageArea.getPhysicalBox();
    }

    public Page getPage(int pageNum) {
        return this.getPageInfo(pageNum).getObj();
    }

    public ST_ID getPageObjectId(int pageNum) {
        return this.getPageInfo(pageNum).getId();
    }

    public ResourceLocator getResourceLocator() {
        return this.rl;
    }

    public CT_Attachment getAttachment(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        this.rl.save();
        try {
            CT_Attachment cT_Attachment = this.getAttachment(name, this.rl);
            return cT_Attachment;
        }
        finally {
            this.rl.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getAttachmentFile(String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        this.rl.save();
        try {
            CT_Attachment attachment = this.getAttachment(name, this.rl);
            if (attachment == null) {
                Path path = null;
                return path;
            }
            ST_Loc fileLoc = attachment.getFileLoc();
            try {
                Path path = this.rl.getFile(fileLoc);
                return path;
            }
            catch (FileNotFoundException e) {
                System.err.println(">> \u65e0\u6cd5\u6839\u636e\u9644\u4ef6\u5bf9\u8c61\u7684\u63cf\u8ff0\u83b7\u53d6\u5230\u9644\u4ef6: " + fileLoc.toString());
                Path path = null;
                this.rl.restore();
                return path;
            }
        }
        finally {
            this.rl.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CT_Attachment getAttachment(String name, ResourceLocator rl) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        rl.save();
        try {
            DocDir docDir = this.ofdDir.obtainDocDefault();
            rl.cd((VirtualContainer)docDir);
            Document document = null;
            Attachments attachments = null;
            try {
                document = docDir.getDocument();
            }
            catch (FileNotFoundException | DocumentException e) {
                throw new BadOFDException(e);
            }
            ST_Loc attachmentsLoc = document.getAttachments();
            if (attachmentsLoc == null) {
                CT_Attachment cT_Attachment = null;
                return cT_Attachment;
            }
            try {
                attachments = rl.get(attachmentsLoc, Attachments::new);
            }
            catch (FileNotFoundException | DocumentException e) {
                System.err.println(">> \u65e0\u6cd5\u83b7\u53d6\u6216\u89e3\u6790Attachments.xml: " + e.getMessage());
                CT_Attachment cT_Attachment = null;
                rl.restore();
                return cT_Attachment;
            }
            for (CT_Attachment attachment : attachments.getAttachments()) {
                if (!attachment.getAttachmentName().equals(name)) continue;
                CT_Attachment cT_Attachment = attachment;
                return cT_Attachment;
            }
        }
        finally {
            rl.restore();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.workDir != null && Files.exists(this.workDir, new LinkOption[0])) {
            try {
                FileUtils.deleteDirectory((File)this.workDir.toFile());
            }
            catch (IOException e) {
                throw new IOException("\u65e0\u6cd5\u5220\u9664Reader\u7684\u5de5\u4f5c\u7a7a\u95f4\uff0c\u539f\u56e0\uff1a" + e.getMessage(), e);
            }
        }
    }
}

