/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.ofdrw.converter.GeneralConvertException;
import org.ofdrw.converter.PdfboxMaker;
import org.ofdrw.reader.OFDReader;
import org.ofdrw.reader.PageInfo;

public class ConvertHelper {
    private static final Logger logger = LoggerFactory.getLogger(ConvertHelper.class);

    public static void ofd2pdf(Object input, Object output) {
        block25: {
            OFDReader reader = null;
            PDDocument pdfDocument = null;
            try {
                if (input instanceof InputStream) {
                    reader = new OFDReader((InputStream)input);
                } else if (input instanceof Path) {
                    reader = new OFDReader((Path)input);
                } else if (input instanceof File) {
                    reader = new OFDReader((InputStream)new FileInputStream((File)input));
                } else if (input instanceof String) {
                    reader = new OFDReader((String)input);
                } else {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8f93\u5165\u683c\u5f0f(input)\uff0c\u4ec5\u652f\u6301InputStream\u3001Path\u3001File\u3001String");
                }
                pdfDocument = new PDDocument();
                PdfboxMaker pdfMaker = new PdfboxMaker(reader, pdfDocument);
                List ofdPageVoList = reader.getPageList();
                long start = 0L;
                long end = 0L;
                long pageNum = 1L;
                for (PageInfo pageInfo : ofdPageVoList) {
                    start = System.currentTimeMillis();
                    pdfMaker.makePage(pageInfo);
                    end = System.currentTimeMillis();
                    logger.debug(String.format("page %d speed time %d", pageNum++, end - start));
                }
                if (output instanceof OutputStream) {
                    pdfDocument.save((OutputStream)output);
                    break block25;
                }
                if (output instanceof File) {
                    pdfDocument.save((File)output);
                    break block25;
                }
                if (output instanceof String) {
                    pdfDocument.save((String)output);
                    break block25;
                }
                if (output instanceof Path) {
                    pdfDocument.save(Files.newOutputStream((Path)output, new OpenOption[0]));
                    break block25;
                }
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8f93\u51fa\u683c\u5f0f(output)\uff0c\u4ec5\u652f\u6301OutputStream\u3001Path\u3001File\u3001String");
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("convert to pdf failed", (Throwable)e);
                throw new GeneralConvertException(e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (pdfDocument != null) {
                        pdfDocument.close();
                    }
                }
                catch (IOException e) {
                    logger.error("close OFDReader failed", (Throwable)e);
                }
            }
        }
    }

    public static void toPdf(InputStream input, OutputStream output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(InputStream input, File output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(InputStream input, String output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(Path input, OutputStream output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(Path input, File output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(Path input, Path output) {
        ConvertHelper.ofd2pdf(input, output);
    }

    public static void toPdf(String unzippedPathRoot, String output, boolean deleteOnClose) {
        OFDReader reader = null;
        PDDocument pdfDocument = null;
        try {
            reader = new OFDReader(unzippedPathRoot, deleteOnClose);
            pdfDocument = new PDDocument();
            PdfboxMaker pdfMaker = new PdfboxMaker(reader, pdfDocument);
            List ofdPageVoList = reader.getPageList();
            long start = 0L;
            long end = 0L;
            long pageNum = 1L;
            for (PageInfo pageInfo : ofdPageVoList) {
                start = System.currentTimeMillis();
                pdfMaker.makePage(pageInfo);
                end = System.currentTimeMillis();
                logger.debug(String.format("page %d speed time %d", pageNum++, end - start));
            }
            pdfDocument.save(output);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("convert to pdf failed", (Throwable)e);
            throw new GeneralConvertException(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
            }
            catch (IOException e) {
                logger.error("close OFDReader failed", (Throwable)e);
            }
        }
    }
}

