/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web.query;

import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.nutz.mvc.annotation.Param;
import org.nutz.web.query.WebOrderField;

public class WebQuery {
    @Param(value="kwd")
    protected String keyword;
    @Param(value="pn")
    protected int pageNumber;
    @Param(value="pgsz")
    protected int pageSize;
    @Param(value="order")
    protected String order;
    protected WebOrderField[] orderFields;
    private transient String _source;

    public boolean hasKeyword() {
        return !Strings.isBlank((CharSequence)this.keyword);
    }

    public char[] getKeywordChars() {
        if (null != this.keyword) {
            return this.keyword.toCharArray();
        }
        return new char[0];
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String kwd) {
        this.keyword = kwd;
    }

    public WebQuery keywordf(String fmt, Object ... args) {
        this.keyword = String.format(fmt, args);
        return this;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pn) {
        this.pageNumber = pn;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pgsz) {
        this.pageSize = pgsz;
    }

    public int offset() {
        return (this.pageNumber - 1) * this.pageSize;
    }

    public String getOrder() {
        return this.order;
    }

    public WebQuery normalize(int minPn, int maxPgsz, String dftOrder) {
        this.pageNumber = Math.max(this.pageNumber, minPn);
        int n = this.pageSize = this.pageSize > 0 ? Math.min(maxPgsz, this.pageSize) : maxPgsz / 2;
        if (Strings.isBlank((CharSequence)this.order)) {
            this.setOrder(dftOrder);
        }
        return this;
    }

    public void setOrder(String order) {
        this.order = order;
        String[] ss = Strings.splitIgnoreBlank((String)order, (String)",");
        if (null != ss) {
            this.orderFields = new WebOrderField[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                this.orderFields[i] = WebOrderField.valueOf(ss[i]);
            }
        }
    }

    public WebOrderField[] getOrderFields() {
        return this.orderFields;
    }

    public void setOrderFields(WebOrderField[] orderFields) {
        this.orderFields = orderFields;
    }

    public boolean hasOrder() {
        return null != this.orderFields && this.orderFields.length > 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof WebQuery) {
            if (this._source == null) {
                this._source = Json.toJson((Object)this, (JsonFormat)JsonFormat.compact());
            }
            WebQuery other = (WebQuery)obj;
            if (other._source == null) {
                other._source = Json.toJson((Object)other, (JsonFormat)JsonFormat.compact());
            }
            return this._source.equals(other._source);
        }
        return false;
    }

    public int hashCode() {
        if (this._source == null) {
            this._source = Json.toJson((Object)this, (JsonFormat)JsonFormat.compact());
        }
        return this._source.hashCode();
    }
}

