/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web.maker;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.nutz.json.Json;
import org.nutz.lang.Files;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.segment.CharSegment;
import org.nutz.lang.segment.Segment;
import org.nutz.lang.util.Disks;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.web.maker.ProjectConf;

public class WebMaker {
    private static Log log = Logs.get();

    private WebMaker() {
    }

    public static void newProject(ProjectConf pc) {
        pc.path = Disks.normalize((String)pc.path);
        log.info((Object)"project config :");
        log.info((Object)("\n" + Json.toJson((Object)pc)));
        File root = Files.createDirIfNoExists((String)pc.path);
        Files.createDirIfNoExists((File)root);
        String pkgPath = "src/" + pc.pkg;
        WebMaker.mkDir(root, "src");
        WebMaker.mkDir(root, pkgPath);
        WebMaker.mkDir(root, pkgPath + "/module");
        WebMaker.mkDir(root, "conf");
        WebMaker.mkDir(root, "conf/ioc");
        WebMaker.mkDir(root, "lib");
        WebMaker.mkDir(root, "test");
        WebMaker.mkDir(root, "test/" + pc.pkg);
        String rootPath = WebMaker.mkDir(root, "ROOT");
        WebMaker.mkDir(root, "ROOT/WEB-INF");
        WebMaker.mkFile(root, pkgPath + "/" + pc.pnm, "java", WebMaker._project(pc));
        WebMaker.mkFile(root, pkgPath + "/" + pc.pnm + "Launcher", "java", WebMaker._launcher(pc));
        WebMaker.mkFile(root, pkgPath + "/" + pc.pnm + "MainModule", "java", WebMaker._mainModule(pc));
        if (!pc.modules.isEmpty()) {
            for (String mnm : pc.modules.keySet()) {
                String at = Strings.sBlank((Object)pc.modules.get(mnm), (String)mnm);
                mnm = Strings.upperFirst((CharSequence)mnm);
                WebMaker.mkFile(root, pkgPath + "/module/" + mnm + "Module", "java", WebMaker._subModule(pc, mnm, at));
            }
        }
        WebMaker.mkFile(root, pkgPath + "/" + pc.pnm + "Setup", "java", WebMaker._setup(pc));
        WebMaker.mkFile(root, pkgPath + "/" + pc.pnm + "Config", "java", WebMaker._conf(pc));
        WebMaker.mkFile(root, "conf/ioc/core", "js", WebMaker._ioc(pc));
        WebMaker.mkFile(root, "conf/log4j", "properties", WebMaker._log4j());
        WebMaker.mkFile(root, "conf/web", "properties", WebMaker._webProperties(pc, rootPath));
        WebMaker.mkFile(root, "ROOT/WEB-INF/web", "xml", WebMaker._webXML(pc));
        WebMaker.mkFile(root, "ROOT/index", "html", WebMaker._pageIndex());
        WebMaker.mkFile(root, "run", "sh", WebMaker._runSH(pc));
        WebMaker.mkFile(root, "ROOT/404", "html", WebMaker._page404());
        log.info((Object)"project has been created");
    }

    public static String mkDir(File root, String path) {
        if (-1 != path.indexOf(".")) {
            path = path.replaceAll("\\.", "/");
        }
        log.info((Object)("mkdir  : " + path));
        String dir = root.getAbsolutePath() + "/" + path;
        File mdir = Files.createDirIfNoExists((String)dir);
        if (mdir != null) {
            return mdir.getAbsolutePath();
        }
        return null;
    }

    public static void mkFile(File root, String path, String type, String fcontent) {
        if (-1 != path.indexOf(".")) {
            path = path.replaceAll("\\.", "/");
        }
        String fnm = path + (Strings.isBlank((CharSequence)type) ? "" : "." + type);
        log.info((Object)("mkfile : " + fnm));
        String file = root.getAbsolutePath() + "/" + fnm;
        try {
            File f = Files.createFileIfNoExists((String)file);
            Files.write((File)f, (Object)fcontent);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    private static Segment _readTmpl(String tnm) {
        String tmpl = Streams.readAndClose((Reader)new InputStreamReader(WebMaker.class.getResourceAsStream(tnm)));
        CharSegment cs = new CharSegment(tmpl);
        return cs;
    }

    private static String _project(ProjectConf pc) {
        Segment cs = WebMaker._readTmpl("project.java.tmpl");
        cs.add("pkg", (Object)pc.pkg);
        cs.add("pnm", (Object)pc.pnm);
        return cs.render().toString();
    }

    private static String _launcher(ProjectConf pc) {
        Segment cs = WebMaker._readTmpl("launcher.java.tmpl");
        cs.add("pkg", (Object)pc.pkg);
        cs.add("pnm", (Object)pc.pnm);
        return cs.render().toString();
    }

    private static String _webProperties(ProjectConf pc, String rootPath) {
        Segment cs = WebMaker._readTmpl("web.properties.tmpl");
        cs.add("app-root-dir", (Object)rootPath);
        cs.add("app-rs", (Object)"");
        cs.add("app-admin-port", (Object)pc.app_admin_port);
        cs.add("app-port", (Object)pc.app_port);
        return cs.render().toString();
    }

    private static String _log4j() {
        return WebMaker._readTmpl("log4j.properties.tmpl").render().toString();
    }

    private static String _ioc(ProjectConf pc) {
        Segment cs = WebMaker._readTmpl("ioc.js.tmpl");
        cs.add("pkg", (Object)pc.pkg);
        cs.add("pnm", (Object)pc.pnm);
        return cs.render().toString();
    }

    private static String _conf(ProjectConf pc) {
        Segment cs = WebMaker._readTmpl("conf.java.tmpl");
        cs.add("pkg", (Object)pc.pkg);
        cs.add("pnm", (Object)pc.pnm);
        return cs.render().toString();
    }

    private static String _mainModule(ProjectConf pc) {
        Segment cs = WebMaker._readTmpl("mainModule.java.tmpl");
        cs.add("pkg", (Object)pc.pkg);
        cs.add("pnm", (Object)pc.pnm);
        return cs.render().toString();
    }

    private static String _subModule(ProjectConf pc, String mnm, String at) {
        Segment cs = WebMaker._readTmpl("subModule.java.tmpl");
        cs.add("pkg", (Object)pc.pkg);
        cs.add("at", (Object)at);
        cs.add("mnm", (Object)mnm);
        return cs.render().toString();
    }

    private static String _setup(ProjectConf pc) {
        Segment cs = WebMaker._readTmpl("setup.java.tmpl");
        cs.add("pkg", (Object)pc.pkg);
        cs.add("pnm", (Object)pc.pnm);
        return cs.render().toString();
    }

    private static String _pageIndex() {
        return WebMaker._readTmpl("index.html.tmpl").render().toString();
    }

    private static String _page404() {
        return WebMaker._readTmpl("404.html.tmpl").render().toString();
    }

    private static String _runSH(ProjectConf pc) {
        Segment cs = WebMaker._readTmpl("run.sh");
        cs.add("pkg", (Object)pc.pkg);
        cs.add("pnm", (Object)pc.pnm);
        cs.add("phome", (Object)pc.path);
        return cs.render().toString();
    }

    private static String _webXML(ProjectConf pc) {
        Segment cs = WebMaker._readTmpl("web.xml.tmpl");
        cs.add("pkg", (Object)pc.pkg);
        cs.add("pnm", (Object)pc.pnm);
        return cs.render().toString();
    }
}

