/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web.comet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class Comet {
    private static Log log = Logs.get();
    private static long defaultSleepTime = 500L;

    public static void setSleepTime(long sleepTime) {
        if (sleepTime > 0L) {
            defaultSleepTime = sleepTime;
        }
    }

    public static boolean replyByXHR(HttpServletResponse resp, String respTxt, long sleepTime) {
        OutputStreamWriter wr = null;
        ServletOutputStream out = null;
        try {
            out = resp.getOutputStream();
            wr = new OutputStreamWriter((OutputStream)out);
            String data = respTxt;
            wr.write(data);
            ((Writer)wr).flush();
            Lang.quiteSleep((long)(1L * sleepTime));
        }
        catch (IOException e) {
            log.warn((Object)"Comet-Send Has Stoped");
            return false;
        }
        return true;
    }

    public static boolean replyByXHR(HttpServletResponse resp, String respTxt) {
        return Comet.replyByXHR(resp, respTxt, defaultSleepTime);
    }

    public static boolean replyByES(HttpServletResponse resp, String respTxt) {
        OutputStreamWriter wr = null;
        ServletOutputStream out = null;
        resp.setHeader("Content-Type", "text/event-stream;charset=UTF-8");
        resp.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        try {
            out = resp.getOutputStream();
            wr = new OutputStreamWriter((OutputStream)out);
            String data = "data:" + respTxt + "\n\n";
            wr.write(data);
            ((Writer)wr).flush();
        }
        catch (IOException e) {
            log.warn((Object)"Comet-Send Has Stoped");
            return false;
        }
        return true;
    }
}

