/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web.ajax;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.View;
import org.nutz.web.WebException;
import org.nutz.web.Webs;
import org.nutz.web.ajax.Ajax;
import org.nutz.web.ajax.AjaxReturn;

public class AjaxView
implements View {
    private boolean uc;

    public AjaxView() {
        this.uc = false;
    }

    public AjaxView(String useCompact) {
        this.uc = Strings.isBlank((CharSequence)useCompact) ? false : Boolean.parseBoolean(useCompact);
    }

    public JsonFormat getJsonFormat() {
        if (this.uc) {
            return JsonFormat.compact();
        }
        return JsonFormat.nice();
    }

    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) throws IOException {
        AjaxReturn re;
        if (null == obj) {
            re = Ajax.ok();
        } else if (obj instanceof Throwable) {
            WebException err = Webs.Err.wrap((Throwable)obj);
            String msg = Mvcs.getMessage((ServletRequest)req, (String)err.getKey());
            re = Ajax.fail().setErrCode(err.getKey()).setMsg(msg).setData(err.getReason());
        } else {
            re = obj instanceof AjaxReturn ? (AjaxReturn)obj : Ajax.ok().setData(obj);
        }
        Mvcs.write((HttpServletResponse)resp, (Object)re, (JsonFormat)this.getJsonFormat());
    }
}

