/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.socket.SocketAction;
import org.nutz.lang.socket.SocketContext;
import org.nutz.lang.socket.Sockets;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.web.WebConfig;
import org.nutz.web.Webs;
import org.nutz.web.jsp.ComboResource;

public class WebServer {
    private static final Log log = Logs.get();
    protected WebConfig dc;
    protected Server server;

    public WebServer(WebConfig config) {
        String modules;
        this.dc = config;
        String annPaths = this.dc.getAppAnnPaths();
        if (!Strings.isBlank((CharSequence)annPaths)) {
            // empty if block
        }
        if (!Strings.isBlank((CharSequence)(modules = this.dc.getAppModules()))) {
            // empty if block
        }
        Webs.setProp(config);
    }

    protected void prepare() throws IOException {
        if (this.dc.getAppPort() <= 0) {
            this.dc.set("app-port", "80");
        }
        this.server = new Server(InetSocketAddress.createUnresolved("0.0.0.0", this.dc.getAppPort()));
        String warUrlString = null;
        String rootPath = this.dc.getAppRoot();
        File root = Files.findFile((String)rootPath);
        if (root == null || !root.exists()) {
            log.warnf("root: '%s' not exist!", new Object[]{this.dc.get("app-root")});
            warUrlString = Lang.runRootPath();
        } else {
            warUrlString = root.toURI().toURL().toExternalForm();
        }
        log.debugf("war path : %s", new Object[]{warUrlString});
        WebAppContext wac = new WebAppContext(warUrlString, "/");
        if (this.dc.hasAppDefaultsDescriptor()) {
            wac.setDefaultsDescriptor(this.dc.getAppDefaultsDescriptor());
        }
        wac.setExtraClasspath(this.dc.getAppClasspath());
        this.server.setHandler((Handler)wac);
    }

    public void run() {
        block7: {
            try {
                this.prepare();
                this.server.start();
                if (this.dc.has("app-jsp-extpath")) {
                    String[] ss;
                    WebAppContext wac = (WebAppContext)this.server.getHandler();
                    ComboResource cr = new ComboResource(wac.getBaseResource());
                    for (String s : ss = Strings.splitIgnoreBlank((String)this.dc.trim("app-jsp-extpath"), (String)"[,\n]")) {
                        Resource r;
                        File d = Files.findFile((String)s);
                        if (null == d || !(r = Resource.newResource((URI)d.toURI())).exists()) continue;
                        cr.addResource(r);
                    }
                    wac.setBaseResource((Resource)cr);
                }
                Request req = Request.create((String)("http://127.0.0.1:" + this.dc.getAppPort()), (Request.METHOD)Request.METHOD.GET);
                req.getHeader().set("NoProxy", "close");
                Response resp = Sender.create((Request)req).setTimeout(15000).send();
                if (resp == null || resp.getStatus() >= 500) {
                    log.error((Object)"Self-Testing fail !!Server start fail?!!");
                    this.server.stop();
                    return;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)"Server is up!");
                }
                if (log.isInfoEnabled()) {
                    log.infof("Create admin port at %d", new Object[]{this.dc.getAdminPort()});
                }
                Sockets.localListenOne((int)this.dc.getAdminPort(), (String)"stop", (SocketAction)new SocketAction(){

                    public void run(SocketContext context) {
                        block3: {
                            if (null != WebServer.this.server) {
                                try {
                                    WebServer.this.server.stop();
                                }
                                catch (Exception e4stop) {
                                    if (!log.isErrorEnabled()) break block3;
                                    log.error((Object)"Fail to stop!", (Throwable)e4stop);
                                }
                            }
                        }
                        Sockets.close();
                    }
                });
            }
            catch (Throwable e) {
                if (!log.isWarnEnabled()) break block7;
                log.warn((Object)"Unknow error", e);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (null != this.server) {
            try {
                this.server.stop();
            }
            catch (Throwable e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Fail to stop!", e);
                }
                throw e;
            }
        }
        super.finalize();
    }
}

