/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web;

import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.web.NutOnlyWebServer;
import org.nutz.web.WebConfig;
import org.nutz.web.WebServer;

public class WebLauncher {
    private static final Log log = Logs.get();

    public static void main(String[] args) {
        WebLauncher.start(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String ... args) {
        String path = Strings.sBlank((Object)Lang.first((Object)args), (String)"web.properties");
        File f = Files.findFile((String)path);
        log.infof("launch by '%s'", new Object[]{f});
        Reader r = Streams.fileInr((File)f);
        try {
            WebServer server = new WebServer(new WebConfig(r));
            server.run();
        }
        finally {
            Streams.safeClose((Closeable)r);
        }
        log.info((Object)"Server is down!");
    }

    public static void startNutOnlyWebapp(String ... args) {
        String path = Strings.sBlank((Object)Lang.first((Object)args), (String)"web.properties");
        log.infof("launch by '%s'", new Object[]{path});
        NutOnlyWebServer server = new NutOnlyWebServer(new WebConfig(path));
        server.run();
        log.info((Object)"Server is down!");
    }
}

