/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.web;

import java.io.Reader;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.segment.Segments;
import org.nutz.lang.util.Disks;
import org.nutz.web.jsp.RsScaner;

public class WebConfig
extends PropertiesProxy {
    public static String JUNIT_DB_SUFFIX = "";
    public static final String APP_ROOT = "app-root";
    public static final String APP_PORT = "app-port";
    public static final String APP_RS = "app-rs";
    public static final String APP_CLASSPATH = "app-classpath";
    public static final String ADMIN_PORT = "admin-port";
    public static final String APP_DEFAULTS_DESCRIPTOR = "app-defaults-descriptor";
    public static final String MACRO_INCLUDE = "$include";

    public String getAppRoot() {
        return Disks.absolute((String)this.get(APP_ROOT));
    }

    public int getAppPort() {
        return this.getInt(APP_PORT);
    }

    public String getAppRs() {
        return this.get(APP_RS);
    }

    public String getAppClasspath() {
        return this.get(APP_CLASSPATH);
    }

    public int getAdminPort() {
        return this.getInt(ADMIN_PORT, this.getInt(APP_PORT) + 1);
    }

    public String getAppDefaultsDescriptor() {
        return this.get(APP_DEFAULTS_DESCRIPTOR);
    }

    public boolean hasAppDefaultsDescriptor() {
        return this.has(APP_DEFAULTS_DESCRIPTOR);
    }

    public String getAppName() {
        return this.get("app-name");
    }

    public String getAppExtrs() {
        return this.get("app-extrs");
    }

    public String getAppAnnPaths() {
        return this.get("app-ann-paths");
    }

    public String getAppModules() {
        return this.get("app-modules");
    }

    public RsScaner getScaner() {
        RsScaner jrs = new RsScaner();
        jrs.setRs(this.check(APP_RS));
        jrs.setRsHome(this.check("app-rs-home"));
        jrs.setSegCss(Segments.create((String)this.check("app-rs-css")));
        jrs.setSegJs(Segments.create((String)this.check("app-rs-script")));
        jrs.setScanPaths(Strings.splitIgnoreBlank((String)this.check("app-rs-scan-path"), (String)"\n"));
        jrs.setForce("force".equalsIgnoreCase(this.get("app-rs-scan", "force")));
        return jrs;
    }

    public WebConfig(String path) {
        super(new String[]{path});
        this.joinByKey(MACRO_INCLUDE);
    }

    public WebConfig(Reader r) {
        super(r);
        this.joinByKey(MACRO_INCLUDE);
    }

    public String check(String key) {
        String val = this.get(key);
        if (null == val) {
            throw Lang.makeThrow((String)"Ioc.$conf expect property '%s'", (Object[])new Object[]{key});
        }
        return val;
    }
}

