/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.util.function.Supplier;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class PageCacheAndDependenciesRule
implements TestRule {
    private final RuleChain chain;
    private final FileSystemRule<? extends FileSystemAbstraction> fs;
    private final TestDirectory directory;
    private final PageCacheRule pageCacheRule = new PageCacheRule();

    public PageCacheAndDependenciesRule() {
        this(() -> new EphemeralFileSystemRule());
    }

    public PageCacheAndDependenciesRule(Supplier<FileSystemRule<? extends FileSystemAbstraction>> fsSupplier) {
        this.fs = fsSupplier.get();
        this.directory = TestDirectory.testDirectory(this.fs);
        this.chain = RuleChain.outerRule(this.fs).around((TestRule)this.directory).around((TestRule)this.pageCacheRule);
    }

    public Statement apply(Statement base, Description description) {
        return this.chain.apply(base, description);
    }

    public FileSystemRule<? extends FileSystemAbstraction> fileSystemRule() {
        return this.fs;
    }

    public FileSystemAbstraction fileSystem() {
        return this.fs.get();
    }

    public TestDirectory directory() {
        return this.directory;
    }

    public PageCacheRule pageCacheRule() {
        return this.pageCacheRule;
    }

    public PageCache pageCache() {
        return this.pageCacheRule.getPageCache(this.fs);
    }
}

